
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "from",
    "to"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Failover implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("from")
    @JsonPropertyDescription("")
    private String from;
    /**
     * 
     * 
     */
    @JsonProperty("to")
    @JsonPropertyDescription("")
    private String to;
    private final static long serialVersionUID = -3069056107888771142L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Failover() {
    }

    /**
     * 
     * @param from
     * @param to
     */
    public Failover(String from, String to) {
        super();
        this.from = from;
        this.to = to;
    }

    /**
     * 
     * 
     */
    @JsonProperty("from")
    public String getFrom() {
        return from;
    }

    /**
     * 
     * 
     */
    @JsonProperty("from")
    public void setFrom(String from) {
        this.from = from;
    }

    /**
     * 
     * 
     */
    @JsonProperty("to")
    public String getTo() {
        return to;
    }

    /**
     * 
     * 
     */
    @JsonProperty("to")
    public void setTo(String to) {
        this.to = to;
    }

}
