
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "distribute",
    "failover"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class LocalityLoadBalancerSetting implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("distribute")
    @JsonPropertyDescription("")
    private List<Distribute> distribute = new ArrayList<Distribute>();
    /**
     * 
     * 
     */
    @JsonProperty("failover")
    @JsonPropertyDescription("")
    private List<Failover> failover = new ArrayList<Failover>();
    private final static long serialVersionUID = -5364185318114487653L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LocalityLoadBalancerSetting() {
    }

    /**
     * 
     * @param failover
     * @param distribute
     */
    public LocalityLoadBalancerSetting(List<Distribute> distribute, List<Failover> failover) {
        super();
        this.distribute = distribute;
        this.failover = failover;
    }

    /**
     * 
     * 
     */
    @JsonProperty("distribute")
    public List<Distribute> getDistribute() {
        return distribute;
    }

    /**
     * 
     * 
     */
    @JsonProperty("distribute")
    public void setDistribute(List<Distribute> distribute) {
        this.distribute = distribute;
    }

    /**
     * 
     * 
     */
    @JsonProperty("failover")
    public List<Failover> getFailover() {
        return failover;
    }

    /**
     * 
     * 
     */
    @JsonProperty("failover")
    public void setFailover(List<Failover> failover) {
        this.failover = failover;
    }

}
