package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class LocalityLoadBalancerSettingFluentImpl<A extends LocalityLoadBalancerSettingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LocalityLoadBalancerSettingFluent<A>{

    private List<DistributeBuilder> distribute;
    private List<FailoverBuilder> failover;

    public LocalityLoadBalancerSettingFluentImpl(){
    }
    public LocalityLoadBalancerSettingFluentImpl(LocalityLoadBalancerSetting instance){
            this.withDistribute(instance.getDistribute()); 
            this.withFailover(instance.getFailover()); 
    }

    public A addToDistribute(int index,Distribute item){
            if (this.distribute == null) {this.distribute = new ArrayList<DistributeBuilder>();}
            DistributeBuilder builder = new DistributeBuilder(item);_visitables.get("distribute").add(index >= 0 ? index : _visitables.get("distribute").size(), builder);this.distribute.add(index >= 0 ? index : distribute.size(), builder); return (A)this;
    }

    public A setToDistribute(int index,Distribute item){
            if (this.distribute == null) {this.distribute = new ArrayList<DistributeBuilder>();}
            DistributeBuilder builder = new DistributeBuilder(item);
            if (index < 0 || index >= _visitables.get("distribute").size()) { _visitables.get("distribute").add(builder); } else { _visitables.get("distribute").set(index, builder);}
            if (index < 0 || index >= distribute.size()) { distribute.add(builder); } else { distribute.set(index, builder);}
             return (A)this;
    }

    public A addToDistribute(Distribute... items){
            if (this.distribute == null) {this.distribute = new ArrayList<DistributeBuilder>();}
            for (Distribute item : items) {DistributeBuilder builder = new DistributeBuilder(item);_visitables.get("distribute").add(builder);this.distribute.add(builder);} return (A)this;
    }

    public A addAllToDistribute(Collection<Distribute> items){
            if (this.distribute == null) {this.distribute = new ArrayList<DistributeBuilder>();}
            for (Distribute item : items) {DistributeBuilder builder = new DistributeBuilder(item);_visitables.get("distribute").add(builder);this.distribute.add(builder);} return (A)this;
    }

    public A removeFromDistribute(Distribute... items){
            for (Distribute item : items) {DistributeBuilder builder = new DistributeBuilder(item);_visitables.get("distribute").remove(builder);if (this.distribute != null) {this.distribute.remove(builder);}} return (A)this;
    }

    public A removeAllFromDistribute(Collection<Distribute> items){
            for (Distribute item : items) {DistributeBuilder builder = new DistributeBuilder(item);_visitables.get("distribute").remove(builder);if (this.distribute != null) {this.distribute.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDistribute(io.fabric8.kubernetes.api.builder.Predicate<DistributeBuilder> predicate){
            if (distribute == null) return (A) this;
            final Iterator<DistributeBuilder> each = distribute.iterator();
            final List visitables = _visitables.get("distribute");
            while (each.hasNext()) {
              DistributeBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDistribute instead.
 * @return The buildable object.
 */
@Deprecated public List<Distribute> getDistribute(){
            return build(distribute);
    }

    public List<Distribute> buildDistribute(){
            return build(distribute);
    }

    public Distribute buildDistribute(int index){
            return this.distribute.get(index).build();
    }

    public Distribute buildFirstDistribute(){
            return this.distribute.get(0).build();
    }

    public Distribute buildLastDistribute(){
            return this.distribute.get(distribute.size() - 1).build();
    }

    public Distribute buildMatchingDistribute(io.fabric8.kubernetes.api.builder.Predicate<DistributeBuilder> predicate){
            for (DistributeBuilder item: distribute) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDistribute(io.fabric8.kubernetes.api.builder.Predicate<DistributeBuilder> predicate){
            for (DistributeBuilder item: distribute) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDistribute(List<Distribute> distribute){
            if (this.distribute != null) { _visitables.get("distribute").removeAll(this.distribute);}
            if (distribute != null) {this.distribute = new ArrayList<DistributeBuilder>(); for (Distribute item : distribute){this.addToDistribute(item);}} else { this.distribute = null;} return (A) this;
    }

    public A withDistribute(Distribute... distribute){
            if (this.distribute != null) {this.distribute.clear();}
            if (distribute != null) {for (Distribute item :distribute){ this.addToDistribute(item);}} return (A) this;
    }

    public Boolean hasDistribute(){
            return distribute != null && !distribute.isEmpty();
    }

    public LocalityLoadBalancerSettingFluent.DistributeNested<A> addNewDistribute(){
            return new DistributeNestedImpl();
    }

    public LocalityLoadBalancerSettingFluent.DistributeNested<A> addNewDistributeLike(Distribute item){
            return new DistributeNestedImpl(-1, item);
    }

    public LocalityLoadBalancerSettingFluent.DistributeNested<A> setNewDistributeLike(int index,Distribute item){
            return new DistributeNestedImpl(index, item);
    }

    public LocalityLoadBalancerSettingFluent.DistributeNested<A> editDistribute(int index){
            if (distribute.size() <= index) throw new RuntimeException("Can't edit distribute. Index exceeds size.");
            return setNewDistributeLike(index, buildDistribute(index));
    }

    public LocalityLoadBalancerSettingFluent.DistributeNested<A> editFirstDistribute(){
            if (distribute.size() == 0) throw new RuntimeException("Can't edit first distribute. The list is empty.");
            return setNewDistributeLike(0, buildDistribute(0));
    }

    public LocalityLoadBalancerSettingFluent.DistributeNested<A> editLastDistribute(){
            int index = distribute.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last distribute. The list is empty.");
            return setNewDistributeLike(index, buildDistribute(index));
    }

    public LocalityLoadBalancerSettingFluent.DistributeNested<A> editMatchingDistribute(io.fabric8.kubernetes.api.builder.Predicate<DistributeBuilder> predicate){
            int index = -1;
            for (int i=0;i<distribute.size();i++) { 
            if (predicate.apply(distribute.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching distribute. No match found.");
            return setNewDistributeLike(index, buildDistribute(index));
    }

    public A addToFailover(int index,Failover item){
            if (this.failover == null) {this.failover = new ArrayList<FailoverBuilder>();}
            FailoverBuilder builder = new FailoverBuilder(item);_visitables.get("failover").add(index >= 0 ? index : _visitables.get("failover").size(), builder);this.failover.add(index >= 0 ? index : failover.size(), builder); return (A)this;
    }

    public A setToFailover(int index,Failover item){
            if (this.failover == null) {this.failover = new ArrayList<FailoverBuilder>();}
            FailoverBuilder builder = new FailoverBuilder(item);
            if (index < 0 || index >= _visitables.get("failover").size()) { _visitables.get("failover").add(builder); } else { _visitables.get("failover").set(index, builder);}
            if (index < 0 || index >= failover.size()) { failover.add(builder); } else { failover.set(index, builder);}
             return (A)this;
    }

    public A addToFailover(Failover... items){
            if (this.failover == null) {this.failover = new ArrayList<FailoverBuilder>();}
            for (Failover item : items) {FailoverBuilder builder = new FailoverBuilder(item);_visitables.get("failover").add(builder);this.failover.add(builder);} return (A)this;
    }

    public A addAllToFailover(Collection<Failover> items){
            if (this.failover == null) {this.failover = new ArrayList<FailoverBuilder>();}
            for (Failover item : items) {FailoverBuilder builder = new FailoverBuilder(item);_visitables.get("failover").add(builder);this.failover.add(builder);} return (A)this;
    }

    public A removeFromFailover(Failover... items){
            for (Failover item : items) {FailoverBuilder builder = new FailoverBuilder(item);_visitables.get("failover").remove(builder);if (this.failover != null) {this.failover.remove(builder);}} return (A)this;
    }

    public A removeAllFromFailover(Collection<Failover> items){
            for (Failover item : items) {FailoverBuilder builder = new FailoverBuilder(item);_visitables.get("failover").remove(builder);if (this.failover != null) {this.failover.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromFailover(io.fabric8.kubernetes.api.builder.Predicate<FailoverBuilder> predicate){
            if (failover == null) return (A) this;
            final Iterator<FailoverBuilder> each = failover.iterator();
            final List visitables = _visitables.get("failover");
            while (each.hasNext()) {
              FailoverBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildFailover instead.
 * @return The buildable object.
 */
@Deprecated public List<Failover> getFailover(){
            return build(failover);
    }

    public List<Failover> buildFailover(){
            return build(failover);
    }

    public Failover buildFailover(int index){
            return this.failover.get(index).build();
    }

    public Failover buildFirstFailover(){
            return this.failover.get(0).build();
    }

    public Failover buildLastFailover(){
            return this.failover.get(failover.size() - 1).build();
    }

    public Failover buildMatchingFailover(io.fabric8.kubernetes.api.builder.Predicate<FailoverBuilder> predicate){
            for (FailoverBuilder item: failover) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingFailover(io.fabric8.kubernetes.api.builder.Predicate<FailoverBuilder> predicate){
            for (FailoverBuilder item: failover) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withFailover(List<Failover> failover){
            if (this.failover != null) { _visitables.get("failover").removeAll(this.failover);}
            if (failover != null) {this.failover = new ArrayList<FailoverBuilder>(); for (Failover item : failover){this.addToFailover(item);}} else { this.failover = null;} return (A) this;
    }

    public A withFailover(Failover... failover){
            if (this.failover != null) {this.failover.clear();}
            if (failover != null) {for (Failover item :failover){ this.addToFailover(item);}} return (A) this;
    }

    public Boolean hasFailover(){
            return failover != null && !failover.isEmpty();
    }

    public A addNewFailover(String from,String to){
            return (A)addToFailover(new Failover(from, to));
    }

    public LocalityLoadBalancerSettingFluent.FailoverNested<A> addNewFailover(){
            return new FailoverNestedImpl();
    }

    public LocalityLoadBalancerSettingFluent.FailoverNested<A> addNewFailoverLike(Failover item){
            return new FailoverNestedImpl(-1, item);
    }

    public LocalityLoadBalancerSettingFluent.FailoverNested<A> setNewFailoverLike(int index,Failover item){
            return new FailoverNestedImpl(index, item);
    }

    public LocalityLoadBalancerSettingFluent.FailoverNested<A> editFailover(int index){
            if (failover.size() <= index) throw new RuntimeException("Can't edit failover. Index exceeds size.");
            return setNewFailoverLike(index, buildFailover(index));
    }

    public LocalityLoadBalancerSettingFluent.FailoverNested<A> editFirstFailover(){
            if (failover.size() == 0) throw new RuntimeException("Can't edit first failover. The list is empty.");
            return setNewFailoverLike(0, buildFailover(0));
    }

    public LocalityLoadBalancerSettingFluent.FailoverNested<A> editLastFailover(){
            int index = failover.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last failover. The list is empty.");
            return setNewFailoverLike(index, buildFailover(index));
    }

    public LocalityLoadBalancerSettingFluent.FailoverNested<A> editMatchingFailover(io.fabric8.kubernetes.api.builder.Predicate<FailoverBuilder> predicate){
            int index = -1;
            for (int i=0;i<failover.size();i++) { 
            if (predicate.apply(failover.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching failover. No match found.");
            return setNewFailoverLike(index, buildFailover(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LocalityLoadBalancerSettingFluentImpl that = (LocalityLoadBalancerSettingFluentImpl) o;
            if (distribute != null ? !distribute.equals(that.distribute) :that.distribute != null) return false;
            if (failover != null ? !failover.equals(that.failover) :that.failover != null) return false;
            return true;
    }


    public class DistributeNestedImpl<N> extends DistributeFluentImpl<LocalityLoadBalancerSettingFluent.DistributeNested<N>> implements LocalityLoadBalancerSettingFluent.DistributeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DistributeBuilder builder;
        private final int index;
    
            DistributeNestedImpl(int index,Distribute item){
                    this.index = index;
                    this.builder = new DistributeBuilder(this, item);
            }
            DistributeNestedImpl(){
                    this.index = -1;
                    this.builder = new DistributeBuilder(this);
            }
    
    public N and(){
            return (N) LocalityLoadBalancerSettingFluentImpl.this.setToDistribute(index, builder.build());
    }
    public N endDistribute(){
            return and();
    }

}
    public class FailoverNestedImpl<N> extends FailoverFluentImpl<LocalityLoadBalancerSettingFluent.FailoverNested<N>> implements LocalityLoadBalancerSettingFluent.FailoverNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FailoverBuilder builder;
        private final int index;
    
            FailoverNestedImpl(int index,Failover item){
                    this.index = index;
                    this.builder = new FailoverBuilder(this, item);
            }
            FailoverNestedImpl(){
                    this.index = -1;
                    this.builder = new FailoverBuilder(this);
            }
    
    public N and(){
            return (N) LocalityLoadBalancerSettingFluentImpl.this.setToFailover(index, builder.build());
    }
    public N endFailover(){
            return and();
    }

}


}
