
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepalive;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "accessLogEncoding",
    "accessLogFile",
    "accessLogFormat",
    "authPolicy",
    "configSources",
    "connectTimeout",
    "defaultConfig",
    "defaultDestinationRuleExportTo",
    "defaultServiceExportTo",
    "defaultVirtualServiceExportTo",
    "disablePolicyChecks",
    "dnsRefreshRate",
    "enableClientSidePolicyCheck",
    "enableSdsTokenMount",
    "enableTracing",
    "ingressClass",
    "ingressControllerMode",
    "ingressService",
    "localityLbSetting",
    "mixerAddress",
    "mixerCheckServer",
    "mixerReportServer",
    "outboundTrafficPolicy",
    "policyCheckFailOpen",
    "proxyHttpPort",
    "proxyListenPort",
    "rdsRefreshDelay",
    "rootNamespace",
    "sdsRefreshDelay",
    "sdsUdsPath",
    "sdsUseK8sSaJwt",
    "sidecarToTelemetrySessionAffinity",
    "tcpKeepalive",
    "trustDomain"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MeshConfig implements Serializable
{

    @JsonProperty("accessLogEncoding")
    private AccessLogEncoding accessLogEncoding;
    /**
     * 
     * 
     */
    @JsonProperty("accessLogFile")
    @JsonPropertyDescription("")
    private String accessLogFile;
    /**
     * 
     * 
     */
    @JsonProperty("accessLogFormat")
    @JsonPropertyDescription("")
    private String accessLogFormat;
    @JsonProperty("authPolicy")
    private AuthenticationPolicy authPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("configSources")
    @JsonPropertyDescription("")
    private List<ConfigSource> configSources = new ArrayList<ConfigSource>();
    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    @JsonPropertyDescription("")
    private Duration connectTimeout;
    /**
     * 
     * 
     */
    @JsonProperty("defaultConfig")
    @JsonPropertyDescription("")
    private ProxyConfig defaultConfig;
    /**
     * 
     * 
     */
    @JsonProperty("defaultDestinationRuleExportTo")
    @JsonPropertyDescription("")
    private List<String> defaultDestinationRuleExportTo = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("defaultServiceExportTo")
    @JsonPropertyDescription("")
    private List<String> defaultServiceExportTo = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("defaultVirtualServiceExportTo")
    @JsonPropertyDescription("")
    private List<String> defaultVirtualServiceExportTo = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("disablePolicyChecks")
    @JsonPropertyDescription("")
    private Boolean disablePolicyChecks;
    /**
     * 
     * 
     */
    @JsonProperty("dnsRefreshRate")
    @JsonPropertyDescription("")
    private Duration dnsRefreshRate;
    /**
     * 
     * 
     */
    @JsonProperty("enableClientSidePolicyCheck")
    @JsonPropertyDescription("")
    private Boolean enableClientSidePolicyCheck;
    /**
     * 
     * 
     */
    @JsonProperty("enableSdsTokenMount")
    @JsonPropertyDescription("")
    private Boolean enableSdsTokenMount;
    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    @JsonPropertyDescription("")
    private Boolean enableTracing;
    /**
     * 
     * 
     */
    @JsonProperty("ingressClass")
    @JsonPropertyDescription("")
    private String ingressClass;
    @JsonProperty("ingressControllerMode")
    private IngressControllerMode ingressControllerMode;
    /**
     * 
     * 
     */
    @JsonProperty("ingressService")
    @JsonPropertyDescription("")
    private String ingressService;
    /**
     * 
     * 
     */
    @JsonProperty("localityLbSetting")
    @JsonPropertyDescription("")
    private LocalityLoadBalancerSetting localityLbSetting;
    /**
     * 
     * 
     */
    @JsonProperty("mixerAddress")
    @JsonPropertyDescription("")
    private String mixerAddress;
    /**
     * 
     * 
     */
    @JsonProperty("mixerCheckServer")
    @JsonPropertyDescription("")
    private String mixerCheckServer;
    /**
     * 
     * 
     */
    @JsonProperty("mixerReportServer")
    @JsonPropertyDescription("")
    private String mixerReportServer;
    /**
     * 
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    @JsonPropertyDescription("")
    private OutboundTrafficPolicy outboundTrafficPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("policyCheckFailOpen")
    @JsonPropertyDescription("")
    private Boolean policyCheckFailOpen;
    /**
     * 
     * 
     */
    @JsonProperty("proxyHttpPort")
    @JsonPropertyDescription("")
    private Integer proxyHttpPort;
    /**
     * 
     * 
     */
    @JsonProperty("proxyListenPort")
    @JsonPropertyDescription("")
    private Integer proxyListenPort;
    /**
     * 
     * 
     */
    @JsonProperty("rdsRefreshDelay")
    @JsonPropertyDescription("")
    private Duration rdsRefreshDelay;
    /**
     * 
     * 
     */
    @JsonProperty("rootNamespace")
    @JsonPropertyDescription("")
    private String rootNamespace;
    /**
     * 
     * 
     */
    @JsonProperty("sdsRefreshDelay")
    @JsonPropertyDescription("")
    private Duration sdsRefreshDelay;
    /**
     * 
     * 
     */
    @JsonProperty("sdsUdsPath")
    @JsonPropertyDescription("")
    private String sdsUdsPath;
    /**
     * 
     * 
     */
    @JsonProperty("sdsUseK8sSaJwt")
    @JsonPropertyDescription("")
    private Boolean sdsUseK8sSaJwt;
    /**
     * 
     * 
     */
    @JsonProperty("sidecarToTelemetrySessionAffinity")
    @JsonPropertyDescription("")
    private Boolean sidecarToTelemetrySessionAffinity;
    /**
     * 
     * 
     */
    @JsonProperty("tcpKeepalive")
    @JsonPropertyDescription("")
    private TcpKeepalive tcpKeepalive;
    /**
     * 
     * 
     */
    @JsonProperty("trustDomain")
    @JsonPropertyDescription("")
    private String trustDomain;
    private final static long serialVersionUID = 4297994453228555473L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MeshConfig() {
    }

    /**
     * 
     * @param sdsUseK8sSaJwt
     * @param enableClientSidePolicyCheck
     * @param dnsRefreshRate
     * @param authPolicy
     * @param ingressClass
     * @param ingressControllerMode
     * @param mixerReportServer
     * @param defaultServiceExportTo
     * @param configSources
     * @param disablePolicyChecks
     * @param trustDomain
     * @param defaultVirtualServiceExportTo
     * @param defaultDestinationRuleExportTo
     * @param sdsUdsPath
     * @param defaultConfig
     * @param sidecarToTelemetrySessionAffinity
     * @param connectTimeout
     * @param enableSdsTokenMount
     * @param mixerAddress
     * @param accessLogEncoding
     * @param sdsRefreshDelay
     * @param proxyListenPort
     * @param policyCheckFailOpen
     * @param accessLogFile
     * @param enableTracing
     * @param mixerCheckServer
     * @param accessLogFormat
     * @param outboundTrafficPolicy
     * @param ingressService
     * @param proxyHttpPort
     * @param rdsRefreshDelay
     * @param localityLbSetting
     * @param tcpKeepalive
     * @param rootNamespace
     */
    public MeshConfig(AccessLogEncoding accessLogEncoding, String accessLogFile, String accessLogFormat, AuthenticationPolicy authPolicy, List<ConfigSource> configSources, Duration connectTimeout, ProxyConfig defaultConfig, List<String> defaultDestinationRuleExportTo, List<String> defaultServiceExportTo, List<String> defaultVirtualServiceExportTo, Boolean disablePolicyChecks, Duration dnsRefreshRate, Boolean enableClientSidePolicyCheck, Boolean enableSdsTokenMount, Boolean enableTracing, String ingressClass, IngressControllerMode ingressControllerMode, String ingressService, LocalityLoadBalancerSetting localityLbSetting, String mixerAddress, String mixerCheckServer, String mixerReportServer, OutboundTrafficPolicy outboundTrafficPolicy, Boolean policyCheckFailOpen, Integer proxyHttpPort, Integer proxyListenPort, Duration rdsRefreshDelay, String rootNamespace, Duration sdsRefreshDelay, String sdsUdsPath, Boolean sdsUseK8sSaJwt, Boolean sidecarToTelemetrySessionAffinity, TcpKeepalive tcpKeepalive, String trustDomain) {
        super();
        this.accessLogEncoding = accessLogEncoding;
        this.accessLogFile = accessLogFile;
        this.accessLogFormat = accessLogFormat;
        this.authPolicy = authPolicy;
        this.configSources = configSources;
        this.connectTimeout = connectTimeout;
        this.defaultConfig = defaultConfig;
        this.defaultDestinationRuleExportTo = defaultDestinationRuleExportTo;
        this.defaultServiceExportTo = defaultServiceExportTo;
        this.defaultVirtualServiceExportTo = defaultVirtualServiceExportTo;
        this.disablePolicyChecks = disablePolicyChecks;
        this.dnsRefreshRate = dnsRefreshRate;
        this.enableClientSidePolicyCheck = enableClientSidePolicyCheck;
        this.enableSdsTokenMount = enableSdsTokenMount;
        this.enableTracing = enableTracing;
        this.ingressClass = ingressClass;
        this.ingressControllerMode = ingressControllerMode;
        this.ingressService = ingressService;
        this.localityLbSetting = localityLbSetting;
        this.mixerAddress = mixerAddress;
        this.mixerCheckServer = mixerCheckServer;
        this.mixerReportServer = mixerReportServer;
        this.outboundTrafficPolicy = outboundTrafficPolicy;
        this.policyCheckFailOpen = policyCheckFailOpen;
        this.proxyHttpPort = proxyHttpPort;
        this.proxyListenPort = proxyListenPort;
        this.rdsRefreshDelay = rdsRefreshDelay;
        this.rootNamespace = rootNamespace;
        this.sdsRefreshDelay = sdsRefreshDelay;
        this.sdsUdsPath = sdsUdsPath;
        this.sdsUseK8sSaJwt = sdsUseK8sSaJwt;
        this.sidecarToTelemetrySessionAffinity = sidecarToTelemetrySessionAffinity;
        this.tcpKeepalive = tcpKeepalive;
        this.trustDomain = trustDomain;
    }

    @JsonProperty("accessLogEncoding")
    public AccessLogEncoding getAccessLogEncoding() {
        return accessLogEncoding;
    }

    @JsonProperty("accessLogEncoding")
    public void setAccessLogEncoding(AccessLogEncoding accessLogEncoding) {
        this.accessLogEncoding = accessLogEncoding;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessLogFile")
    public String getAccessLogFile() {
        return accessLogFile;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessLogFile")
    public void setAccessLogFile(String accessLogFile) {
        this.accessLogFile = accessLogFile;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessLogFormat")
    public String getAccessLogFormat() {
        return accessLogFormat;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessLogFormat")
    public void setAccessLogFormat(String accessLogFormat) {
        this.accessLogFormat = accessLogFormat;
    }

    @JsonProperty("authPolicy")
    public AuthenticationPolicy getAuthPolicy() {
        return authPolicy;
    }

    @JsonProperty("authPolicy")
    public void setAuthPolicy(AuthenticationPolicy authPolicy) {
        this.authPolicy = authPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("configSources")
    public List<ConfigSource> getConfigSources() {
        return configSources;
    }

    /**
     * 
     * 
     */
    @JsonProperty("configSources")
    public void setConfigSources(List<ConfigSource> configSources) {
        this.configSources = configSources;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultConfig")
    public ProxyConfig getDefaultConfig() {
        return defaultConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultConfig")
    public void setDefaultConfig(ProxyConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultDestinationRuleExportTo")
    public List<String> getDefaultDestinationRuleExportTo() {
        return defaultDestinationRuleExportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultDestinationRuleExportTo")
    public void setDefaultDestinationRuleExportTo(List<String> defaultDestinationRuleExportTo) {
        this.defaultDestinationRuleExportTo = defaultDestinationRuleExportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultServiceExportTo")
    public List<String> getDefaultServiceExportTo() {
        return defaultServiceExportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultServiceExportTo")
    public void setDefaultServiceExportTo(List<String> defaultServiceExportTo) {
        this.defaultServiceExportTo = defaultServiceExportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultVirtualServiceExportTo")
    public List<String> getDefaultVirtualServiceExportTo() {
        return defaultVirtualServiceExportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("defaultVirtualServiceExportTo")
    public void setDefaultVirtualServiceExportTo(List<String> defaultVirtualServiceExportTo) {
        this.defaultVirtualServiceExportTo = defaultVirtualServiceExportTo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("disablePolicyChecks")
    public Boolean getDisablePolicyChecks() {
        return disablePolicyChecks;
    }

    /**
     * 
     * 
     */
    @JsonProperty("disablePolicyChecks")
    public void setDisablePolicyChecks(Boolean disablePolicyChecks) {
        this.disablePolicyChecks = disablePolicyChecks;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dnsRefreshRate")
    public Duration getDnsRefreshRate() {
        return dnsRefreshRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("dnsRefreshRate")
    public void setDnsRefreshRate(Duration dnsRefreshRate) {
        this.dnsRefreshRate = dnsRefreshRate;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableClientSidePolicyCheck")
    public Boolean getEnableClientSidePolicyCheck() {
        return enableClientSidePolicyCheck;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableClientSidePolicyCheck")
    public void setEnableClientSidePolicyCheck(Boolean enableClientSidePolicyCheck) {
        this.enableClientSidePolicyCheck = enableClientSidePolicyCheck;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableSdsTokenMount")
    public Boolean getEnableSdsTokenMount() {
        return enableSdsTokenMount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableSdsTokenMount")
    public void setEnableSdsTokenMount(Boolean enableSdsTokenMount) {
        this.enableSdsTokenMount = enableSdsTokenMount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    public Boolean getEnableTracing() {
        return enableTracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("enableTracing")
    public void setEnableTracing(Boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressClass")
    public String getIngressClass() {
        return ingressClass;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressClass")
    public void setIngressClass(String ingressClass) {
        this.ingressClass = ingressClass;
    }

    @JsonProperty("ingressControllerMode")
    public IngressControllerMode getIngressControllerMode() {
        return ingressControllerMode;
    }

    @JsonProperty("ingressControllerMode")
    public void setIngressControllerMode(IngressControllerMode ingressControllerMode) {
        this.ingressControllerMode = ingressControllerMode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressService")
    public String getIngressService() {
        return ingressService;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingressService")
    public void setIngressService(String ingressService) {
        this.ingressService = ingressService;
    }

    /**
     * 
     * 
     */
    @JsonProperty("localityLbSetting")
    public LocalityLoadBalancerSetting getLocalityLbSetting() {
        return localityLbSetting;
    }

    /**
     * 
     * 
     */
    @JsonProperty("localityLbSetting")
    public void setLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting) {
        this.localityLbSetting = localityLbSetting;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerAddress")
    public String getMixerAddress() {
        return mixerAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerAddress")
    public void setMixerAddress(String mixerAddress) {
        this.mixerAddress = mixerAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerCheckServer")
    public String getMixerCheckServer() {
        return mixerCheckServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerCheckServer")
    public void setMixerCheckServer(String mixerCheckServer) {
        this.mixerCheckServer = mixerCheckServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerReportServer")
    public String getMixerReportServer() {
        return mixerReportServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mixerReportServer")
    public void setMixerReportServer(String mixerReportServer) {
        this.mixerReportServer = mixerReportServer;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    public OutboundTrafficPolicy getOutboundTrafficPolicy() {
        return outboundTrafficPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    public void setOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy) {
        this.outboundTrafficPolicy = outboundTrafficPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("policyCheckFailOpen")
    public Boolean getPolicyCheckFailOpen() {
        return policyCheckFailOpen;
    }

    /**
     * 
     * 
     */
    @JsonProperty("policyCheckFailOpen")
    public void setPolicyCheckFailOpen(Boolean policyCheckFailOpen) {
        this.policyCheckFailOpen = policyCheckFailOpen;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyHttpPort")
    public Integer getProxyHttpPort() {
        return proxyHttpPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyHttpPort")
    public void setProxyHttpPort(Integer proxyHttpPort) {
        this.proxyHttpPort = proxyHttpPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyListenPort")
    public Integer getProxyListenPort() {
        return proxyListenPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyListenPort")
    public void setProxyListenPort(Integer proxyListenPort) {
        this.proxyListenPort = proxyListenPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rdsRefreshDelay")
    public Duration getRdsRefreshDelay() {
        return rdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rdsRefreshDelay")
    public void setRdsRefreshDelay(Duration rdsRefreshDelay) {
        this.rdsRefreshDelay = rdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rootNamespace")
    public String getRootNamespace() {
        return rootNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rootNamespace")
    public void setRootNamespace(String rootNamespace) {
        this.rootNamespace = rootNamespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsRefreshDelay")
    public Duration getSdsRefreshDelay() {
        return sdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsRefreshDelay")
    public void setSdsRefreshDelay(Duration sdsRefreshDelay) {
        this.sdsRefreshDelay = sdsRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsUdsPath")
    public String getSdsUdsPath() {
        return sdsUdsPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsUdsPath")
    public void setSdsUdsPath(String sdsUdsPath) {
        this.sdsUdsPath = sdsUdsPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsUseK8sSaJwt")
    public Boolean getSdsUseK8sSaJwt() {
        return sdsUseK8sSaJwt;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sdsUseK8sSaJwt")
    public void setSdsUseK8sSaJwt(Boolean sdsUseK8sSaJwt) {
        this.sdsUseK8sSaJwt = sdsUseK8sSaJwt;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sidecarToTelemetrySessionAffinity")
    public Boolean getSidecarToTelemetrySessionAffinity() {
        return sidecarToTelemetrySessionAffinity;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sidecarToTelemetrySessionAffinity")
    public void setSidecarToTelemetrySessionAffinity(Boolean sidecarToTelemetrySessionAffinity) {
        this.sidecarToTelemetrySessionAffinity = sidecarToTelemetrySessionAffinity;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tcpKeepalive")
    public TcpKeepalive getTcpKeepalive() {
        return tcpKeepalive;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tcpKeepalive")
    public void setTcpKeepalive(TcpKeepalive tcpKeepalive) {
        this.tcpKeepalive = tcpKeepalive;
    }

    /**
     * 
     * 
     */
    @JsonProperty("trustDomain")
    public String getTrustDomain() {
        return trustDomain;
    }

    /**
     * 
     * 
     */
    @JsonProperty("trustDomain")
    public void setTrustDomain(String trustDomain) {
        this.trustDomain = trustDomain;
    }

}
