package me.snowdrop.istio.api.mesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MeshConfigBuilder extends MeshConfigFluentImpl<MeshConfigBuilder> implements VisitableBuilder<MeshConfig,MeshConfigBuilder>{

    MeshConfigFluent<?> fluent;
    Boolean validationEnabled;

    public MeshConfigBuilder(){
            this(true);
    }
    public MeshConfigBuilder(Boolean validationEnabled){
            this(new MeshConfig(), validationEnabled);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent){
            this(fluent, true);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MeshConfig(), validationEnabled);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,MeshConfig instance){
            this(fluent, instance, true);
    }
    public MeshConfigBuilder(MeshConfigFluent<?> fluent,MeshConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessLogEncoding(instance.getAccessLogEncoding()); 
            fluent.withAccessLogFile(instance.getAccessLogFile()); 
            fluent.withAccessLogFormat(instance.getAccessLogFormat()); 
            fluent.withAuthPolicy(instance.getAuthPolicy()); 
            fluent.withConfigSources(instance.getConfigSources()); 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withDefaultConfig(instance.getDefaultConfig()); 
            fluent.withDefaultDestinationRuleExportTo(instance.getDefaultDestinationRuleExportTo()); 
            fluent.withDefaultServiceExportTo(instance.getDefaultServiceExportTo()); 
            fluent.withDefaultVirtualServiceExportTo(instance.getDefaultVirtualServiceExportTo()); 
            fluent.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            fluent.withDnsRefreshRate(instance.getDnsRefreshRate()); 
            fluent.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            fluent.withEnableSdsTokenMount(instance.getEnableSdsTokenMount()); 
            fluent.withEnableTracing(instance.getEnableTracing()); 
            fluent.withIngressClass(instance.getIngressClass()); 
            fluent.withIngressControllerMode(instance.getIngressControllerMode()); 
            fluent.withIngressService(instance.getIngressService()); 
            fluent.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            fluent.withMixerAddress(instance.getMixerAddress()); 
            fluent.withMixerCheckServer(instance.getMixerCheckServer()); 
            fluent.withMixerReportServer(instance.getMixerReportServer()); 
            fluent.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            fluent.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            fluent.withProxyHttpPort(instance.getProxyHttpPort()); 
            fluent.withProxyListenPort(instance.getProxyListenPort()); 
            fluent.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            fluent.withRootNamespace(instance.getRootNamespace()); 
            fluent.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            fluent.withSdsUdsPath(instance.getSdsUdsPath()); 
            fluent.withSdsUseK8sSaJwt(instance.getSdsUseK8sSaJwt()); 
            fluent.withSidecarToTelemetrySessionAffinity(instance.getSidecarToTelemetrySessionAffinity()); 
            fluent.withTcpKeepalive(instance.getTcpKeepalive()); 
            fluent.withTrustDomain(instance.getTrustDomain()); 
            this.validationEnabled = validationEnabled; 
    }
    public MeshConfigBuilder(MeshConfig instance){
            this(instance,true);
    }
    public MeshConfigBuilder(MeshConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessLogEncoding(instance.getAccessLogEncoding()); 
            this.withAccessLogFile(instance.getAccessLogFile()); 
            this.withAccessLogFormat(instance.getAccessLogFormat()); 
            this.withAuthPolicy(instance.getAuthPolicy()); 
            this.withConfigSources(instance.getConfigSources()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withDefaultConfig(instance.getDefaultConfig()); 
            this.withDefaultDestinationRuleExportTo(instance.getDefaultDestinationRuleExportTo()); 
            this.withDefaultServiceExportTo(instance.getDefaultServiceExportTo()); 
            this.withDefaultVirtualServiceExportTo(instance.getDefaultVirtualServiceExportTo()); 
            this.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            this.withDnsRefreshRate(instance.getDnsRefreshRate()); 
            this.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            this.withEnableSdsTokenMount(instance.getEnableSdsTokenMount()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withIngressClass(instance.getIngressClass()); 
            this.withIngressControllerMode(instance.getIngressControllerMode()); 
            this.withIngressService(instance.getIngressService()); 
            this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.withMixerAddress(instance.getMixerAddress()); 
            this.withMixerCheckServer(instance.getMixerCheckServer()); 
            this.withMixerReportServer(instance.getMixerReportServer()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            this.withProxyHttpPort(instance.getProxyHttpPort()); 
            this.withProxyListenPort(instance.getProxyListenPort()); 
            this.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            this.withRootNamespace(instance.getRootNamespace()); 
            this.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            this.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.withSdsUseK8sSaJwt(instance.getSdsUseK8sSaJwt()); 
            this.withSidecarToTelemetrySessionAffinity(instance.getSidecarToTelemetrySessionAffinity()); 
            this.withTcpKeepalive(instance.getTcpKeepalive()); 
            this.withTrustDomain(instance.getTrustDomain()); 
            this.validationEnabled = validationEnabled; 
    }

    public MeshConfig build(){
            MeshConfig buildable = new MeshConfig(fluent.getAccessLogEncoding(),fluent.getAccessLogFile(),fluent.getAccessLogFormat(),fluent.getAuthPolicy(),fluent.getConfigSources(),fluent.getConnectTimeout(),fluent.getDefaultConfig(),fluent.getDefaultDestinationRuleExportTo(),fluent.getDefaultServiceExportTo(),fluent.getDefaultVirtualServiceExportTo(),fluent.isDisablePolicyChecks(),fluent.getDnsRefreshRate(),fluent.isEnableClientSidePolicyCheck(),fluent.isEnableSdsTokenMount(),fluent.isEnableTracing(),fluent.getIngressClass(),fluent.getIngressControllerMode(),fluent.getIngressService(),fluent.getLocalityLbSetting(),fluent.getMixerAddress(),fluent.getMixerCheckServer(),fluent.getMixerReportServer(),fluent.getOutboundTrafficPolicy(),fluent.isPolicyCheckFailOpen(),fluent.getProxyHttpPort(),fluent.getProxyListenPort(),fluent.getRdsRefreshDelay(),fluent.getRootNamespace(),fluent.getSdsRefreshDelay(),fluent.getSdsUdsPath(),fluent.isSdsUseK8sSaJwt(),fluent.isSidecarToTelemetrySessionAffinity(),fluent.getTcpKeepalive(),fluent.getTrustDomain());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MeshConfigBuilder that = (MeshConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
