package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepalive;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import me.snowdrop.istio.api.Duration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;
import me.snowdrop.istio.api.DurationFluentImpl;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.networking.v1alpha3.TcpKeepaliveBuilder;

public class MeshConfigFluentImpl<A extends MeshConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MeshConfigFluent<A>{

    private AccessLogEncoding accessLogEncoding;
    private String accessLogFile;
    private String accessLogFormat;
    private AuthenticationPolicy authPolicy;
    private List<ConfigSourceBuilder> configSources;
    private DurationBuilder connectTimeout;
    private ProxyConfigBuilder defaultConfig;
    private List<String> defaultDestinationRuleExportTo;
    private List<String> defaultServiceExportTo;
    private List<String> defaultVirtualServiceExportTo;
    private Boolean disablePolicyChecks;
    private DurationBuilder dnsRefreshRate;
    private Boolean enableClientSidePolicyCheck;
    private Boolean enableSdsTokenMount;
    private Boolean enableTracing;
    private String ingressClass;
    private IngressControllerMode ingressControllerMode;
    private String ingressService;
    private LocalityLoadBalancerSettingBuilder localityLbSetting;
    private String mixerAddress;
    private String mixerCheckServer;
    private String mixerReportServer;
    private OutboundTrafficPolicyBuilder outboundTrafficPolicy;
    private Boolean policyCheckFailOpen;
    private Integer proxyHttpPort;
    private Integer proxyListenPort;
    private DurationBuilder rdsRefreshDelay;
    private String rootNamespace;
    private DurationBuilder sdsRefreshDelay;
    private String sdsUdsPath;
    private Boolean sdsUseK8sSaJwt;
    private Boolean sidecarToTelemetrySessionAffinity;
    private TcpKeepaliveBuilder tcpKeepalive;
    private String trustDomain;

    public MeshConfigFluentImpl(){
    }
    public MeshConfigFluentImpl(MeshConfig instance){
            this.withAccessLogEncoding(instance.getAccessLogEncoding()); 
            this.withAccessLogFile(instance.getAccessLogFile()); 
            this.withAccessLogFormat(instance.getAccessLogFormat()); 
            this.withAuthPolicy(instance.getAuthPolicy()); 
            this.withConfigSources(instance.getConfigSources()); 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withDefaultConfig(instance.getDefaultConfig()); 
            this.withDefaultDestinationRuleExportTo(instance.getDefaultDestinationRuleExportTo()); 
            this.withDefaultServiceExportTo(instance.getDefaultServiceExportTo()); 
            this.withDefaultVirtualServiceExportTo(instance.getDefaultVirtualServiceExportTo()); 
            this.withDisablePolicyChecks(instance.getDisablePolicyChecks()); 
            this.withDnsRefreshRate(instance.getDnsRefreshRate()); 
            this.withEnableClientSidePolicyCheck(instance.getEnableClientSidePolicyCheck()); 
            this.withEnableSdsTokenMount(instance.getEnableSdsTokenMount()); 
            this.withEnableTracing(instance.getEnableTracing()); 
            this.withIngressClass(instance.getIngressClass()); 
            this.withIngressControllerMode(instance.getIngressControllerMode()); 
            this.withIngressService(instance.getIngressService()); 
            this.withLocalityLbSetting(instance.getLocalityLbSetting()); 
            this.withMixerAddress(instance.getMixerAddress()); 
            this.withMixerCheckServer(instance.getMixerCheckServer()); 
            this.withMixerReportServer(instance.getMixerReportServer()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withPolicyCheckFailOpen(instance.getPolicyCheckFailOpen()); 
            this.withProxyHttpPort(instance.getProxyHttpPort()); 
            this.withProxyListenPort(instance.getProxyListenPort()); 
            this.withRdsRefreshDelay(instance.getRdsRefreshDelay()); 
            this.withRootNamespace(instance.getRootNamespace()); 
            this.withSdsRefreshDelay(instance.getSdsRefreshDelay()); 
            this.withSdsUdsPath(instance.getSdsUdsPath()); 
            this.withSdsUseK8sSaJwt(instance.getSdsUseK8sSaJwt()); 
            this.withSidecarToTelemetrySessionAffinity(instance.getSidecarToTelemetrySessionAffinity()); 
            this.withTcpKeepalive(instance.getTcpKeepalive()); 
            this.withTrustDomain(instance.getTrustDomain()); 
    }

    public AccessLogEncoding getAccessLogEncoding(){
            return this.accessLogEncoding;
    }

    public A withAccessLogEncoding(AccessLogEncoding accessLogEncoding){
            this.accessLogEncoding=accessLogEncoding; return (A) this;
    }

    public Boolean hasAccessLogEncoding(){
            return this.accessLogEncoding != null;
    }

    public String getAccessLogFile(){
            return this.accessLogFile;
    }

    public A withAccessLogFile(String accessLogFile){
            this.accessLogFile=accessLogFile; return (A) this;
    }

    public Boolean hasAccessLogFile(){
            return this.accessLogFile != null;
    }

    public A withNewAccessLogFile(String arg1){
            return (A)withAccessLogFile(new String(arg1));
    }

    public A withNewAccessLogFile(StringBuilder arg1){
            return (A)withAccessLogFile(new String(arg1));
    }

    public A withNewAccessLogFile(StringBuffer arg1){
            return (A)withAccessLogFile(new String(arg1));
    }

    public String getAccessLogFormat(){
            return this.accessLogFormat;
    }

    public A withAccessLogFormat(String accessLogFormat){
            this.accessLogFormat=accessLogFormat; return (A) this;
    }

    public Boolean hasAccessLogFormat(){
            return this.accessLogFormat != null;
    }

    public A withNewAccessLogFormat(String arg1){
            return (A)withAccessLogFormat(new String(arg1));
    }

    public A withNewAccessLogFormat(StringBuilder arg1){
            return (A)withAccessLogFormat(new String(arg1));
    }

    public A withNewAccessLogFormat(StringBuffer arg1){
            return (A)withAccessLogFormat(new String(arg1));
    }

    public AuthenticationPolicy getAuthPolicy(){
            return this.authPolicy;
    }

    public A withAuthPolicy(AuthenticationPolicy authPolicy){
            this.authPolicy=authPolicy; return (A) this;
    }

    public Boolean hasAuthPolicy(){
            return this.authPolicy != null;
    }

    public A addToConfigSources(int index,ConfigSource item){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").add(index >= 0 ? index : _visitables.get("configSources").size(), builder);this.configSources.add(index >= 0 ? index : configSources.size(), builder); return (A)this;
    }

    public A setToConfigSources(int index,ConfigSource item){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            ConfigSourceBuilder builder = new ConfigSourceBuilder(item);
            if (index < 0 || index >= _visitables.get("configSources").size()) { _visitables.get("configSources").add(builder); } else { _visitables.get("configSources").set(index, builder);}
            if (index < 0 || index >= configSources.size()) { configSources.add(builder); } else { configSources.set(index, builder);}
             return (A)this;
    }

    public A addToConfigSources(ConfigSource... items){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").add(builder);this.configSources.add(builder);} return (A)this;
    }

    public A addAllToConfigSources(Collection<ConfigSource> items){
            if (this.configSources == null) {this.configSources = new ArrayList<ConfigSourceBuilder>();}
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").add(builder);this.configSources.add(builder);} return (A)this;
    }

    public A removeFromConfigSources(ConfigSource... items){
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").remove(builder);if (this.configSources != null) {this.configSources.remove(builder);}} return (A)this;
    }

    public A removeAllFromConfigSources(Collection<ConfigSource> items){
            for (ConfigSource item : items) {ConfigSourceBuilder builder = new ConfigSourceBuilder(item);_visitables.get("configSources").remove(builder);if (this.configSources != null) {this.configSources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConfigSources(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            if (configSources == null) return (A) this;
            final Iterator<ConfigSourceBuilder> each = configSources.iterator();
            final List visitables = _visitables.get("configSources");
            while (each.hasNext()) {
              ConfigSourceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConfigSources instead.
 * @return The buildable object.
 */
@Deprecated public List<ConfigSource> getConfigSources(){
            return build(configSources);
    }

    public List<ConfigSource> buildConfigSources(){
            return build(configSources);
    }

    public ConfigSource buildConfigSource(int index){
            return this.configSources.get(index).build();
    }

    public ConfigSource buildFirstConfigSource(){
            return this.configSources.get(0).build();
    }

    public ConfigSource buildLastConfigSource(){
            return this.configSources.get(configSources.size() - 1).build();
    }

    public ConfigSource buildMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            for (ConfigSourceBuilder item: configSources) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            for (ConfigSourceBuilder item: configSources) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConfigSources(List<ConfigSource> configSources){
            if (this.configSources != null) { _visitables.get("configSources").removeAll(this.configSources);}
            if (configSources != null) {this.configSources = new ArrayList<ConfigSourceBuilder>(); for (ConfigSource item : configSources){this.addToConfigSources(item);}} else { this.configSources = null;} return (A) this;
    }

    public A withConfigSources(ConfigSource... configSources){
            if (this.configSources != null) {this.configSources.clear();}
            if (configSources != null) {for (ConfigSource item :configSources){ this.addToConfigSources(item);}} return (A) this;
    }

    public Boolean hasConfigSources(){
            return configSources != null && !configSources.isEmpty();
    }

    public MeshConfigFluent.ConfigSourcesNested<A> addNewConfigSource(){
            return new ConfigSourcesNestedImpl();
    }

    public MeshConfigFluent.ConfigSourcesNested<A> addNewConfigSourceLike(ConfigSource item){
            return new ConfigSourcesNestedImpl(-1, item);
    }

    public MeshConfigFluent.ConfigSourcesNested<A> setNewConfigSourceLike(int index,ConfigSource item){
            return new ConfigSourcesNestedImpl(index, item);
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editConfigSource(int index){
            if (configSources.size() <= index) throw new RuntimeException("Can't edit configSources. Index exceeds size.");
            return setNewConfigSourceLike(index, buildConfigSource(index));
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editFirstConfigSource(){
            if (configSources.size() == 0) throw new RuntimeException("Can't edit first configSources. The list is empty.");
            return setNewConfigSourceLike(0, buildConfigSource(0));
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editLastConfigSource(){
            int index = configSources.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last configSources. The list is empty.");
            return setNewConfigSourceLike(index, buildConfigSource(index));
    }

    public MeshConfigFluent.ConfigSourcesNested<A> editMatchingConfigSource(io.fabric8.kubernetes.api.builder.Predicate<ConfigSourceBuilder> predicate){
            int index = -1;
            for (int i=0;i<configSources.size();i++) { 
            if (predicate.apply(configSources.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching configSources. No match found.");
            return setNewConfigSourceLike(index, buildConfigSource(index));
    }

    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public Duration buildConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public A withConnectTimeout(Duration connectTimeout){
            _visitables.get("connectTimeout").remove(this.connectTimeout);
            if (connectTimeout!=null){ this.connectTimeout= new DurationBuilder(connectTimeout); _visitables.get("connectTimeout").add(this.connectTimeout);} return (A) this;
    }

    public Boolean hasConnectTimeout(){
            return this.connectTimeout != null;
    }

    public A withNewConnectTimeout(Integer nanos,Long seconds){
            return (A)withConnectTimeout(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeout(){
            return new ConnectTimeoutNestedImpl();
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item){
            return new ConnectTimeoutNestedImpl(item);
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout());
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): new DurationBuilder().build());
    }

    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDefaultConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getDefaultConfig(){
            return this.defaultConfig!=null?this.defaultConfig.build():null;
    }

    public ProxyConfig buildDefaultConfig(){
            return this.defaultConfig!=null?this.defaultConfig.build():null;
    }

    public A withDefaultConfig(ProxyConfig defaultConfig){
            _visitables.get("defaultConfig").remove(this.defaultConfig);
            if (defaultConfig!=null){ this.defaultConfig= new ProxyConfigBuilder(defaultConfig); _visitables.get("defaultConfig").add(this.defaultConfig);} return (A) this;
    }

    public Boolean hasDefaultConfig(){
            return this.defaultConfig != null;
    }

    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfig(){
            return new DefaultConfigNestedImpl();
    }

    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfigLike(ProxyConfig item){
            return new DefaultConfigNestedImpl(item);
    }

    public MeshConfigFluent.DefaultConfigNested<A> editDefaultConfig(){
            return withNewDefaultConfigLike(getDefaultConfig());
    }

    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfig(){
            return withNewDefaultConfigLike(getDefaultConfig() != null ? getDefaultConfig(): new ProxyConfigBuilder().build());
    }

    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfigLike(ProxyConfig item){
            return withNewDefaultConfigLike(getDefaultConfig() != null ? getDefaultConfig(): item);
    }

    public A addToDefaultDestinationRuleExportTo(int index,String item){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            this.defaultDestinationRuleExportTo.add(index, item);
            return (A)this;
    }

    public A setToDefaultDestinationRuleExportTo(int index,String item){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            this.defaultDestinationRuleExportTo.set(index, item); return (A)this;
    }

    public A addToDefaultDestinationRuleExportTo(String... items){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultDestinationRuleExportTo.add(item);} return (A)this;
    }

    public A addAllToDefaultDestinationRuleExportTo(Collection<String> items){
            if (this.defaultDestinationRuleExportTo == null) {this.defaultDestinationRuleExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultDestinationRuleExportTo.add(item);} return (A)this;
    }

    public A removeFromDefaultDestinationRuleExportTo(String... items){
            for (String item : items) {if (this.defaultDestinationRuleExportTo!= null){ this.defaultDestinationRuleExportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultDestinationRuleExportTo(Collection<String> items){
            for (String item : items) {if (this.defaultDestinationRuleExportTo!= null){ this.defaultDestinationRuleExportTo.remove(item);}} return (A)this;
    }

    public List<String> getDefaultDestinationRuleExportTo(){
            return this.defaultDestinationRuleExportTo;
    }

    public String getDefaultDestinationRuleExportTo(int index){
            return this.defaultDestinationRuleExportTo.get(index);
    }

    public String getFirstDefaultDestinationRuleExportTo(){
            return this.defaultDestinationRuleExportTo.get(0);
    }

    public String getLastDefaultDestinationRuleExportTo(){
            return this.defaultDestinationRuleExportTo.get(defaultDestinationRuleExportTo.size() - 1);
    }

    public String getMatchingDefaultDestinationRuleExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultDestinationRuleExportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDefaultDestinationRuleExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultDestinationRuleExportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDefaultDestinationRuleExportTo(List<String> defaultDestinationRuleExportTo){
            if (this.defaultDestinationRuleExportTo != null) { _visitables.get("defaultDestinationRuleExportTo").removeAll(this.defaultDestinationRuleExportTo);}
            if (defaultDestinationRuleExportTo != null) {this.defaultDestinationRuleExportTo = new ArrayList<String>(); for (String item : defaultDestinationRuleExportTo){this.addToDefaultDestinationRuleExportTo(item);}} else { this.defaultDestinationRuleExportTo = null;} return (A) this;
    }

    public A withDefaultDestinationRuleExportTo(String... defaultDestinationRuleExportTo){
            if (this.defaultDestinationRuleExportTo != null) {this.defaultDestinationRuleExportTo.clear();}
            if (defaultDestinationRuleExportTo != null) {for (String item :defaultDestinationRuleExportTo){ this.addToDefaultDestinationRuleExportTo(item);}} return (A) this;
    }

    public Boolean hasDefaultDestinationRuleExportTo(){
            return defaultDestinationRuleExportTo != null && !defaultDestinationRuleExportTo.isEmpty();
    }

    public A addNewDefaultDestinationRuleExportTo(String arg1){
            return (A)addToDefaultDestinationRuleExportTo(new String(arg1));
    }

    public A addNewDefaultDestinationRuleExportTo(StringBuilder arg1){
            return (A)addToDefaultDestinationRuleExportTo(new String(arg1));
    }

    public A addNewDefaultDestinationRuleExportTo(StringBuffer arg1){
            return (A)addToDefaultDestinationRuleExportTo(new String(arg1));
    }

    public A addToDefaultServiceExportTo(int index,String item){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            this.defaultServiceExportTo.add(index, item);
            return (A)this;
    }

    public A setToDefaultServiceExportTo(int index,String item){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            this.defaultServiceExportTo.set(index, item); return (A)this;
    }

    public A addToDefaultServiceExportTo(String... items){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultServiceExportTo.add(item);} return (A)this;
    }

    public A addAllToDefaultServiceExportTo(Collection<String> items){
            if (this.defaultServiceExportTo == null) {this.defaultServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultServiceExportTo.add(item);} return (A)this;
    }

    public A removeFromDefaultServiceExportTo(String... items){
            for (String item : items) {if (this.defaultServiceExportTo!= null){ this.defaultServiceExportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultServiceExportTo(Collection<String> items){
            for (String item : items) {if (this.defaultServiceExportTo!= null){ this.defaultServiceExportTo.remove(item);}} return (A)this;
    }

    public List<String> getDefaultServiceExportTo(){
            return this.defaultServiceExportTo;
    }

    public String getDefaultServiceExportTo(int index){
            return this.defaultServiceExportTo.get(index);
    }

    public String getFirstDefaultServiceExportTo(){
            return this.defaultServiceExportTo.get(0);
    }

    public String getLastDefaultServiceExportTo(){
            return this.defaultServiceExportTo.get(defaultServiceExportTo.size() - 1);
    }

    public String getMatchingDefaultServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultServiceExportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDefaultServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultServiceExportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDefaultServiceExportTo(List<String> defaultServiceExportTo){
            if (this.defaultServiceExportTo != null) { _visitables.get("defaultServiceExportTo").removeAll(this.defaultServiceExportTo);}
            if (defaultServiceExportTo != null) {this.defaultServiceExportTo = new ArrayList<String>(); for (String item : defaultServiceExportTo){this.addToDefaultServiceExportTo(item);}} else { this.defaultServiceExportTo = null;} return (A) this;
    }

    public A withDefaultServiceExportTo(String... defaultServiceExportTo){
            if (this.defaultServiceExportTo != null) {this.defaultServiceExportTo.clear();}
            if (defaultServiceExportTo != null) {for (String item :defaultServiceExportTo){ this.addToDefaultServiceExportTo(item);}} return (A) this;
    }

    public Boolean hasDefaultServiceExportTo(){
            return defaultServiceExportTo != null && !defaultServiceExportTo.isEmpty();
    }

    public A addNewDefaultServiceExportTo(String arg1){
            return (A)addToDefaultServiceExportTo(new String(arg1));
    }

    public A addNewDefaultServiceExportTo(StringBuilder arg1){
            return (A)addToDefaultServiceExportTo(new String(arg1));
    }

    public A addNewDefaultServiceExportTo(StringBuffer arg1){
            return (A)addToDefaultServiceExportTo(new String(arg1));
    }

    public A addToDefaultVirtualServiceExportTo(int index,String item){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            this.defaultVirtualServiceExportTo.add(index, item);
            return (A)this;
    }

    public A setToDefaultVirtualServiceExportTo(int index,String item){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            this.defaultVirtualServiceExportTo.set(index, item); return (A)this;
    }

    public A addToDefaultVirtualServiceExportTo(String... items){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultVirtualServiceExportTo.add(item);} return (A)this;
    }

    public A addAllToDefaultVirtualServiceExportTo(Collection<String> items){
            if (this.defaultVirtualServiceExportTo == null) {this.defaultVirtualServiceExportTo = new ArrayList<String>();}
            for (String item : items) {this.defaultVirtualServiceExportTo.add(item);} return (A)this;
    }

    public A removeFromDefaultVirtualServiceExportTo(String... items){
            for (String item : items) {if (this.defaultVirtualServiceExportTo!= null){ this.defaultVirtualServiceExportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromDefaultVirtualServiceExportTo(Collection<String> items){
            for (String item : items) {if (this.defaultVirtualServiceExportTo!= null){ this.defaultVirtualServiceExportTo.remove(item);}} return (A)this;
    }

    public List<String> getDefaultVirtualServiceExportTo(){
            return this.defaultVirtualServiceExportTo;
    }

    public String getDefaultVirtualServiceExportTo(int index){
            return this.defaultVirtualServiceExportTo.get(index);
    }

    public String getFirstDefaultVirtualServiceExportTo(){
            return this.defaultVirtualServiceExportTo.get(0);
    }

    public String getLastDefaultVirtualServiceExportTo(){
            return this.defaultVirtualServiceExportTo.get(defaultVirtualServiceExportTo.size() - 1);
    }

    public String getMatchingDefaultVirtualServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultVirtualServiceExportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDefaultVirtualServiceExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultVirtualServiceExportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDefaultVirtualServiceExportTo(List<String> defaultVirtualServiceExportTo){
            if (this.defaultVirtualServiceExportTo != null) { _visitables.get("defaultVirtualServiceExportTo").removeAll(this.defaultVirtualServiceExportTo);}
            if (defaultVirtualServiceExportTo != null) {this.defaultVirtualServiceExportTo = new ArrayList<String>(); for (String item : defaultVirtualServiceExportTo){this.addToDefaultVirtualServiceExportTo(item);}} else { this.defaultVirtualServiceExportTo = null;} return (A) this;
    }

    public A withDefaultVirtualServiceExportTo(String... defaultVirtualServiceExportTo){
            if (this.defaultVirtualServiceExportTo != null) {this.defaultVirtualServiceExportTo.clear();}
            if (defaultVirtualServiceExportTo != null) {for (String item :defaultVirtualServiceExportTo){ this.addToDefaultVirtualServiceExportTo(item);}} return (A) this;
    }

    public Boolean hasDefaultVirtualServiceExportTo(){
            return defaultVirtualServiceExportTo != null && !defaultVirtualServiceExportTo.isEmpty();
    }

    public A addNewDefaultVirtualServiceExportTo(String arg1){
            return (A)addToDefaultVirtualServiceExportTo(new String(arg1));
    }

    public A addNewDefaultVirtualServiceExportTo(StringBuilder arg1){
            return (A)addToDefaultVirtualServiceExportTo(new String(arg1));
    }

    public A addNewDefaultVirtualServiceExportTo(StringBuffer arg1){
            return (A)addToDefaultVirtualServiceExportTo(new String(arg1));
    }

    public Boolean isDisablePolicyChecks(){
            return this.disablePolicyChecks;
    }

    public A withDisablePolicyChecks(Boolean disablePolicyChecks){
            this.disablePolicyChecks=disablePolicyChecks; return (A) this;
    }

    public Boolean hasDisablePolicyChecks(){
            return this.disablePolicyChecks != null;
    }

    public A withNewDisablePolicyChecks(String arg1){
            return (A)withDisablePolicyChecks(new Boolean(arg1));
    }

    public A withNewDisablePolicyChecks(boolean arg1){
            return (A)withDisablePolicyChecks(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDnsRefreshRate instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDnsRefreshRate(){
            return this.dnsRefreshRate!=null?this.dnsRefreshRate.build():null;
    }

    public Duration buildDnsRefreshRate(){
            return this.dnsRefreshRate!=null?this.dnsRefreshRate.build():null;
    }

    public A withDnsRefreshRate(Duration dnsRefreshRate){
            _visitables.get("dnsRefreshRate").remove(this.dnsRefreshRate);
            if (dnsRefreshRate!=null){ this.dnsRefreshRate= new DurationBuilder(dnsRefreshRate); _visitables.get("dnsRefreshRate").add(this.dnsRefreshRate);} return (A) this;
    }

    public Boolean hasDnsRefreshRate(){
            return this.dnsRefreshRate != null;
    }

    public A withNewDnsRefreshRate(Integer nanos,Long seconds){
            return (A)withDnsRefreshRate(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> withNewDnsRefreshRate(){
            return new DnsRefreshRateNestedImpl();
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> withNewDnsRefreshRateLike(Duration item){
            return new DnsRefreshRateNestedImpl(item);
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> editDnsRefreshRate(){
            return withNewDnsRefreshRateLike(getDnsRefreshRate());
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> editOrNewDnsRefreshRate(){
            return withNewDnsRefreshRateLike(getDnsRefreshRate() != null ? getDnsRefreshRate(): new DurationBuilder().build());
    }

    public MeshConfigFluent.DnsRefreshRateNested<A> editOrNewDnsRefreshRateLike(Duration item){
            return withNewDnsRefreshRateLike(getDnsRefreshRate() != null ? getDnsRefreshRate(): item);
    }

    public Boolean isEnableClientSidePolicyCheck(){
            return this.enableClientSidePolicyCheck;
    }

    public A withEnableClientSidePolicyCheck(Boolean enableClientSidePolicyCheck){
            this.enableClientSidePolicyCheck=enableClientSidePolicyCheck; return (A) this;
    }

    public Boolean hasEnableClientSidePolicyCheck(){
            return this.enableClientSidePolicyCheck != null;
    }

    public A withNewEnableClientSidePolicyCheck(String arg1){
            return (A)withEnableClientSidePolicyCheck(new Boolean(arg1));
    }

    public A withNewEnableClientSidePolicyCheck(boolean arg1){
            return (A)withEnableClientSidePolicyCheck(new Boolean(arg1));
    }

    public Boolean isEnableSdsTokenMount(){
            return this.enableSdsTokenMount;
    }

    public A withEnableSdsTokenMount(Boolean enableSdsTokenMount){
            this.enableSdsTokenMount=enableSdsTokenMount; return (A) this;
    }

    public Boolean hasEnableSdsTokenMount(){
            return this.enableSdsTokenMount != null;
    }

    public A withNewEnableSdsTokenMount(String arg1){
            return (A)withEnableSdsTokenMount(new Boolean(arg1));
    }

    public A withNewEnableSdsTokenMount(boolean arg1){
            return (A)withEnableSdsTokenMount(new Boolean(arg1));
    }

    public Boolean isEnableTracing(){
            return this.enableTracing;
    }

    public A withEnableTracing(Boolean enableTracing){
            this.enableTracing=enableTracing; return (A) this;
    }

    public Boolean hasEnableTracing(){
            return this.enableTracing != null;
    }

    public A withNewEnableTracing(String arg1){
            return (A)withEnableTracing(new Boolean(arg1));
    }

    public A withNewEnableTracing(boolean arg1){
            return (A)withEnableTracing(new Boolean(arg1));
    }

    public String getIngressClass(){
            return this.ingressClass;
    }

    public A withIngressClass(String ingressClass){
            this.ingressClass=ingressClass; return (A) this;
    }

    public Boolean hasIngressClass(){
            return this.ingressClass != null;
    }

    public A withNewIngressClass(String arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(StringBuilder arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(StringBuffer arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public IngressControllerMode getIngressControllerMode(){
            return this.ingressControllerMode;
    }

    public A withIngressControllerMode(IngressControllerMode ingressControllerMode){
            this.ingressControllerMode=ingressControllerMode; return (A) this;
    }

    public Boolean hasIngressControllerMode(){
            return this.ingressControllerMode != null;
    }

    public String getIngressService(){
            return this.ingressService;
    }

    public A withIngressService(String ingressService){
            this.ingressService=ingressService; return (A) this;
    }

    public Boolean hasIngressService(){
            return this.ingressService != null;
    }

    public A withNewIngressService(String arg1){
            return (A)withIngressService(new String(arg1));
    }

    public A withNewIngressService(StringBuilder arg1){
            return (A)withIngressService(new String(arg1));
    }

    public A withNewIngressService(StringBuffer arg1){
            return (A)withIngressService(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildLocalityLbSetting instead.
 * @return The buildable object.
 */
@Deprecated public LocalityLoadBalancerSetting getLocalityLbSetting(){
            return this.localityLbSetting!=null?this.localityLbSetting.build():null;
    }

    public LocalityLoadBalancerSetting buildLocalityLbSetting(){
            return this.localityLbSetting!=null?this.localityLbSetting.build():null;
    }

    public A withLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting){
            _visitables.get("localityLbSetting").remove(this.localityLbSetting);
            if (localityLbSetting!=null){ this.localityLbSetting= new LocalityLoadBalancerSettingBuilder(localityLbSetting); _visitables.get("localityLbSetting").add(this.localityLbSetting);} return (A) this;
    }

    public Boolean hasLocalityLbSetting(){
            return this.localityLbSetting != null;
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> withNewLocalityLbSetting(){
            return new LocalityLbSettingNestedImpl();
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> withNewLocalityLbSettingLike(LocalityLoadBalancerSetting item){
            return new LocalityLbSettingNestedImpl(item);
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> editLocalityLbSetting(){
            return withNewLocalityLbSettingLike(getLocalityLbSetting());
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSetting(){
            return withNewLocalityLbSettingLike(getLocalityLbSetting() != null ? getLocalityLbSetting(): new LocalityLoadBalancerSettingBuilder().build());
    }

    public MeshConfigFluent.LocalityLbSettingNested<A> editOrNewLocalityLbSettingLike(LocalityLoadBalancerSetting item){
            return withNewLocalityLbSettingLike(getLocalityLbSetting() != null ? getLocalityLbSetting(): item);
    }

    public String getMixerAddress(){
            return this.mixerAddress;
    }

    public A withMixerAddress(String mixerAddress){
            this.mixerAddress=mixerAddress; return (A) this;
    }

    public Boolean hasMixerAddress(){
            return this.mixerAddress != null;
    }

    public A withNewMixerAddress(String arg1){
            return (A)withMixerAddress(new String(arg1));
    }

    public A withNewMixerAddress(StringBuilder arg1){
            return (A)withMixerAddress(new String(arg1));
    }

    public A withNewMixerAddress(StringBuffer arg1){
            return (A)withMixerAddress(new String(arg1));
    }

    public String getMixerCheckServer(){
            return this.mixerCheckServer;
    }

    public A withMixerCheckServer(String mixerCheckServer){
            this.mixerCheckServer=mixerCheckServer; return (A) this;
    }

    public Boolean hasMixerCheckServer(){
            return this.mixerCheckServer != null;
    }

    public A withNewMixerCheckServer(String arg1){
            return (A)withMixerCheckServer(new String(arg1));
    }

    public A withNewMixerCheckServer(StringBuilder arg1){
            return (A)withMixerCheckServer(new String(arg1));
    }

    public A withNewMixerCheckServer(StringBuffer arg1){
            return (A)withMixerCheckServer(new String(arg1));
    }

    public String getMixerReportServer(){
            return this.mixerReportServer;
    }

    public A withMixerReportServer(String mixerReportServer){
            this.mixerReportServer=mixerReportServer; return (A) this;
    }

    public Boolean hasMixerReportServer(){
            return this.mixerReportServer != null;
    }

    public A withNewMixerReportServer(String arg1){
            return (A)withMixerReportServer(new String(arg1));
    }

    public A withNewMixerReportServer(StringBuilder arg1){
            return (A)withMixerReportServer(new String(arg1));
    }

    public A withNewMixerReportServer(StringBuffer arg1){
            return (A)withMixerReportServer(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public OutboundTrafficPolicy getOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public OutboundTrafficPolicy buildOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public A withOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy){
            _visitables.get("outboundTrafficPolicy").remove(this.outboundTrafficPolicy);
            if (outboundTrafficPolicy!=null){ this.outboundTrafficPolicy= new OutboundTrafficPolicyBuilder(outboundTrafficPolicy); _visitables.get("outboundTrafficPolicy").add(this.outboundTrafficPolicy);} return (A) this;
    }

    public Boolean hasOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy != null;
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy(){
            return new OutboundTrafficPolicyNestedImpl();
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item){
            return new OutboundTrafficPolicyNestedImpl(item);
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy());
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): new OutboundTrafficPolicyBuilder().build());
    }

    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): item);
    }

    public Boolean isPolicyCheckFailOpen(){
            return this.policyCheckFailOpen;
    }

    public A withPolicyCheckFailOpen(Boolean policyCheckFailOpen){
            this.policyCheckFailOpen=policyCheckFailOpen; return (A) this;
    }

    public Boolean hasPolicyCheckFailOpen(){
            return this.policyCheckFailOpen != null;
    }

    public A withNewPolicyCheckFailOpen(String arg1){
            return (A)withPolicyCheckFailOpen(new Boolean(arg1));
    }

    public A withNewPolicyCheckFailOpen(boolean arg1){
            return (A)withPolicyCheckFailOpen(new Boolean(arg1));
    }

    public Integer getProxyHttpPort(){
            return this.proxyHttpPort;
    }

    public A withProxyHttpPort(Integer proxyHttpPort){
            this.proxyHttpPort=proxyHttpPort; return (A) this;
    }

    public Boolean hasProxyHttpPort(){
            return this.proxyHttpPort != null;
    }

    public Integer getProxyListenPort(){
            return this.proxyListenPort;
    }

    public A withProxyListenPort(Integer proxyListenPort){
            this.proxyListenPort=proxyListenPort; return (A) this;
    }

    public Boolean hasProxyListenPort(){
            return this.proxyListenPort != null;
    }

    
/**
 * This method has been deprecated, please use method buildRdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getRdsRefreshDelay(){
            return this.rdsRefreshDelay!=null?this.rdsRefreshDelay.build():null;
    }

    public Duration buildRdsRefreshDelay(){
            return this.rdsRefreshDelay!=null?this.rdsRefreshDelay.build():null;
    }

    public A withRdsRefreshDelay(Duration rdsRefreshDelay){
            _visitables.get("rdsRefreshDelay").remove(this.rdsRefreshDelay);
            if (rdsRefreshDelay!=null){ this.rdsRefreshDelay= new DurationBuilder(rdsRefreshDelay); _visitables.get("rdsRefreshDelay").add(this.rdsRefreshDelay);} return (A) this;
    }

    public Boolean hasRdsRefreshDelay(){
            return this.rdsRefreshDelay != null;
    }

    public A withNewRdsRefreshDelay(Integer nanos,Long seconds){
            return (A)withRdsRefreshDelay(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelay(){
            return new RdsRefreshDelayNestedImpl();
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelayLike(Duration item){
            return new RdsRefreshDelayNestedImpl(item);
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editRdsRefreshDelay(){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay());
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelay(){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay() != null ? getRdsRefreshDelay(): new DurationBuilder().build());
    }

    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelayLike(Duration item){
            return withNewRdsRefreshDelayLike(getRdsRefreshDelay() != null ? getRdsRefreshDelay(): item);
    }

    public String getRootNamespace(){
            return this.rootNamespace;
    }

    public A withRootNamespace(String rootNamespace){
            this.rootNamespace=rootNamespace; return (A) this;
    }

    public Boolean hasRootNamespace(){
            return this.rootNamespace != null;
    }

    public A withNewRootNamespace(String arg1){
            return (A)withRootNamespace(new String(arg1));
    }

    public A withNewRootNamespace(StringBuilder arg1){
            return (A)withRootNamespace(new String(arg1));
    }

    public A withNewRootNamespace(StringBuffer arg1){
            return (A)withRootNamespace(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getSdsRefreshDelay(){
            return this.sdsRefreshDelay!=null?this.sdsRefreshDelay.build():null;
    }

    public Duration buildSdsRefreshDelay(){
            return this.sdsRefreshDelay!=null?this.sdsRefreshDelay.build():null;
    }

    public A withSdsRefreshDelay(Duration sdsRefreshDelay){
            _visitables.get("sdsRefreshDelay").remove(this.sdsRefreshDelay);
            if (sdsRefreshDelay!=null){ this.sdsRefreshDelay= new DurationBuilder(sdsRefreshDelay); _visitables.get("sdsRefreshDelay").add(this.sdsRefreshDelay);} return (A) this;
    }

    public Boolean hasSdsRefreshDelay(){
            return this.sdsRefreshDelay != null;
    }

    public A withNewSdsRefreshDelay(Integer nanos,Long seconds){
            return (A)withSdsRefreshDelay(new Duration(nanos, seconds));
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelay(){
            return new SdsRefreshDelayNestedImpl();
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelayLike(Duration item){
            return new SdsRefreshDelayNestedImpl(item);
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editSdsRefreshDelay(){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay());
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelay(){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay() != null ? getSdsRefreshDelay(): new DurationBuilder().build());
    }

    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelayLike(Duration item){
            return withNewSdsRefreshDelayLike(getSdsRefreshDelay() != null ? getSdsRefreshDelay(): item);
    }

    public String getSdsUdsPath(){
            return this.sdsUdsPath;
    }

    public A withSdsUdsPath(String sdsUdsPath){
            this.sdsUdsPath=sdsUdsPath; return (A) this;
    }

    public Boolean hasSdsUdsPath(){
            return this.sdsUdsPath != null;
    }

    public A withNewSdsUdsPath(String arg1){
            return (A)withSdsUdsPath(new String(arg1));
    }

    public A withNewSdsUdsPath(StringBuilder arg1){
            return (A)withSdsUdsPath(new String(arg1));
    }

    public A withNewSdsUdsPath(StringBuffer arg1){
            return (A)withSdsUdsPath(new String(arg1));
    }

    public Boolean isSdsUseK8sSaJwt(){
            return this.sdsUseK8sSaJwt;
    }

    public A withSdsUseK8sSaJwt(Boolean sdsUseK8sSaJwt){
            this.sdsUseK8sSaJwt=sdsUseK8sSaJwt; return (A) this;
    }

    public Boolean hasSdsUseK8sSaJwt(){
            return this.sdsUseK8sSaJwt != null;
    }

    public A withNewSdsUseK8sSaJwt(String arg1){
            return (A)withSdsUseK8sSaJwt(new Boolean(arg1));
    }

    public A withNewSdsUseK8sSaJwt(boolean arg1){
            return (A)withSdsUseK8sSaJwt(new Boolean(arg1));
    }

    public Boolean isSidecarToTelemetrySessionAffinity(){
            return this.sidecarToTelemetrySessionAffinity;
    }

    public A withSidecarToTelemetrySessionAffinity(Boolean sidecarToTelemetrySessionAffinity){
            this.sidecarToTelemetrySessionAffinity=sidecarToTelemetrySessionAffinity; return (A) this;
    }

    public Boolean hasSidecarToTelemetrySessionAffinity(){
            return this.sidecarToTelemetrySessionAffinity != null;
    }

    public A withNewSidecarToTelemetrySessionAffinity(String arg1){
            return (A)withSidecarToTelemetrySessionAffinity(new Boolean(arg1));
    }

    public A withNewSidecarToTelemetrySessionAffinity(boolean arg1){
            return (A)withSidecarToTelemetrySessionAffinity(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTcpKeepalive instead.
 * @return The buildable object.
 */
@Deprecated public TcpKeepalive getTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public TcpKeepalive buildTcpKeepalive(){
            return this.tcpKeepalive!=null?this.tcpKeepalive.build():null;
    }

    public A withTcpKeepalive(TcpKeepalive tcpKeepalive){
            _visitables.get("tcpKeepalive").remove(this.tcpKeepalive);
            if (tcpKeepalive!=null){ this.tcpKeepalive= new TcpKeepaliveBuilder(tcpKeepalive); _visitables.get("tcpKeepalive").add(this.tcpKeepalive);} return (A) this;
    }

    public Boolean hasTcpKeepalive(){
            return this.tcpKeepalive != null;
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> withNewTcpKeepalive(){
            return new TcpKeepaliveNestedImpl();
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> withNewTcpKeepaliveLike(TcpKeepalive item){
            return new TcpKeepaliveNestedImpl(item);
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> editTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive());
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> editOrNewTcpKeepalive(){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): new TcpKeepaliveBuilder().build());
    }

    public MeshConfigFluent.TcpKeepaliveNested<A> editOrNewTcpKeepaliveLike(TcpKeepalive item){
            return withNewTcpKeepaliveLike(getTcpKeepalive() != null ? getTcpKeepalive(): item);
    }

    public String getTrustDomain(){
            return this.trustDomain;
    }

    public A withTrustDomain(String trustDomain){
            this.trustDomain=trustDomain; return (A) this;
    }

    public Boolean hasTrustDomain(){
            return this.trustDomain != null;
    }

    public A withNewTrustDomain(String arg1){
            return (A)withTrustDomain(new String(arg1));
    }

    public A withNewTrustDomain(StringBuilder arg1){
            return (A)withTrustDomain(new String(arg1));
    }

    public A withNewTrustDomain(StringBuffer arg1){
            return (A)withTrustDomain(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MeshConfigFluentImpl that = (MeshConfigFluentImpl) o;
            if (accessLogEncoding != null ? !accessLogEncoding.equals(that.accessLogEncoding) :that.accessLogEncoding != null) return false;
            if (accessLogFile != null ? !accessLogFile.equals(that.accessLogFile) :that.accessLogFile != null) return false;
            if (accessLogFormat != null ? !accessLogFormat.equals(that.accessLogFormat) :that.accessLogFormat != null) return false;
            if (authPolicy != null ? !authPolicy.equals(that.authPolicy) :that.authPolicy != null) return false;
            if (configSources != null ? !configSources.equals(that.configSources) :that.configSources != null) return false;
            if (connectTimeout != null ? !connectTimeout.equals(that.connectTimeout) :that.connectTimeout != null) return false;
            if (defaultConfig != null ? !defaultConfig.equals(that.defaultConfig) :that.defaultConfig != null) return false;
            if (defaultDestinationRuleExportTo != null ? !defaultDestinationRuleExportTo.equals(that.defaultDestinationRuleExportTo) :that.defaultDestinationRuleExportTo != null) return false;
            if (defaultServiceExportTo != null ? !defaultServiceExportTo.equals(that.defaultServiceExportTo) :that.defaultServiceExportTo != null) return false;
            if (defaultVirtualServiceExportTo != null ? !defaultVirtualServiceExportTo.equals(that.defaultVirtualServiceExportTo) :that.defaultVirtualServiceExportTo != null) return false;
            if (disablePolicyChecks != null ? !disablePolicyChecks.equals(that.disablePolicyChecks) :that.disablePolicyChecks != null) return false;
            if (dnsRefreshRate != null ? !dnsRefreshRate.equals(that.dnsRefreshRate) :that.dnsRefreshRate != null) return false;
            if (enableClientSidePolicyCheck != null ? !enableClientSidePolicyCheck.equals(that.enableClientSidePolicyCheck) :that.enableClientSidePolicyCheck != null) return false;
            if (enableSdsTokenMount != null ? !enableSdsTokenMount.equals(that.enableSdsTokenMount) :that.enableSdsTokenMount != null) return false;
            if (enableTracing != null ? !enableTracing.equals(that.enableTracing) :that.enableTracing != null) return false;
            if (ingressClass != null ? !ingressClass.equals(that.ingressClass) :that.ingressClass != null) return false;
            if (ingressControllerMode != null ? !ingressControllerMode.equals(that.ingressControllerMode) :that.ingressControllerMode != null) return false;
            if (ingressService != null ? !ingressService.equals(that.ingressService) :that.ingressService != null) return false;
            if (localityLbSetting != null ? !localityLbSetting.equals(that.localityLbSetting) :that.localityLbSetting != null) return false;
            if (mixerAddress != null ? !mixerAddress.equals(that.mixerAddress) :that.mixerAddress != null) return false;
            if (mixerCheckServer != null ? !mixerCheckServer.equals(that.mixerCheckServer) :that.mixerCheckServer != null) return false;
            if (mixerReportServer != null ? !mixerReportServer.equals(that.mixerReportServer) :that.mixerReportServer != null) return false;
            if (outboundTrafficPolicy != null ? !outboundTrafficPolicy.equals(that.outboundTrafficPolicy) :that.outboundTrafficPolicy != null) return false;
            if (policyCheckFailOpen != null ? !policyCheckFailOpen.equals(that.policyCheckFailOpen) :that.policyCheckFailOpen != null) return false;
            if (proxyHttpPort != null ? !proxyHttpPort.equals(that.proxyHttpPort) :that.proxyHttpPort != null) return false;
            if (proxyListenPort != null ? !proxyListenPort.equals(that.proxyListenPort) :that.proxyListenPort != null) return false;
            if (rdsRefreshDelay != null ? !rdsRefreshDelay.equals(that.rdsRefreshDelay) :that.rdsRefreshDelay != null) return false;
            if (rootNamespace != null ? !rootNamespace.equals(that.rootNamespace) :that.rootNamespace != null) return false;
            if (sdsRefreshDelay != null ? !sdsRefreshDelay.equals(that.sdsRefreshDelay) :that.sdsRefreshDelay != null) return false;
            if (sdsUdsPath != null ? !sdsUdsPath.equals(that.sdsUdsPath) :that.sdsUdsPath != null) return false;
            if (sdsUseK8sSaJwt != null ? !sdsUseK8sSaJwt.equals(that.sdsUseK8sSaJwt) :that.sdsUseK8sSaJwt != null) return false;
            if (sidecarToTelemetrySessionAffinity != null ? !sidecarToTelemetrySessionAffinity.equals(that.sidecarToTelemetrySessionAffinity) :that.sidecarToTelemetrySessionAffinity != null) return false;
            if (tcpKeepalive != null ? !tcpKeepalive.equals(that.tcpKeepalive) :that.tcpKeepalive != null) return false;
            if (trustDomain != null ? !trustDomain.equals(that.trustDomain) :that.trustDomain != null) return false;
            return true;
    }


    public class ConfigSourcesNestedImpl<N> extends ConfigSourceFluentImpl<MeshConfigFluent.ConfigSourcesNested<N>> implements MeshConfigFluent.ConfigSourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigSourceBuilder builder;
        private final int index;
    
            ConfigSourcesNestedImpl(int index,ConfigSource item){
                    this.index = index;
                    this.builder = new ConfigSourceBuilder(this, item);
            }
            ConfigSourcesNestedImpl(){
                    this.index = -1;
                    this.builder = new ConfigSourceBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.setToConfigSources(index, builder.build());
    }
    public N endConfigSource(){
            return and();
    }

}
    public class ConnectTimeoutNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.ConnectTimeoutNested<N>> implements MeshConfigFluent.ConnectTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ConnectTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ConnectTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withConnectTimeout(builder.build());
    }
    public N endConnectTimeout(){
            return and();
    }

}
    public class DefaultConfigNestedImpl<N> extends ProxyConfigFluentImpl<MeshConfigFluent.DefaultConfigNested<N>> implements MeshConfigFluent.DefaultConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProxyConfigBuilder builder;
    
            DefaultConfigNestedImpl(ProxyConfig item){
                    this.builder = new ProxyConfigBuilder(this, item);
            }
            DefaultConfigNestedImpl(){
                    this.builder = new ProxyConfigBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withDefaultConfig(builder.build());
    }
    public N endDefaultConfig(){
            return and();
    }

}
    public class DnsRefreshRateNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.DnsRefreshRateNested<N>> implements MeshConfigFluent.DnsRefreshRateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            DnsRefreshRateNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            DnsRefreshRateNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withDnsRefreshRate(builder.build());
    }
    public N endDnsRefreshRate(){
            return and();
    }

}
    public class LocalityLbSettingNestedImpl<N> extends LocalityLoadBalancerSettingFluentImpl<MeshConfigFluent.LocalityLbSettingNested<N>> implements MeshConfigFluent.LocalityLbSettingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalityLoadBalancerSettingBuilder builder;
    
            LocalityLbSettingNestedImpl(LocalityLoadBalancerSetting item){
                    this.builder = new LocalityLoadBalancerSettingBuilder(this, item);
            }
            LocalityLbSettingNestedImpl(){
                    this.builder = new LocalityLoadBalancerSettingBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withLocalityLbSetting(builder.build());
    }
    public N endLocalityLbSetting(){
            return and();
    }

}
    public class OutboundTrafficPolicyNestedImpl<N> extends OutboundTrafficPolicyFluentImpl<MeshConfigFluent.OutboundTrafficPolicyNested<N>> implements MeshConfigFluent.OutboundTrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OutboundTrafficPolicyBuilder builder;
    
            OutboundTrafficPolicyNestedImpl(OutboundTrafficPolicy item){
                    this.builder = new OutboundTrafficPolicyBuilder(this, item);
            }
            OutboundTrafficPolicyNestedImpl(){
                    this.builder = new OutboundTrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withOutboundTrafficPolicy(builder.build());
    }
    public N endOutboundTrafficPolicy(){
            return and();
    }

}
    public class RdsRefreshDelayNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.RdsRefreshDelayNested<N>> implements MeshConfigFluent.RdsRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            RdsRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            RdsRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withRdsRefreshDelay(builder.build());
    }
    public N endRdsRefreshDelay(){
            return and();
    }

}
    public class SdsRefreshDelayNestedImpl<N> extends DurationFluentImpl<MeshConfigFluent.SdsRefreshDelayNested<N>> implements MeshConfigFluent.SdsRefreshDelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            SdsRefreshDelayNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            SdsRefreshDelayNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withSdsRefreshDelay(builder.build());
    }
    public N endSdsRefreshDelay(){
            return and();
    }

}
    public class TcpKeepaliveNestedImpl<N> extends TcpKeepaliveFluentImpl<MeshConfigFluent.TcpKeepaliveNested<N>> implements MeshConfigFluent.TcpKeepaliveNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TcpKeepaliveBuilder builder;
    
            TcpKeepaliveNestedImpl(TcpKeepalive item){
                    this.builder = new TcpKeepaliveBuilder(this, item);
            }
            TcpKeepaliveNestedImpl(){
                    this.builder = new TcpKeepaliveBuilder(this);
            }
    
    public N and(){
            return (N) MeshConfigFluentImpl.this.withTcpKeepalive(builder.build());
    }
    public N endTcpKeepalive(){
            return and();
    }

}


}
