
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "availabilityZone",
    "binaryPath",
    "concurrency",
    "configPath",
    "connectTimeout",
    "controlPlaneAuthPolicy",
    "customConfigFile",
    "discoveryAddress",
    "discoveryRefreshDelay",
    "drainDuration",
    "envoyMetricsServiceAddress",
    "interceptionMode",
    "parentShutdownDuration",
    "proxyAdminPort",
    "proxyBootstrapTemplatePath",
    "serviceCluster",
    "statNameLength",
    "statsdUdpAddress",
    "tracing",
    "zipkinAddress"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ProxyConfig implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("availabilityZone")
    @JsonPropertyDescription("")
    private String availabilityZone;
    /**
     * 
     * 
     */
    @JsonProperty("binaryPath")
    @JsonPropertyDescription("")
    private String binaryPath;
    /**
     * 
     * 
     */
    @JsonProperty("concurrency")
    @JsonPropertyDescription("")
    private Integer concurrency;
    /**
     * 
     * 
     */
    @JsonProperty("configPath")
    @JsonPropertyDescription("")
    private String configPath;
    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    @JsonPropertyDescription("")
    private Duration connectTimeout;
    @JsonProperty("controlPlaneAuthPolicy")
    private AuthenticationPolicy controlPlaneAuthPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("customConfigFile")
    @JsonPropertyDescription("")
    private String customConfigFile;
    /**
     * 
     * 
     */
    @JsonProperty("discoveryAddress")
    @JsonPropertyDescription("")
    private String discoveryAddress;
    /**
     * 
     * 
     */
    @JsonProperty("discoveryRefreshDelay")
    @JsonPropertyDescription("")
    private Duration discoveryRefreshDelay;
    /**
     * 
     * 
     */
    @JsonProperty("drainDuration")
    @JsonPropertyDescription("")
    private Duration drainDuration;
    /**
     * 
     * 
     */
    @JsonProperty("envoyMetricsServiceAddress")
    @JsonPropertyDescription("")
    private String envoyMetricsServiceAddress;
    @JsonProperty("interceptionMode")
    private InboundInterceptionMode interceptionMode;
    /**
     * 
     * 
     */
    @JsonProperty("parentShutdownDuration")
    @JsonPropertyDescription("")
    private Duration parentShutdownDuration;
    /**
     * 
     * 
     */
    @JsonProperty("proxyAdminPort")
    @JsonPropertyDescription("")
    private Integer proxyAdminPort;
    /**
     * 
     * 
     */
    @JsonProperty("proxyBootstrapTemplatePath")
    @JsonPropertyDescription("")
    private String proxyBootstrapTemplatePath;
    /**
     * 
     * 
     */
    @JsonProperty("serviceCluster")
    @JsonPropertyDescription("")
    private String serviceCluster;
    /**
     * 
     * 
     */
    @JsonProperty("statNameLength")
    @JsonPropertyDescription("")
    private Integer statNameLength;
    /**
     * 
     * 
     */
    @JsonProperty("statsdUdpAddress")
    @JsonPropertyDescription("")
    private String statsdUdpAddress;
    /**
     * 
     * 
     */
    @JsonProperty("tracing")
    @JsonPropertyDescription("")
    private Tracing tracing;
    /**
     * 
     * 
     */
    @JsonProperty("zipkinAddress")
    @JsonPropertyDescription("")
    private String zipkinAddress;
    private final static long serialVersionUID = -714697466393978761L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProxyConfig() {
    }

    /**
     * 
     * @param tracing
     * @param binaryPath
     * @param statsdUdpAddress
     * @param configPath
     * @param discoveryAddress
     * @param availabilityZone
     * @param statNameLength
     * @param concurrency
     * @param controlPlaneAuthPolicy
     * @param proxyAdminPort
     * @param zipkinAddress
     * @param connectTimeout
     * @param discoveryRefreshDelay
     * @param drainDuration
     * @param proxyBootstrapTemplatePath
     * @param customConfigFile
     * @param serviceCluster
     * @param envoyMetricsServiceAddress
     * @param parentShutdownDuration
     * @param interceptionMode
     */
    public ProxyConfig(String availabilityZone, String binaryPath, Integer concurrency, String configPath, Duration connectTimeout, AuthenticationPolicy controlPlaneAuthPolicy, String customConfigFile, String discoveryAddress, Duration discoveryRefreshDelay, Duration drainDuration, String envoyMetricsServiceAddress, InboundInterceptionMode interceptionMode, Duration parentShutdownDuration, Integer proxyAdminPort, String proxyBootstrapTemplatePath, String serviceCluster, Integer statNameLength, String statsdUdpAddress, Tracing tracing, String zipkinAddress) {
        super();
        this.availabilityZone = availabilityZone;
        this.binaryPath = binaryPath;
        this.concurrency = concurrency;
        this.configPath = configPath;
        this.connectTimeout = connectTimeout;
        this.controlPlaneAuthPolicy = controlPlaneAuthPolicy;
        this.customConfigFile = customConfigFile;
        this.discoveryAddress = discoveryAddress;
        this.discoveryRefreshDelay = discoveryRefreshDelay;
        this.drainDuration = drainDuration;
        this.envoyMetricsServiceAddress = envoyMetricsServiceAddress;
        this.interceptionMode = interceptionMode;
        this.parentShutdownDuration = parentShutdownDuration;
        this.proxyAdminPort = proxyAdminPort;
        this.proxyBootstrapTemplatePath = proxyBootstrapTemplatePath;
        this.serviceCluster = serviceCluster;
        this.statNameLength = statNameLength;
        this.statsdUdpAddress = statsdUdpAddress;
        this.tracing = tracing;
        this.zipkinAddress = zipkinAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("availabilityZone")
    public String getAvailabilityZone() {
        return availabilityZone;
    }

    /**
     * 
     * 
     */
    @JsonProperty("availabilityZone")
    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * 
     * 
     */
    @JsonProperty("binaryPath")
    public String getBinaryPath() {
        return binaryPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("binaryPath")
    public void setBinaryPath(String binaryPath) {
        this.binaryPath = binaryPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("concurrency")
    public Integer getConcurrency() {
        return concurrency;
    }

    /**
     * 
     * 
     */
    @JsonProperty("concurrency")
    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    /**
     * 
     * 
     */
    @JsonProperty("configPath")
    public String getConfigPath() {
        return configPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("configPath")
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @JsonProperty("controlPlaneAuthPolicy")
    public AuthenticationPolicy getControlPlaneAuthPolicy() {
        return controlPlaneAuthPolicy;
    }

    @JsonProperty("controlPlaneAuthPolicy")
    public void setControlPlaneAuthPolicy(AuthenticationPolicy controlPlaneAuthPolicy) {
        this.controlPlaneAuthPolicy = controlPlaneAuthPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("customConfigFile")
    public String getCustomConfigFile() {
        return customConfigFile;
    }

    /**
     * 
     * 
     */
    @JsonProperty("customConfigFile")
    public void setCustomConfigFile(String customConfigFile) {
        this.customConfigFile = customConfigFile;
    }

    /**
     * 
     * 
     */
    @JsonProperty("discoveryAddress")
    public String getDiscoveryAddress() {
        return discoveryAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("discoveryAddress")
    public void setDiscoveryAddress(String discoveryAddress) {
        this.discoveryAddress = discoveryAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("discoveryRefreshDelay")
    public Duration getDiscoveryRefreshDelay() {
        return discoveryRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("discoveryRefreshDelay")
    public void setDiscoveryRefreshDelay(Duration discoveryRefreshDelay) {
        this.discoveryRefreshDelay = discoveryRefreshDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("drainDuration")
    public Duration getDrainDuration() {
        return drainDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("drainDuration")
    public void setDrainDuration(Duration drainDuration) {
        this.drainDuration = drainDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("envoyMetricsServiceAddress")
    public String getEnvoyMetricsServiceAddress() {
        return envoyMetricsServiceAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("envoyMetricsServiceAddress")
    public void setEnvoyMetricsServiceAddress(String envoyMetricsServiceAddress) {
        this.envoyMetricsServiceAddress = envoyMetricsServiceAddress;
    }

    @JsonProperty("interceptionMode")
    public InboundInterceptionMode getInterceptionMode() {
        return interceptionMode;
    }

    @JsonProperty("interceptionMode")
    public void setInterceptionMode(InboundInterceptionMode interceptionMode) {
        this.interceptionMode = interceptionMode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("parentShutdownDuration")
    public Duration getParentShutdownDuration() {
        return parentShutdownDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("parentShutdownDuration")
    public void setParentShutdownDuration(Duration parentShutdownDuration) {
        this.parentShutdownDuration = parentShutdownDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyAdminPort")
    public Integer getProxyAdminPort() {
        return proxyAdminPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyAdminPort")
    public void setProxyAdminPort(Integer proxyAdminPort) {
        this.proxyAdminPort = proxyAdminPort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyBootstrapTemplatePath")
    public String getProxyBootstrapTemplatePath() {
        return proxyBootstrapTemplatePath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("proxyBootstrapTemplatePath")
    public void setProxyBootstrapTemplatePath(String proxyBootstrapTemplatePath) {
        this.proxyBootstrapTemplatePath = proxyBootstrapTemplatePath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("serviceCluster")
    public String getServiceCluster() {
        return serviceCluster;
    }

    /**
     * 
     * 
     */
    @JsonProperty("serviceCluster")
    public void setServiceCluster(String serviceCluster) {
        this.serviceCluster = serviceCluster;
    }

    /**
     * 
     * 
     */
    @JsonProperty("statNameLength")
    public Integer getStatNameLength() {
        return statNameLength;
    }

    /**
     * 
     * 
     */
    @JsonProperty("statNameLength")
    public void setStatNameLength(Integer statNameLength) {
        this.statNameLength = statNameLength;
    }

    /**
     * 
     * 
     */
    @JsonProperty("statsdUdpAddress")
    public String getStatsdUdpAddress() {
        return statsdUdpAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("statsdUdpAddress")
    public void setStatsdUdpAddress(String statsdUdpAddress) {
        this.statsdUdpAddress = statsdUdpAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tracing")
    public Tracing getTracing() {
        return tracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tracing")
    public void setTracing(Tracing tracing) {
        this.tracing = tracing;
    }

    /**
     * 
     * 
     */
    @JsonProperty("zipkinAddress")
    public String getZipkinAddress() {
        return zipkinAddress;
    }

    /**
     * 
     * 
     */
    @JsonProperty("zipkinAddress")
    public void setZipkinAddress(String zipkinAddress) {
        this.zipkinAddress = zipkinAddress;
    }

}
