package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public interface ProxyConfigFluent<A extends ProxyConfigFluent<A>> extends Fluent<A>{


    public String getAvailabilityZone();
    public A withAvailabilityZone(String availabilityZone);
    public Boolean hasAvailabilityZone();
    public A withNewAvailabilityZone(String arg1);
    public A withNewAvailabilityZone(StringBuilder arg1);
    public A withNewAvailabilityZone(StringBuffer arg1);
    public String getBinaryPath();
    public A withBinaryPath(String binaryPath);
    public Boolean hasBinaryPath();
    public A withNewBinaryPath(String arg1);
    public A withNewBinaryPath(StringBuilder arg1);
    public A withNewBinaryPath(StringBuffer arg1);
    public Integer getConcurrency();
    public A withConcurrency(Integer concurrency);
    public Boolean hasConcurrency();
    public String getConfigPath();
    public A withConfigPath(String configPath);
    public Boolean hasConfigPath();
    public A withNewConfigPath(String arg1);
    public A withNewConfigPath(StringBuilder arg1);
    public A withNewConfigPath(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout();
    public Duration buildConnectTimeout();
    public A withConnectTimeout(Duration connectTimeout);
    public Boolean hasConnectTimeout();
    public A withNewConnectTimeout(Integer nanos,Long seconds);
    public ProxyConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeout();
    public ProxyConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item);
    public ProxyConfigFluent.ConnectTimeoutNested<A> editConnectTimeout();
    public ProxyConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout();
    public ProxyConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item);
    public AuthenticationPolicy getControlPlaneAuthPolicy();
    public A withControlPlaneAuthPolicy(AuthenticationPolicy controlPlaneAuthPolicy);
    public Boolean hasControlPlaneAuthPolicy();
    public String getCustomConfigFile();
    public A withCustomConfigFile(String customConfigFile);
    public Boolean hasCustomConfigFile();
    public A withNewCustomConfigFile(String arg1);
    public A withNewCustomConfigFile(StringBuilder arg1);
    public A withNewCustomConfigFile(StringBuffer arg1);
    public String getDiscoveryAddress();
    public A withDiscoveryAddress(String discoveryAddress);
    public Boolean hasDiscoveryAddress();
    public A withNewDiscoveryAddress(String arg1);
    public A withNewDiscoveryAddress(StringBuilder arg1);
    public A withNewDiscoveryAddress(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildDiscoveryRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDiscoveryRefreshDelay();
    public Duration buildDiscoveryRefreshDelay();
    public A withDiscoveryRefreshDelay(Duration discoveryRefreshDelay);
    public Boolean hasDiscoveryRefreshDelay();
    public A withNewDiscoveryRefreshDelay(Integer nanos,Long seconds);
    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> withNewDiscoveryRefreshDelay();
    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> withNewDiscoveryRefreshDelayLike(Duration item);
    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editDiscoveryRefreshDelay();
    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editOrNewDiscoveryRefreshDelay();
    public ProxyConfigFluent.DiscoveryRefreshDelayNested<A> editOrNewDiscoveryRefreshDelayLike(Duration item);
    
/**
 * This method has been deprecated, please use method buildDrainDuration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getDrainDuration();
    public Duration buildDrainDuration();
    public A withDrainDuration(Duration drainDuration);
    public Boolean hasDrainDuration();
    public A withNewDrainDuration(Integer nanos,Long seconds);
    public ProxyConfigFluent.DrainDurationNested<A> withNewDrainDuration();
    public ProxyConfigFluent.DrainDurationNested<A> withNewDrainDurationLike(Duration item);
    public ProxyConfigFluent.DrainDurationNested<A> editDrainDuration();
    public ProxyConfigFluent.DrainDurationNested<A> editOrNewDrainDuration();
    public ProxyConfigFluent.DrainDurationNested<A> editOrNewDrainDurationLike(Duration item);
    public String getEnvoyMetricsServiceAddress();
    public A withEnvoyMetricsServiceAddress(String envoyMetricsServiceAddress);
    public Boolean hasEnvoyMetricsServiceAddress();
    public A withNewEnvoyMetricsServiceAddress(String arg1);
    public A withNewEnvoyMetricsServiceAddress(StringBuilder arg1);
    public A withNewEnvoyMetricsServiceAddress(StringBuffer arg1);
    public InboundInterceptionMode getInterceptionMode();
    public A withInterceptionMode(InboundInterceptionMode interceptionMode);
    public Boolean hasInterceptionMode();
    
/**
 * This method has been deprecated, please use method buildParentShutdownDuration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getParentShutdownDuration();
    public Duration buildParentShutdownDuration();
    public A withParentShutdownDuration(Duration parentShutdownDuration);
    public Boolean hasParentShutdownDuration();
    public A withNewParentShutdownDuration(Integer nanos,Long seconds);
    public ProxyConfigFluent.ParentShutdownDurationNested<A> withNewParentShutdownDuration();
    public ProxyConfigFluent.ParentShutdownDurationNested<A> withNewParentShutdownDurationLike(Duration item);
    public ProxyConfigFluent.ParentShutdownDurationNested<A> editParentShutdownDuration();
    public ProxyConfigFluent.ParentShutdownDurationNested<A> editOrNewParentShutdownDuration();
    public ProxyConfigFluent.ParentShutdownDurationNested<A> editOrNewParentShutdownDurationLike(Duration item);
    public Integer getProxyAdminPort();
    public A withProxyAdminPort(Integer proxyAdminPort);
    public Boolean hasProxyAdminPort();
    public String getProxyBootstrapTemplatePath();
    public A withProxyBootstrapTemplatePath(String proxyBootstrapTemplatePath);
    public Boolean hasProxyBootstrapTemplatePath();
    public A withNewProxyBootstrapTemplatePath(String arg1);
    public A withNewProxyBootstrapTemplatePath(StringBuilder arg1);
    public A withNewProxyBootstrapTemplatePath(StringBuffer arg1);
    public String getServiceCluster();
    public A withServiceCluster(String serviceCluster);
    public Boolean hasServiceCluster();
    public A withNewServiceCluster(String arg1);
    public A withNewServiceCluster(StringBuilder arg1);
    public A withNewServiceCluster(StringBuffer arg1);
    public Integer getStatNameLength();
    public A withStatNameLength(Integer statNameLength);
    public Boolean hasStatNameLength();
    public String getStatsdUdpAddress();
    public A withStatsdUdpAddress(String statsdUdpAddress);
    public Boolean hasStatsdUdpAddress();
    public A withNewStatsdUdpAddress(String arg1);
    public A withNewStatsdUdpAddress(StringBuilder arg1);
    public A withNewStatsdUdpAddress(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTracing instead.
 * @return The buildable object.
 */
@Deprecated public Tracing getTracing();
    public Tracing buildTracing();
    public A withTracing(Tracing tracing);
    public Boolean hasTracing();
    public ProxyConfigFluent.TracingNested<A> withNewTracing();
    public ProxyConfigFluent.TracingNested<A> withNewTracingLike(Tracing item);
    public ProxyConfigFluent.TracingNested<A> editTracing();
    public ProxyConfigFluent.TracingNested<A> editOrNewTracing();
    public ProxyConfigFluent.TracingNested<A> editOrNewTracingLike(Tracing item);
    public String getZipkinAddress();
    public A withZipkinAddress(String zipkinAddress);
    public Boolean hasZipkinAddress();
    public A withNewZipkinAddress(String arg1);
    public A withNewZipkinAddress(StringBuilder arg1);
    public A withNewZipkinAddress(StringBuffer arg1);

    public interface ConnectTimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<ProxyConfigFluent.ConnectTimeoutNested<N>>{

        
    public N and();    public N endConnectTimeout();
}
    public interface DiscoveryRefreshDelayNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<ProxyConfigFluent.DiscoveryRefreshDelayNested<N>>{

        
    public N and();    public N endDiscoveryRefreshDelay();
}
    public interface DrainDurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<ProxyConfigFluent.DrainDurationNested<N>>{

        
    public N and();    public N endDrainDuration();
}
    public interface ParentShutdownDurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<ProxyConfigFluent.ParentShutdownDurationNested<N>>{

        
    public N and();    public N endParentShutdownDuration();
}
    public interface TracingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TracingFluent<ProxyConfigFluent.TracingNested<N>>{

        
    public N and();    public N endTracing();
}


}
