
package me.snowdrop.istio.api.mesh.v1alpha1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "tracer"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Tracing implements Serializable
{

    @JsonProperty("tracer")
    @JsonUnwrapped
    private me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer tracer;
    private final static long serialVersionUID = 3383000172412344529L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Tracing() {
    }

    /**
     * 
     * @param tracer
     */
    public Tracing(me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer tracer) {
        super();
        this.tracer = tracer;
    }

    @JsonProperty("tracer")
    public me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer getTracer() {
        return tracer;
    }

    @JsonProperty("tracer")
    public void setTracer(me.snowdrop.istio.api.mesh.v1alpha1.Tracing.Tracer tracer) {
        this.tracer = tracer;
    }

    public interface Tracer extends Serializable
    {


    }

}
