
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "condition",
    "mapKey",
    "name",
    "regex"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class AttributeMatch implements Serializable
{

    @JsonProperty("condition")
    private Condition condition;
    /**
     * 
     * 
     */
    @JsonProperty("mapKey")
    @JsonPropertyDescription("")
    private Integer mapKey;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private Integer name;
    /**
     * 
     * 
     */
    @JsonProperty("regex")
    @JsonPropertyDescription("")
    private String regex;
    private final static long serialVersionUID = -3848984115317171277L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AttributeMatch() {
    }

    /**
     * 
     * @param condition
     * @param regex
     * @param mapKey
     * @param name
     */
    public AttributeMatch(Condition condition, Integer mapKey, Integer name, String regex) {
        super();
        this.condition = condition;
        this.mapKey = mapKey;
        this.name = name;
        this.regex = regex;
    }

    @JsonProperty("condition")
    public Condition getCondition() {
        return condition;
    }

    @JsonProperty("condition")
    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mapKey")
    public Integer getMapKey() {
        return mapKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mapKey")
    public void setMapKey(Integer mapKey) {
        this.mapKey = mapKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public Integer getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(Integer name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("regex")
    public String getRegex() {
        return regex;
    }

    /**
     * 
     * 
     */
    @JsonProperty("regex")
    public void setRegex(String regex) {
        this.regex = regex;
    }

}
