package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AttributeMatchBuilder extends AttributeMatchFluentImpl<AttributeMatchBuilder> implements VisitableBuilder<AttributeMatch,AttributeMatchBuilder>{

    AttributeMatchFluent<?> fluent;
    Boolean validationEnabled;

    public AttributeMatchBuilder(){
            this(true);
    }
    public AttributeMatchBuilder(Boolean validationEnabled){
            this(new AttributeMatch(), validationEnabled);
    }
    public AttributeMatchBuilder(AttributeMatchFluent<?> fluent){
            this(fluent, true);
    }
    public AttributeMatchBuilder(AttributeMatchFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AttributeMatch(), validationEnabled);
    }
    public AttributeMatchBuilder(AttributeMatchFluent<?> fluent,AttributeMatch instance){
            this(fluent, instance, true);
    }
    public AttributeMatchBuilder(AttributeMatchFluent<?> fluent,AttributeMatch instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCondition(instance.getCondition()); 
            fluent.withMapKey(instance.getMapKey()); 
            fluent.withName(instance.getName()); 
            fluent.withRegex(instance.getRegex()); 
            this.validationEnabled = validationEnabled; 
    }
    public AttributeMatchBuilder(AttributeMatch instance){
            this(instance,true);
    }
    public AttributeMatchBuilder(AttributeMatch instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCondition(instance.getCondition()); 
            this.withMapKey(instance.getMapKey()); 
            this.withName(instance.getName()); 
            this.withRegex(instance.getRegex()); 
            this.validationEnabled = validationEnabled; 
    }

    public AttributeMatch build(){
            AttributeMatch buildable = new AttributeMatch(fluent.getCondition(),fluent.getMapKey(),fluent.getName(),fluent.getRegex());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AttributeMatchBuilder that = (AttributeMatchBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
