package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CompressedAttributesBuilder extends CompressedAttributesFluentImpl<CompressedAttributesBuilder> implements VisitableBuilder<CompressedAttributes,CompressedAttributesBuilder>{

    CompressedAttributesFluent<?> fluent;
    Boolean validationEnabled;

    public CompressedAttributesBuilder(){
            this(true);
    }
    public CompressedAttributesBuilder(Boolean validationEnabled){
            this(new CompressedAttributes(), validationEnabled);
    }
    public CompressedAttributesBuilder(CompressedAttributesFluent<?> fluent){
            this(fluent, true);
    }
    public CompressedAttributesBuilder(CompressedAttributesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CompressedAttributes(), validationEnabled);
    }
    public CompressedAttributesBuilder(CompressedAttributesFluent<?> fluent,CompressedAttributes instance){
            this(fluent, instance, true);
    }
    public CompressedAttributesBuilder(CompressedAttributesFluent<?> fluent,CompressedAttributes instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBools(instance.getBools()); 
            fluent.withBytes(instance.getBytes()); 
            fluent.withDoubles(instance.getDoubles()); 
            fluent.withDurations(instance.getDurations()); 
            fluent.withInt64s(instance.getInt64s()); 
            fluent.withStringMaps(instance.getStringMaps()); 
            fluent.withStrings(instance.getStrings()); 
            fluent.withTimestamps(instance.getTimestamps()); 
            fluent.withWords(instance.getWords()); 
            this.validationEnabled = validationEnabled; 
    }
    public CompressedAttributesBuilder(CompressedAttributes instance){
            this(instance,true);
    }
    public CompressedAttributesBuilder(CompressedAttributes instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBools(instance.getBools()); 
            this.withBytes(instance.getBytes()); 
            this.withDoubles(instance.getDoubles()); 
            this.withDurations(instance.getDurations()); 
            this.withInt64s(instance.getInt64s()); 
            this.withStringMaps(instance.getStringMaps()); 
            this.withStrings(instance.getStrings()); 
            this.withTimestamps(instance.getTimestamps()); 
            this.withWords(instance.getWords()); 
            this.validationEnabled = validationEnabled; 
    }

    public CompressedAttributes build(){
            CompressedAttributes buildable = new CompressedAttributes(fluent.getBools(),fluent.getBytes(),fluent.getDoubles(),fluent.getDurations(),fluent.getInt64s(),fluent.getStringMaps(),fluent.getStrings(),fluent.getTimestamps(),fluent.getWords());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CompressedAttributesBuilder that = (CompressedAttributesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
