package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Double;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class CompressedAttributesFluentImpl<A extends CompressedAttributesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CompressedAttributesFluent<A>{

    private Map<String,Boolean> bools;
    private Map<String,String> bytes;
    private Map<String,Double> doubles;
    private Map<String,Long> durations;
    private Map<String,Long> int64s;
    private Map<String,StringMap> stringMaps;
    private Map<String,Integer> strings;
    private Map<String,String> timestamps;
    private List<String> words;

    public CompressedAttributesFluentImpl(){
    }
    public CompressedAttributesFluentImpl(CompressedAttributes instance){
            this.withBools(instance.getBools()); 
            this.withBytes(instance.getBytes()); 
            this.withDoubles(instance.getDoubles()); 
            this.withDurations(instance.getDurations()); 
            this.withInt64s(instance.getInt64s()); 
            this.withStringMaps(instance.getStringMaps()); 
            this.withStrings(instance.getStrings()); 
            this.withTimestamps(instance.getTimestamps()); 
            this.withWords(instance.getWords()); 
    }

    public A addToBools(String key,Boolean value){
            if(this.bools == null && key != null && value != null) { this.bools = new LinkedHashMap<String,Boolean>(); }
            if(key != null && value != null) {this.bools.put(key, value);} return (A)this;
    }

    public A addToBools(Map<String,Boolean> map){
            if(this.bools == null && map != null) { this.bools = new LinkedHashMap<String,Boolean>(); }
            if(map != null) { this.bools.putAll(map);} return (A)this;
    }

    public A removeFromBools(String key){
            if(this.bools == null) { return (A) this; }
            if(key != null && this.bools != null) {this.bools.remove(key);} return (A)this;
    }

    public A removeFromBools(Map<String,Boolean> map){
            if(this.bools == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.bools != null){this.bools.remove(key);}}} return (A)this;
    }

    public Map<String,Boolean> getBools(){
            return this.bools;
    }

    public A withBools(Map<String,Boolean> bools){
            if (bools == null) { this.bools =  null;} else {this.bools = new LinkedHashMap<String,Boolean>(bools);} return (A) this;
    }

    public Boolean hasBools(){
            return this.bools != null;
    }

    public A addToBytes(String key,String value){
            if(this.bytes == null && key != null && value != null) { this.bytes = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.bytes.put(key, value);} return (A)this;
    }

    public A addToBytes(Map<String,String> map){
            if(this.bytes == null && map != null) { this.bytes = new LinkedHashMap<String,String>(); }
            if(map != null) { this.bytes.putAll(map);} return (A)this;
    }

    public A removeFromBytes(String key){
            if(this.bytes == null) { return (A) this; }
            if(key != null && this.bytes != null) {this.bytes.remove(key);} return (A)this;
    }

    public A removeFromBytes(Map<String,String> map){
            if(this.bytes == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.bytes != null){this.bytes.remove(key);}}} return (A)this;
    }

    public Map<String,String> getBytes(){
            return this.bytes;
    }

    public A withBytes(Map<String,String> bytes){
            if (bytes == null) { this.bytes =  null;} else {this.bytes = new LinkedHashMap<String,String>(bytes);} return (A) this;
    }

    public Boolean hasBytes(){
            return this.bytes != null;
    }

    public A addToDoubles(String key,Double value){
            if(this.doubles == null && key != null && value != null) { this.doubles = new LinkedHashMap<String,Double>(); }
            if(key != null && value != null) {this.doubles.put(key, value);} return (A)this;
    }

    public A addToDoubles(Map<String,Double> map){
            if(this.doubles == null && map != null) { this.doubles = new LinkedHashMap<String,Double>(); }
            if(map != null) { this.doubles.putAll(map);} return (A)this;
    }

    public A removeFromDoubles(String key){
            if(this.doubles == null) { return (A) this; }
            if(key != null && this.doubles != null) {this.doubles.remove(key);} return (A)this;
    }

    public A removeFromDoubles(Map<String,Double> map){
            if(this.doubles == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.doubles != null){this.doubles.remove(key);}}} return (A)this;
    }

    public Map<String,Double> getDoubles(){
            return this.doubles;
    }

    public A withDoubles(Map<String,Double> doubles){
            if (doubles == null) { this.doubles =  null;} else {this.doubles = new LinkedHashMap<String,Double>(doubles);} return (A) this;
    }

    public Boolean hasDoubles(){
            return this.doubles != null;
    }

    public A addToDurations(String key,Long value){
            if(this.durations == null && key != null && value != null) { this.durations = new LinkedHashMap<String,Long>(); }
            if(key != null && value != null) {this.durations.put(key, value);} return (A)this;
    }

    public A addToDurations(Map<String,Long> map){
            if(this.durations == null && map != null) { this.durations = new LinkedHashMap<String,Long>(); }
            if(map != null) { this.durations.putAll(map);} return (A)this;
    }

    public A removeFromDurations(String key){
            if(this.durations == null) { return (A) this; }
            if(key != null && this.durations != null) {this.durations.remove(key);} return (A)this;
    }

    public A removeFromDurations(Map<String,Long> map){
            if(this.durations == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.durations != null){this.durations.remove(key);}}} return (A)this;
    }

    public Map<String,Long> getDurations(){
            return this.durations;
    }

    public A withDurations(Map<String,Long> durations){
            if (durations == null) { this.durations =  null;} else {this.durations = new LinkedHashMap<String,Long>(durations);} return (A) this;
    }

    public Boolean hasDurations(){
            return this.durations != null;
    }

    public A addToInt64s(String key,Long value){
            if(this.int64s == null && key != null && value != null) { this.int64s = new LinkedHashMap<String,Long>(); }
            if(key != null && value != null) {this.int64s.put(key, value);} return (A)this;
    }

    public A addToInt64s(Map<String,Long> map){
            if(this.int64s == null && map != null) { this.int64s = new LinkedHashMap<String,Long>(); }
            if(map != null) { this.int64s.putAll(map);} return (A)this;
    }

    public A removeFromInt64s(String key){
            if(this.int64s == null) { return (A) this; }
            if(key != null && this.int64s != null) {this.int64s.remove(key);} return (A)this;
    }

    public A removeFromInt64s(Map<String,Long> map){
            if(this.int64s == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.int64s != null){this.int64s.remove(key);}}} return (A)this;
    }

    public Map<String,Long> getInt64s(){
            return this.int64s;
    }

    public A withInt64s(Map<String,Long> int64s){
            if (int64s == null) { this.int64s =  null;} else {this.int64s = new LinkedHashMap<String,Long>(int64s);} return (A) this;
    }

    public Boolean hasInt64s(){
            return this.int64s != null;
    }

    public A addToStringMaps(String key,StringMap value){
            if(this.stringMaps == null && key != null && value != null) { this.stringMaps = new LinkedHashMap<String,StringMap>(); }
            if(key != null && value != null) {this.stringMaps.put(key, value);} return (A)this;
    }

    public A addToStringMaps(Map<String,StringMap> map){
            if(this.stringMaps == null && map != null) { this.stringMaps = new LinkedHashMap<String,StringMap>(); }
            if(map != null) { this.stringMaps.putAll(map);} return (A)this;
    }

    public A removeFromStringMaps(String key){
            if(this.stringMaps == null) { return (A) this; }
            if(key != null && this.stringMaps != null) {this.stringMaps.remove(key);} return (A)this;
    }

    public A removeFromStringMaps(Map<String,StringMap> map){
            if(this.stringMaps == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.stringMaps != null){this.stringMaps.remove(key);}}} return (A)this;
    }

    public Map<String,StringMap> getStringMaps(){
            return this.stringMaps;
    }

    public A withStringMaps(Map<String,StringMap> stringMaps){
            if (stringMaps == null) { this.stringMaps =  null;} else {this.stringMaps = new LinkedHashMap<String,StringMap>(stringMaps);} return (A) this;
    }

    public Boolean hasStringMaps(){
            return this.stringMaps != null;
    }

    public A addToStrings(String key,Integer value){
            if(this.strings == null && key != null && value != null) { this.strings = new LinkedHashMap<String,Integer>(); }
            if(key != null && value != null) {this.strings.put(key, value);} return (A)this;
    }

    public A addToStrings(Map<String,Integer> map){
            if(this.strings == null && map != null) { this.strings = new LinkedHashMap<String,Integer>(); }
            if(map != null) { this.strings.putAll(map);} return (A)this;
    }

    public A removeFromStrings(String key){
            if(this.strings == null) { return (A) this; }
            if(key != null && this.strings != null) {this.strings.remove(key);} return (A)this;
    }

    public A removeFromStrings(Map<String,Integer> map){
            if(this.strings == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.strings != null){this.strings.remove(key);}}} return (A)this;
    }

    public Map<String,Integer> getStrings(){
            return this.strings;
    }

    public A withStrings(Map<String,Integer> strings){
            if (strings == null) { this.strings =  null;} else {this.strings = new LinkedHashMap<String,Integer>(strings);} return (A) this;
    }

    public Boolean hasStrings(){
            return this.strings != null;
    }

    public A addToTimestamps(String key,String value){
            if(this.timestamps == null && key != null && value != null) { this.timestamps = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.timestamps.put(key, value);} return (A)this;
    }

    public A addToTimestamps(Map<String,String> map){
            if(this.timestamps == null && map != null) { this.timestamps = new LinkedHashMap<String,String>(); }
            if(map != null) { this.timestamps.putAll(map);} return (A)this;
    }

    public A removeFromTimestamps(String key){
            if(this.timestamps == null) { return (A) this; }
            if(key != null && this.timestamps != null) {this.timestamps.remove(key);} return (A)this;
    }

    public A removeFromTimestamps(Map<String,String> map){
            if(this.timestamps == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.timestamps != null){this.timestamps.remove(key);}}} return (A)this;
    }

    public Map<String,String> getTimestamps(){
            return this.timestamps;
    }

    public A withTimestamps(Map<String,String> timestamps){
            if (timestamps == null) { this.timestamps =  null;} else {this.timestamps = new LinkedHashMap<String,String>(timestamps);} return (A) this;
    }

    public Boolean hasTimestamps(){
            return this.timestamps != null;
    }

    public A addToWords(int index,String item){
            if (this.words == null) {this.words = new ArrayList<String>();}
            this.words.add(index, item);
            return (A)this;
    }

    public A setToWords(int index,String item){
            if (this.words == null) {this.words = new ArrayList<String>();}
            this.words.set(index, item); return (A)this;
    }

    public A addToWords(String... items){
            if (this.words == null) {this.words = new ArrayList<String>();}
            for (String item : items) {this.words.add(item);} return (A)this;
    }

    public A addAllToWords(Collection<String> items){
            if (this.words == null) {this.words = new ArrayList<String>();}
            for (String item : items) {this.words.add(item);} return (A)this;
    }

    public A removeFromWords(String... items){
            for (String item : items) {if (this.words!= null){ this.words.remove(item);}} return (A)this;
    }

    public A removeAllFromWords(Collection<String> items){
            for (String item : items) {if (this.words!= null){ this.words.remove(item);}} return (A)this;
    }

    public List<String> getWords(){
            return this.words;
    }

    public String getWord(int index){
            return this.words.get(index);
    }

    public String getFirstWord(){
            return this.words.get(0);
    }

    public String getLastWord(){
            return this.words.get(words.size() - 1);
    }

    public String getMatchingWord(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: words) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingWord(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: words) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withWords(List<String> words){
            if (this.words != null) { _visitables.get("words").removeAll(this.words);}
            if (words != null) {this.words = new ArrayList<String>(); for (String item : words){this.addToWords(item);}} else { this.words = null;} return (A) this;
    }

    public A withWords(String... words){
            if (this.words != null) {this.words.clear();}
            if (words != null) {for (String item :words){ this.addToWords(item);}} return (A) this;
    }

    public Boolean hasWords(){
            return words != null && !words.isEmpty();
    }

    public A addNewWord(String arg1){
            return (A)addToWords(new String(arg1));
    }

    public A addNewWord(StringBuilder arg1){
            return (A)addToWords(new String(arg1));
    }

    public A addNewWord(StringBuffer arg1){
            return (A)addToWords(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CompressedAttributesFluentImpl that = (CompressedAttributesFluentImpl) o;
            if (bools != null ? !bools.equals(that.bools) :that.bools != null) return false;
            if (bytes != null ? !bytes.equals(that.bytes) :that.bytes != null) return false;
            if (doubles != null ? !doubles.equals(that.doubles) :that.doubles != null) return false;
            if (durations != null ? !durations.equals(that.durations) :that.durations != null) return false;
            if (int64s != null ? !int64s.equals(that.int64s) :that.int64s != null) return false;
            if (stringMaps != null ? !stringMaps.equals(that.stringMaps) :that.stringMaps != null) return false;
            if (strings != null ? !strings.equals(that.strings) :that.strings != null) return false;
            if (timestamps != null ? !timestamps.equals(that.timestamps) :that.timestamps != null) return false;
            if (words != null ? !words.equals(that.words) :that.words != null) return false;
            return true;
    }




}
