package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class QuotaParamsBuilder extends QuotaParamsFluentImpl<QuotaParamsBuilder> implements VisitableBuilder<QuotaParams,QuotaParamsBuilder>{

    QuotaParamsFluent<?> fluent;
    Boolean validationEnabled;

    public QuotaParamsBuilder(){
            this(true);
    }
    public QuotaParamsBuilder(Boolean validationEnabled){
            this(new QuotaParams(), validationEnabled);
    }
    public QuotaParamsBuilder(QuotaParamsFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaParamsBuilder(QuotaParamsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new QuotaParams(), validationEnabled);
    }
    public QuotaParamsBuilder(QuotaParamsFluent<?> fluent,QuotaParams instance){
            this(fluent, instance, true);
    }
    public QuotaParamsBuilder(QuotaParamsFluent<?> fluent,QuotaParams instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAmount(instance.getAmount()); 
            fluent.withBestEffort(instance.getBestEffort()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaParamsBuilder(QuotaParams instance){
            this(instance,true);
    }
    public QuotaParamsBuilder(QuotaParams instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAmount(instance.getAmount()); 
            this.withBestEffort(instance.getBestEffort()); 
            this.validationEnabled = validationEnabled; 
    }

    public QuotaParams build(){
            QuotaParams buildable = new QuotaParams(fluent.getAmount(),fluent.isBestEffort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaParamsBuilder that = (QuotaParamsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
