
package me.snowdrop.istio.api.mixer.v1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "grantedAmount",
    "referencedAttributes",
    "validDuration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class QuotaResult implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("grantedAmount")
    @JsonPropertyDescription("")
    private Integer grantedAmount;
    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    @JsonPropertyDescription("")
    private ReferencedAttributes referencedAttributes;
    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Integer validDuration;
    private final static long serialVersionUID = -6681764037934375647L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public QuotaResult() {
    }

    /**
     * 
     * @param grantedAmount
     * @param referencedAttributes
     * @param validDuration
     */
    public QuotaResult(Integer grantedAmount, ReferencedAttributes referencedAttributes, Integer validDuration) {
        super();
        this.grantedAmount = grantedAmount;
        this.referencedAttributes = referencedAttributes;
        this.validDuration = validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("grantedAmount")
    public Integer getGrantedAmount() {
        return grantedAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("grantedAmount")
    public void setGrantedAmount(Integer grantedAmount) {
        this.grantedAmount = grantedAmount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    public ReferencedAttributes getReferencedAttributes() {
        return referencedAttributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("referencedAttributes")
    public void setReferencedAttributes(ReferencedAttributes referencedAttributes) {
        this.referencedAttributes = referencedAttributes;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public Integer getValidDuration() {
        return validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public void setValidDuration(Integer validDuration) {
        this.validDuration = validDuration;
    }

}
