package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class QuotaResultFluentImpl<A extends QuotaResultFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements QuotaResultFluent<A>{

    private Integer grantedAmount;
    private ReferencedAttributesBuilder referencedAttributes;
    private Integer validDuration;

    public QuotaResultFluentImpl(){
    }
    public QuotaResultFluentImpl(QuotaResult instance){
            this.withGrantedAmount(instance.getGrantedAmount()); 
            this.withReferencedAttributes(instance.getReferencedAttributes()); 
            this.withValidDuration(instance.getValidDuration()); 
    }

    public Integer getGrantedAmount(){
            return this.grantedAmount;
    }

    public A withGrantedAmount(Integer grantedAmount){
            this.grantedAmount=grantedAmount; return (A) this;
    }

    public Boolean hasGrantedAmount(){
            return this.grantedAmount != null;
    }

    
/**
 * This method has been deprecated, please use method buildReferencedAttributes instead.
 * @return The buildable object.
 */
@Deprecated public ReferencedAttributes getReferencedAttributes(){
            return this.referencedAttributes!=null?this.referencedAttributes.build():null;
    }

    public ReferencedAttributes buildReferencedAttributes(){
            return this.referencedAttributes!=null?this.referencedAttributes.build():null;
    }

    public A withReferencedAttributes(ReferencedAttributes referencedAttributes){
            _visitables.get("referencedAttributes").remove(this.referencedAttributes);
            if (referencedAttributes!=null){ this.referencedAttributes= new ReferencedAttributesBuilder(referencedAttributes); _visitables.get("referencedAttributes").add(this.referencedAttributes);} return (A) this;
    }

    public Boolean hasReferencedAttributes(){
            return this.referencedAttributes != null;
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> withNewReferencedAttributes(){
            return new ReferencedAttributesNestedImpl();
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> withNewReferencedAttributesLike(ReferencedAttributes item){
            return new ReferencedAttributesNestedImpl(item);
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> editReferencedAttributes(){
            return withNewReferencedAttributesLike(getReferencedAttributes());
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> editOrNewReferencedAttributes(){
            return withNewReferencedAttributesLike(getReferencedAttributes() != null ? getReferencedAttributes(): new ReferencedAttributesBuilder().build());
    }

    public QuotaResultFluent.ReferencedAttributesNested<A> editOrNewReferencedAttributesLike(ReferencedAttributes item){
            return withNewReferencedAttributesLike(getReferencedAttributes() != null ? getReferencedAttributes(): item);
    }

    public Integer getValidDuration(){
            return this.validDuration;
    }

    public A withValidDuration(Integer validDuration){
            this.validDuration=validDuration; return (A) this;
    }

    public Boolean hasValidDuration(){
            return this.validDuration != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            QuotaResultFluentImpl that = (QuotaResultFluentImpl) o;
            if (grantedAmount != null ? !grantedAmount.equals(that.grantedAmount) :that.grantedAmount != null) return false;
            if (referencedAttributes != null ? !referencedAttributes.equals(that.referencedAttributes) :that.referencedAttributes != null) return false;
            if (validDuration != null ? !validDuration.equals(that.validDuration) :that.validDuration != null) return false;
            return true;
    }


    public class ReferencedAttributesNestedImpl<N> extends ReferencedAttributesFluentImpl<QuotaResultFluent.ReferencedAttributesNested<N>> implements QuotaResultFluent.ReferencedAttributesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReferencedAttributesBuilder builder;
    
            ReferencedAttributesNestedImpl(ReferencedAttributes item){
                    this.builder = new ReferencedAttributesBuilder(this, item);
            }
            ReferencedAttributesNestedImpl(){
                    this.builder = new ReferencedAttributesBuilder(this);
            }
    
    public N and(){
            return (N) QuotaResultFluentImpl.this.withReferencedAttributes(builder.build());
    }
    public N endReferencedAttributes(){
            return and();
    }

}


}
