package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ReferencedAttributesFluentImpl<A extends ReferencedAttributesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ReferencedAttributesFluent<A>{

    private List<AttributeMatchBuilder> attributeMatches;
    private List<String> words;

    public ReferencedAttributesFluentImpl(){
    }
    public ReferencedAttributesFluentImpl(ReferencedAttributes instance){
            this.withAttributeMatches(instance.getAttributeMatches()); 
            this.withWords(instance.getWords()); 
    }

    public A addToAttributeMatches(int index,AttributeMatch item){
            if (this.attributeMatches == null) {this.attributeMatches = new ArrayList<AttributeMatchBuilder>();}
            AttributeMatchBuilder builder = new AttributeMatchBuilder(item);_visitables.get("attributeMatches").add(index >= 0 ? index : _visitables.get("attributeMatches").size(), builder);this.attributeMatches.add(index >= 0 ? index : attributeMatches.size(), builder); return (A)this;
    }

    public A setToAttributeMatches(int index,AttributeMatch item){
            if (this.attributeMatches == null) {this.attributeMatches = new ArrayList<AttributeMatchBuilder>();}
            AttributeMatchBuilder builder = new AttributeMatchBuilder(item);
            if (index < 0 || index >= _visitables.get("attributeMatches").size()) { _visitables.get("attributeMatches").add(builder); } else { _visitables.get("attributeMatches").set(index, builder);}
            if (index < 0 || index >= attributeMatches.size()) { attributeMatches.add(builder); } else { attributeMatches.set(index, builder);}
             return (A)this;
    }

    public A addToAttributeMatches(AttributeMatch... items){
            if (this.attributeMatches == null) {this.attributeMatches = new ArrayList<AttributeMatchBuilder>();}
            for (AttributeMatch item : items) {AttributeMatchBuilder builder = new AttributeMatchBuilder(item);_visitables.get("attributeMatches").add(builder);this.attributeMatches.add(builder);} return (A)this;
    }

    public A addAllToAttributeMatches(Collection<AttributeMatch> items){
            if (this.attributeMatches == null) {this.attributeMatches = new ArrayList<AttributeMatchBuilder>();}
            for (AttributeMatch item : items) {AttributeMatchBuilder builder = new AttributeMatchBuilder(item);_visitables.get("attributeMatches").add(builder);this.attributeMatches.add(builder);} return (A)this;
    }

    public A removeFromAttributeMatches(AttributeMatch... items){
            for (AttributeMatch item : items) {AttributeMatchBuilder builder = new AttributeMatchBuilder(item);_visitables.get("attributeMatches").remove(builder);if (this.attributeMatches != null) {this.attributeMatches.remove(builder);}} return (A)this;
    }

    public A removeAllFromAttributeMatches(Collection<AttributeMatch> items){
            for (AttributeMatch item : items) {AttributeMatchBuilder builder = new AttributeMatchBuilder(item);_visitables.get("attributeMatches").remove(builder);if (this.attributeMatches != null) {this.attributeMatches.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAttributeMatches(io.fabric8.kubernetes.api.builder.Predicate<AttributeMatchBuilder> predicate){
            if (attributeMatches == null) return (A) this;
            final Iterator<AttributeMatchBuilder> each = attributeMatches.iterator();
            final List visitables = _visitables.get("attributeMatches");
            while (each.hasNext()) {
              AttributeMatchBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAttributeMatches instead.
 * @return The buildable object.
 */
@Deprecated public List<AttributeMatch> getAttributeMatches(){
            return build(attributeMatches);
    }

    public List<AttributeMatch> buildAttributeMatches(){
            return build(attributeMatches);
    }

    public AttributeMatch buildAttributeMatch(int index){
            return this.attributeMatches.get(index).build();
    }

    public AttributeMatch buildFirstAttributeMatch(){
            return this.attributeMatches.get(0).build();
    }

    public AttributeMatch buildLastAttributeMatch(){
            return this.attributeMatches.get(attributeMatches.size() - 1).build();
    }

    public AttributeMatch buildMatchingAttributeMatch(io.fabric8.kubernetes.api.builder.Predicate<AttributeMatchBuilder> predicate){
            for (AttributeMatchBuilder item: attributeMatches) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAttributeMatch(io.fabric8.kubernetes.api.builder.Predicate<AttributeMatchBuilder> predicate){
            for (AttributeMatchBuilder item: attributeMatches) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAttributeMatches(List<AttributeMatch> attributeMatches){
            if (this.attributeMatches != null) { _visitables.get("attributeMatches").removeAll(this.attributeMatches);}
            if (attributeMatches != null) {this.attributeMatches = new ArrayList<AttributeMatchBuilder>(); for (AttributeMatch item : attributeMatches){this.addToAttributeMatches(item);}} else { this.attributeMatches = null;} return (A) this;
    }

    public A withAttributeMatches(AttributeMatch... attributeMatches){
            if (this.attributeMatches != null) {this.attributeMatches.clear();}
            if (attributeMatches != null) {for (AttributeMatch item :attributeMatches){ this.addToAttributeMatches(item);}} return (A) this;
    }

    public Boolean hasAttributeMatches(){
            return attributeMatches != null && !attributeMatches.isEmpty();
    }

    public ReferencedAttributesFluent.AttributeMatchesNested<A> addNewAttributeMatch(){
            return new AttributeMatchesNestedImpl();
    }

    public ReferencedAttributesFluent.AttributeMatchesNested<A> addNewAttributeMatchLike(AttributeMatch item){
            return new AttributeMatchesNestedImpl(-1, item);
    }

    public ReferencedAttributesFluent.AttributeMatchesNested<A> setNewAttributeMatchLike(int index,AttributeMatch item){
            return new AttributeMatchesNestedImpl(index, item);
    }

    public ReferencedAttributesFluent.AttributeMatchesNested<A> editAttributeMatch(int index){
            if (attributeMatches.size() <= index) throw new RuntimeException("Can't edit attributeMatches. Index exceeds size.");
            return setNewAttributeMatchLike(index, buildAttributeMatch(index));
    }

    public ReferencedAttributesFluent.AttributeMatchesNested<A> editFirstAttributeMatch(){
            if (attributeMatches.size() == 0) throw new RuntimeException("Can't edit first attributeMatches. The list is empty.");
            return setNewAttributeMatchLike(0, buildAttributeMatch(0));
    }

    public ReferencedAttributesFluent.AttributeMatchesNested<A> editLastAttributeMatch(){
            int index = attributeMatches.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last attributeMatches. The list is empty.");
            return setNewAttributeMatchLike(index, buildAttributeMatch(index));
    }

    public ReferencedAttributesFluent.AttributeMatchesNested<A> editMatchingAttributeMatch(io.fabric8.kubernetes.api.builder.Predicate<AttributeMatchBuilder> predicate){
            int index = -1;
            for (int i=0;i<attributeMatches.size();i++) { 
            if (predicate.apply(attributeMatches.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching attributeMatches. No match found.");
            return setNewAttributeMatchLike(index, buildAttributeMatch(index));
    }

    public A addToWords(int index,String item){
            if (this.words == null) {this.words = new ArrayList<String>();}
            this.words.add(index, item);
            return (A)this;
    }

    public A setToWords(int index,String item){
            if (this.words == null) {this.words = new ArrayList<String>();}
            this.words.set(index, item); return (A)this;
    }

    public A addToWords(String... items){
            if (this.words == null) {this.words = new ArrayList<String>();}
            for (String item : items) {this.words.add(item);} return (A)this;
    }

    public A addAllToWords(Collection<String> items){
            if (this.words == null) {this.words = new ArrayList<String>();}
            for (String item : items) {this.words.add(item);} return (A)this;
    }

    public A removeFromWords(String... items){
            for (String item : items) {if (this.words!= null){ this.words.remove(item);}} return (A)this;
    }

    public A removeAllFromWords(Collection<String> items){
            for (String item : items) {if (this.words!= null){ this.words.remove(item);}} return (A)this;
    }

    public List<String> getWords(){
            return this.words;
    }

    public String getWord(int index){
            return this.words.get(index);
    }

    public String getFirstWord(){
            return this.words.get(0);
    }

    public String getLastWord(){
            return this.words.get(words.size() - 1);
    }

    public String getMatchingWord(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: words) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingWord(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: words) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withWords(List<String> words){
            if (this.words != null) { _visitables.get("words").removeAll(this.words);}
            if (words != null) {this.words = new ArrayList<String>(); for (String item : words){this.addToWords(item);}} else { this.words = null;} return (A) this;
    }

    public A withWords(String... words){
            if (this.words != null) {this.words.clear();}
            if (words != null) {for (String item :words){ this.addToWords(item);}} return (A) this;
    }

    public Boolean hasWords(){
            return words != null && !words.isEmpty();
    }

    public A addNewWord(String arg1){
            return (A)addToWords(new String(arg1));
    }

    public A addNewWord(StringBuilder arg1){
            return (A)addToWords(new String(arg1));
    }

    public A addNewWord(StringBuffer arg1){
            return (A)addToWords(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ReferencedAttributesFluentImpl that = (ReferencedAttributesFluentImpl) o;
            if (attributeMatches != null ? !attributeMatches.equals(that.attributeMatches) :that.attributeMatches != null) return false;
            if (words != null ? !words.equals(that.words) :that.words != null) return false;
            return true;
    }


    public class AttributeMatchesNestedImpl<N> extends AttributeMatchFluentImpl<ReferencedAttributesFluent.AttributeMatchesNested<N>> implements ReferencedAttributesFluent.AttributeMatchesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AttributeMatchBuilder builder;
        private final int index;
    
            AttributeMatchesNestedImpl(int index,AttributeMatch item){
                    this.index = index;
                    this.builder = new AttributeMatchBuilder(this, item);
            }
            AttributeMatchesNestedImpl(){
                    this.index = -1;
                    this.builder = new AttributeMatchBuilder(this);
            }
    
    public N and(){
            return (N) ReferencedAttributesFluentImpl.this.setToAttributeMatches(index, builder.build());
    }
    public N endAttributeMatch(){
            return and();
    }

}


}
