package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReportRequestBuilder extends ReportRequestFluentImpl<ReportRequestBuilder> implements VisitableBuilder<ReportRequest,ReportRequestBuilder>{

    ReportRequestFluent<?> fluent;
    Boolean validationEnabled;

    public ReportRequestBuilder(){
            this(true);
    }
    public ReportRequestBuilder(Boolean validationEnabled){
            this(new ReportRequest(), validationEnabled);
    }
    public ReportRequestBuilder(ReportRequestFluent<?> fluent){
            this(fluent, true);
    }
    public ReportRequestBuilder(ReportRequestFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReportRequest(), validationEnabled);
    }
    public ReportRequestBuilder(ReportRequestFluent<?> fluent,ReportRequest instance){
            this(fluent, instance, true);
    }
    public ReportRequestBuilder(ReportRequestFluent<?> fluent,ReportRequest instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withDefaultWords(instance.getDefaultWords()); 
            fluent.withGlobalWordCount(instance.getGlobalWordCount()); 
            fluent.withRepeatedAttributesSemantics(instance.getRepeatedAttributesSemantics()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReportRequestBuilder(ReportRequest instance){
            this(instance,true);
    }
    public ReportRequestBuilder(ReportRequest instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttributes(instance.getAttributes()); 
            this.withDefaultWords(instance.getDefaultWords()); 
            this.withGlobalWordCount(instance.getGlobalWordCount()); 
            this.withRepeatedAttributesSemantics(instance.getRepeatedAttributesSemantics()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReportRequest build(){
            ReportRequest buildable = new ReportRequest(fluent.getAttributes(),fluent.getDefaultWords(),fluent.getGlobalWordCount(),fluent.getRepeatedAttributesSemantics());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReportRequestBuilder that = (ReportRequestBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
