package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReportResponseBuilder extends ReportResponseFluentImpl<ReportResponseBuilder> implements VisitableBuilder<ReportResponse,ReportResponseBuilder>{

    ReportResponseFluent<?> fluent;
    Boolean validationEnabled;

    public ReportResponseBuilder(){
            this(true);
    }
    public ReportResponseBuilder(Boolean validationEnabled){
            this(new ReportResponse(), validationEnabled);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent){
            this(fluent, true);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReportResponse(), validationEnabled);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent,ReportResponse instance){
            this(fluent, instance, true);
    }
    public ReportResponseBuilder(ReportResponseFluent<?> fluent,ReportResponse instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public ReportResponseBuilder(ReportResponse instance){
            this(instance,true);
    }
    public ReportResponseBuilder(ReportResponse instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public ReportResponse build(){
            ReportResponse buildable = new ReportResponse();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReportResponseBuilder that = (ReportResponseBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
