
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "errorType",
    "percent",
    "percentage"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Abort implements Serializable
{

    @JsonProperty("errorType")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType errorType;
    /**
     * 
     * 
     */
    @JsonProperty("percent")
    @JsonPropertyDescription("")
    private Integer percent;
    /**
     * 
     * 
     */
    @JsonProperty("percentage")
    @JsonPropertyDescription("")
    private Percent percentage;
    private final static long serialVersionUID = 7121060348015116201L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Abort() {
    }

    /**
     * 
     * @param errorType
     * @param percentage
     * @param percent
     */
    public Abort(me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType errorType, Integer percent, Percent percentage) {
        super();
        this.errorType = errorType;
        this.percent = percent;
        this.percentage = percentage;
    }

    @JsonProperty("errorType")
    public me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType getErrorType() {
        return errorType;
    }

    @JsonProperty("errorType")
    public void setErrorType(me.snowdrop.istio.api.networking.v1alpha3.Abort.ErrorType errorType) {
        this.errorType = errorType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percent")
    public Integer getPercent() {
        return percent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percent")
    public void setPercent(Integer percent) {
        this.percent = percent;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percentage")
    public Percent getPercentage() {
        return percentage;
    }

    /**
     * 
     * 
     */
    @JsonProperty("percentage")
    public void setPercentage(Percent percentage) {
        this.percentage = percentage;
    }

    public interface ErrorType extends Serializable
    {


    }

}
