package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;

public class AbortFluentImpl<A extends AbortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AbortFluent<A>{

    private VisitableBuilder<? extends Abort.ErrorType,?> errorType;
    private Integer percent;
    private PercentBuilder percentage;

    public AbortFluentImpl(){
    }
    public AbortFluentImpl(Abort instance){
            this.withErrorType(instance.getErrorType()); 
            this.withPercent(instance.getPercent()); 
            this.withPercentage(instance.getPercentage()); 
    }

    
/**
 * This method has been deprecated, please use method buildErrorType instead.
 * @return The buildable object.
 */
@Deprecated public Abort.ErrorType getErrorType(){
            return this.errorType!=null?this.errorType.build():null;
    }

    public Abort.ErrorType buildErrorType(){
            return this.errorType!=null?this.errorType.build():null;
    }

    public A withErrorType(Abort.ErrorType errorType){
            if (errorType instanceof HttpStatusErrorType){ this.errorType= new HttpStatusErrorTypeBuilder((HttpStatusErrorType)errorType); _visitables.get("errorType").add(this.errorType);}
            if (errorType instanceof GrpcStatusErrorType){ this.errorType= new GrpcStatusErrorTypeBuilder((GrpcStatusErrorType)errorType); _visitables.get("errorType").add(this.errorType);}
            if (errorType instanceof Http2ErrorErrorType){ this.errorType= new Http2ErrorErrorTypeBuilder((Http2ErrorErrorType)errorType); _visitables.get("errorType").add(this.errorType);}
            return (A) this;
    }

    public Boolean hasErrorType(){
            return this.errorType != null;
    }

    public A withHttpStatusErrorType(HttpStatusErrorType httpStatusErrorType){
            _visitables.get("errorType").remove(this.errorType);
            if (httpStatusErrorType!=null){ this.errorType= new HttpStatusErrorTypeBuilder(httpStatusErrorType); _visitables.get("errorType").add(this.errorType);} return (A) this;
    }

    public AbortFluent.HttpStatusErrorTypeNested<A> withNewHttpStatusErrorType(){
            return new HttpStatusErrorTypeNestedImpl();
    }

    public AbortFluent.HttpStatusErrorTypeNested<A> withNewHttpStatusErrorTypeLike(HttpStatusErrorType item){
            return new HttpStatusErrorTypeNestedImpl(item);
    }

    public A withNewHttpStatusErrorType(Integer httpStatus){
            return (A)withHttpStatusErrorType(new HttpStatusErrorType(httpStatus));
    }

    public A withGrpcStatusErrorType(GrpcStatusErrorType grpcStatusErrorType){
            _visitables.get("errorType").remove(this.errorType);
            if (grpcStatusErrorType!=null){ this.errorType= new GrpcStatusErrorTypeBuilder(grpcStatusErrorType); _visitables.get("errorType").add(this.errorType);} return (A) this;
    }

    public AbortFluent.GrpcStatusErrorTypeNested<A> withNewGrpcStatusErrorType(){
            return new GrpcStatusErrorTypeNestedImpl();
    }

    public AbortFluent.GrpcStatusErrorTypeNested<A> withNewGrpcStatusErrorTypeLike(GrpcStatusErrorType item){
            return new GrpcStatusErrorTypeNestedImpl(item);
    }

    public A withNewGrpcStatusErrorType(String grpcStatus){
            return (A)withGrpcStatusErrorType(new GrpcStatusErrorType(grpcStatus));
    }

    public A withHttp2ErrorType(Http2ErrorErrorType http2ErrorType){
            _visitables.get("errorType").remove(this.errorType);
            if (http2ErrorType!=null){ this.errorType= new Http2ErrorErrorTypeBuilder(http2ErrorType); _visitables.get("errorType").add(this.errorType);} return (A) this;
    }

    public AbortFluent.Http2ErrorTypeNested<A> withNewHttp2ErrorType(){
            return new Http2ErrorTypeNestedImpl();
    }

    public AbortFluent.Http2ErrorTypeNested<A> withNewHttp2ErrorTypeLike(Http2ErrorErrorType item){
            return new Http2ErrorTypeNestedImpl(item);
    }

    public A withNewHttp2ErrorType(String http2Error){
            return (A)withHttp2ErrorType(new Http2ErrorErrorType(http2Error));
    }

    public Integer getPercent(){
            return this.percent;
    }

    public A withPercent(Integer percent){
            this.percent=percent; return (A) this;
    }

    public Boolean hasPercent(){
            return this.percent != null;
    }

    
/**
 * This method has been deprecated, please use method buildPercentage instead.
 * @return The buildable object.
 */
@Deprecated public Percent getPercentage(){
            return this.percentage!=null?this.percentage.build():null;
    }

    public Percent buildPercentage(){
            return this.percentage!=null?this.percentage.build():null;
    }

    public A withPercentage(Percent percentage){
            _visitables.get("percentage").remove(this.percentage);
            if (percentage!=null){ this.percentage= new PercentBuilder(percentage); _visitables.get("percentage").add(this.percentage);} return (A) this;
    }

    public Boolean hasPercentage(){
            return this.percentage != null;
    }

    public A withNewPercentage(Double value){
            return (A)withPercentage(new Percent(value));
    }

    public AbortFluent.PercentageNested<A> withNewPercentage(){
            return new PercentageNestedImpl();
    }

    public AbortFluent.PercentageNested<A> withNewPercentageLike(Percent item){
            return new PercentageNestedImpl(item);
    }

    public AbortFluent.PercentageNested<A> editPercentage(){
            return withNewPercentageLike(getPercentage());
    }

    public AbortFluent.PercentageNested<A> editOrNewPercentage(){
            return withNewPercentageLike(getPercentage() != null ? getPercentage(): new PercentBuilder().build());
    }

    public AbortFluent.PercentageNested<A> editOrNewPercentageLike(Percent item){
            return withNewPercentageLike(getPercentage() != null ? getPercentage(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AbortFluentImpl that = (AbortFluentImpl) o;
            if (errorType != null ? !errorType.equals(that.errorType) :that.errorType != null) return false;
            if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
            if (percentage != null ? !percentage.equals(that.percentage) :that.percentage != null) return false;
            return true;
    }


    public class HttpStatusErrorTypeNestedImpl<N> extends HttpStatusErrorTypeFluentImpl<AbortFluent.HttpStatusErrorTypeNested<N>> implements AbortFluent.HttpStatusErrorTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HttpStatusErrorTypeBuilder builder;
    
            HttpStatusErrorTypeNestedImpl(HttpStatusErrorType item){
                    this.builder = new HttpStatusErrorTypeBuilder(this, item);
            }
            HttpStatusErrorTypeNestedImpl(){
                    this.builder = new HttpStatusErrorTypeBuilder(this);
            }
    
    public N and(){
            return (N) AbortFluentImpl.this.withHttpStatusErrorType(builder.build());
    }
    public N endHttpStatusErrorType(){
            return and();
    }

}
    public class GrpcStatusErrorTypeNestedImpl<N> extends GrpcStatusErrorTypeFluentImpl<AbortFluent.GrpcStatusErrorTypeNested<N>> implements AbortFluent.GrpcStatusErrorTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GrpcStatusErrorTypeBuilder builder;
    
            GrpcStatusErrorTypeNestedImpl(GrpcStatusErrorType item){
                    this.builder = new GrpcStatusErrorTypeBuilder(this, item);
            }
            GrpcStatusErrorTypeNestedImpl(){
                    this.builder = new GrpcStatusErrorTypeBuilder(this);
            }
    
    public N and(){
            return (N) AbortFluentImpl.this.withGrpcStatusErrorType(builder.build());
    }
    public N endGrpcStatusErrorType(){
            return and();
    }

}
    public class Http2ErrorTypeNestedImpl<N> extends Http2ErrorErrorTypeFluentImpl<AbortFluent.Http2ErrorTypeNested<N>> implements AbortFluent.Http2ErrorTypeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final Http2ErrorErrorTypeBuilder builder;
    
            Http2ErrorTypeNestedImpl(Http2ErrorErrorType item){
                    this.builder = new Http2ErrorErrorTypeBuilder(this, item);
            }
            Http2ErrorTypeNestedImpl(){
                    this.builder = new Http2ErrorErrorTypeBuilder(this);
            }
    
    public N and(){
            return (N) AbortFluentImpl.this.withHttp2ErrorType(builder.build());
    }
    public N endHttp2ErrorType(){
            return and();
    }

}
    public class PercentageNestedImpl<N> extends PercentFluentImpl<AbortFluent.PercentageNested<N>> implements AbortFluent.PercentageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PercentBuilder builder;
    
            PercentageNestedImpl(Percent item){
                    this.builder = new PercentBuilder(this, item);
            }
            PercentageNestedImpl(){
                    this.builder = new PercentBuilder(this);
            }
    
    public N and(){
            return (N) AbortFluentImpl.this.withPercentage(builder.build());
    }
    public N endPercentage(){
            return and();
    }

}


}
