
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "http",
    "tcp"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ConnectionPoolSettings implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("http")
    @JsonPropertyDescription("")
    private HTTPSettings http;
    /**
     * 
     * 
     */
    @JsonProperty("tcp")
    @JsonPropertyDescription("")
    private TCPSettings tcp;
    private final static long serialVersionUID = 7125049316864636089L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConnectionPoolSettings() {
    }

    /**
     * 
     * @param tcp
     * @param http
     */
    public ConnectionPoolSettings(HTTPSettings http, TCPSettings tcp) {
        super();
        this.http = http;
        this.tcp = tcp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http")
    public HTTPSettings getHttp() {
        return http;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http")
    public void setHttp(HTTPSettings http) {
        this.http = http;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tcp")
    public TCPSettings getTcp() {
        return tcp;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tcp")
    public void setTcp(TCPSettings tcp) {
        this.tcp = tcp;
    }

}
