package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsistentHashBuilder extends ConsistentHashFluentImpl<ConsistentHashBuilder> implements VisitableBuilder<ConsistentHash,ConsistentHashBuilder>{

    ConsistentHashFluent<?> fluent;
    Boolean validationEnabled;

    public ConsistentHashBuilder(){
            this(true);
    }
    public ConsistentHashBuilder(Boolean validationEnabled){
            this(new ConsistentHash(), validationEnabled);
    }
    public ConsistentHashBuilder(ConsistentHashFluent<?> fluent){
            this(fluent, true);
    }
    public ConsistentHashBuilder(ConsistentHashFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsistentHash(), validationEnabled);
    }
    public ConsistentHashBuilder(ConsistentHashFluent<?> fluent,ConsistentHash instance){
            this(fluent, instance, true);
    }
    public ConsistentHashBuilder(ConsistentHashFluent<?> fluent,ConsistentHash instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConsistentHash(instance.getConsistentHash()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsistentHashBuilder(ConsistentHash instance){
            this(instance,true);
    }
    public ConsistentHashBuilder(ConsistentHash instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConsistentHash(instance.getConsistentHash()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsistentHash build(){
            ConsistentHash buildable = new ConsistentHash(fluent.getConsistentHash());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsistentHashBuilder that = (ConsistentHashBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
