
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "hashKey",
    "minimumRingSize"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ConsistentHashLB implements Serializable
{

    @JsonProperty("hashKey")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1alpha3.ConsistentHashLB.HashKey hashKey;
    /**
     * 
     * 
     */
    @JsonProperty("minimumRingSize")
    @JsonPropertyDescription("")
    private Integer minimumRingSize;
    private final static long serialVersionUID = 8729536466743503357L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConsistentHashLB() {
    }

    /**
     * 
     * @param hashKey
     * @param minimumRingSize
     */
    public ConsistentHashLB(me.snowdrop.istio.api.networking.v1alpha3.ConsistentHashLB.HashKey hashKey, Integer minimumRingSize) {
        super();
        this.hashKey = hashKey;
        this.minimumRingSize = minimumRingSize;
    }

    @JsonProperty("hashKey")
    public me.snowdrop.istio.api.networking.v1alpha3.ConsistentHashLB.HashKey getHashKey() {
        return hashKey;
    }

    @JsonProperty("hashKey")
    public void setHashKey(me.snowdrop.istio.api.networking.v1alpha3.ConsistentHashLB.HashKey hashKey) {
        this.hashKey = hashKey;
    }

    /**
     * 
     * 
     */
    @JsonProperty("minimumRingSize")
    public Integer getMinimumRingSize() {
        return minimumRingSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("minimumRingSize")
    public void setMinimumRingSize(Integer minimumRingSize) {
        this.minimumRingSize = minimumRingSize;
    }

    public interface HashKey extends Serializable
    {


    }

}
