package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsistentHashLBBuilder extends ConsistentHashLBFluentImpl<ConsistentHashLBBuilder> implements VisitableBuilder<ConsistentHashLB,ConsistentHashLBBuilder>{

    ConsistentHashLBFluent<?> fluent;
    Boolean validationEnabled;

    public ConsistentHashLBBuilder(){
            this(true);
    }
    public ConsistentHashLBBuilder(Boolean validationEnabled){
            this(new ConsistentHashLB(), validationEnabled);
    }
    public ConsistentHashLBBuilder(ConsistentHashLBFluent<?> fluent){
            this(fluent, true);
    }
    public ConsistentHashLBBuilder(ConsistentHashLBFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsistentHashLB(), validationEnabled);
    }
    public ConsistentHashLBBuilder(ConsistentHashLBFluent<?> fluent,ConsistentHashLB instance){
            this(fluent, instance, true);
    }
    public ConsistentHashLBBuilder(ConsistentHashLBFluent<?> fluent,ConsistentHashLB instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHashKey(instance.getHashKey()); 
            fluent.withMinimumRingSize(instance.getMinimumRingSize()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsistentHashLBBuilder(ConsistentHashLB instance){
            this(instance,true);
    }
    public ConsistentHashLBBuilder(ConsistentHashLB instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHashKey(instance.getHashKey()); 
            this.withMinimumRingSize(instance.getMinimumRingSize()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsistentHashLB build(){
            ConsistentHashLB buildable = new ConsistentHashLB(fluent.getHashKey(),fluent.getMinimumRingSize());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsistentHashLBBuilder that = (ConsistentHashLBBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
