package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class ConsistentHashLBFluentImpl<A extends ConsistentHashLBFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsistentHashLBFluent<A>{

    private VisitableBuilder<? extends ConsistentHashLB.HashKey,?> hashKey;
    private Integer minimumRingSize;

    public ConsistentHashLBFluentImpl(){
    }
    public ConsistentHashLBFluentImpl(ConsistentHashLB instance){
            this.withHashKey(instance.getHashKey()); 
            this.withMinimumRingSize(instance.getMinimumRingSize()); 
    }

    
/**
 * This method has been deprecated, please use method buildHashKey instead.
 * @return The buildable object.
 */
@Deprecated public ConsistentHashLB.HashKey getHashKey(){
            return this.hashKey!=null?this.hashKey.build():null;
    }

    public ConsistentHashLB.HashKey buildHashKey(){
            return this.hashKey!=null?this.hashKey.build():null;
    }

    public A withHashKey(ConsistentHashLB.HashKey hashKey){
            if (hashKey instanceof HttpCookieHashKey){ this.hashKey= new HttpCookieHashKeyBuilder((HttpCookieHashKey)hashKey); _visitables.get("hashKey").add(this.hashKey);}
            if (hashKey instanceof UseSourceIpHashKey){ this.hashKey= new UseSourceIpHashKeyBuilder((UseSourceIpHashKey)hashKey); _visitables.get("hashKey").add(this.hashKey);}
            if (hashKey instanceof HttpHeaderNameHashKey){ this.hashKey= new HttpHeaderNameHashKeyBuilder((HttpHeaderNameHashKey)hashKey); _visitables.get("hashKey").add(this.hashKey);}
            return (A) this;
    }

    public Boolean hasHashKey(){
            return this.hashKey != null;
    }

    public A withHttpCookieHashKey(HttpCookieHashKey httpCookieHashKey){
            _visitables.get("hashKey").remove(this.hashKey);
            if (httpCookieHashKey!=null){ this.hashKey= new HttpCookieHashKeyBuilder(httpCookieHashKey); _visitables.get("hashKey").add(this.hashKey);} return (A) this;
    }

    public ConsistentHashLBFluent.HttpCookieHashKeyNested<A> withNewHttpCookieHashKey(){
            return new HttpCookieHashKeyNestedImpl();
    }

    public ConsistentHashLBFluent.HttpCookieHashKeyNested<A> withNewHttpCookieHashKeyLike(HttpCookieHashKey item){
            return new HttpCookieHashKeyNestedImpl(item);
    }

    public A withUseSourceIpHashKey(UseSourceIpHashKey useSourceIpHashKey){
            _visitables.get("hashKey").remove(this.hashKey);
            if (useSourceIpHashKey!=null){ this.hashKey= new UseSourceIpHashKeyBuilder(useSourceIpHashKey); _visitables.get("hashKey").add(this.hashKey);} return (A) this;
    }

    public ConsistentHashLBFluent.UseSourceIpHashKeyNested<A> withNewUseSourceIpHashKey(){
            return new UseSourceIpHashKeyNestedImpl();
    }

    public ConsistentHashLBFluent.UseSourceIpHashKeyNested<A> withNewUseSourceIpHashKeyLike(UseSourceIpHashKey item){
            return new UseSourceIpHashKeyNestedImpl(item);
    }

    public A withNewUseSourceIpHashKey(Boolean useSourceIp){
            return (A)withUseSourceIpHashKey(new UseSourceIpHashKey(useSourceIp));
    }

    public A withHttpHeaderNameHashKey(HttpHeaderNameHashKey httpHeaderNameHashKey){
            _visitables.get("hashKey").remove(this.hashKey);
            if (httpHeaderNameHashKey!=null){ this.hashKey= new HttpHeaderNameHashKeyBuilder(httpHeaderNameHashKey); _visitables.get("hashKey").add(this.hashKey);} return (A) this;
    }

    public ConsistentHashLBFluent.HttpHeaderNameHashKeyNested<A> withNewHttpHeaderNameHashKey(){
            return new HttpHeaderNameHashKeyNestedImpl();
    }

    public ConsistentHashLBFluent.HttpHeaderNameHashKeyNested<A> withNewHttpHeaderNameHashKeyLike(HttpHeaderNameHashKey item){
            return new HttpHeaderNameHashKeyNestedImpl(item);
    }

    public A withNewHttpHeaderNameHashKey(String httpHeaderName){
            return (A)withHttpHeaderNameHashKey(new HttpHeaderNameHashKey(httpHeaderName));
    }

    public Integer getMinimumRingSize(){
            return this.minimumRingSize;
    }

    public A withMinimumRingSize(Integer minimumRingSize){
            this.minimumRingSize=minimumRingSize; return (A) this;
    }

    public Boolean hasMinimumRingSize(){
            return this.minimumRingSize != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ConsistentHashLBFluentImpl that = (ConsistentHashLBFluentImpl) o;
            if (hashKey != null ? !hashKey.equals(that.hashKey) :that.hashKey != null) return false;
            if (minimumRingSize != null ? !minimumRingSize.equals(that.minimumRingSize) :that.minimumRingSize != null) return false;
            return true;
    }


    public class HttpCookieHashKeyNestedImpl<N> extends HttpCookieHashKeyFluentImpl<ConsistentHashLBFluent.HttpCookieHashKeyNested<N>> implements ConsistentHashLBFluent.HttpCookieHashKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HttpCookieHashKeyBuilder builder;
    
            HttpCookieHashKeyNestedImpl(HttpCookieHashKey item){
                    this.builder = new HttpCookieHashKeyBuilder(this, item);
            }
            HttpCookieHashKeyNestedImpl(){
                    this.builder = new HttpCookieHashKeyBuilder(this);
            }
    
    public N and(){
            return (N) ConsistentHashLBFluentImpl.this.withHttpCookieHashKey(builder.build());
    }
    public N endHttpCookieHashKey(){
            return and();
    }

}
    public class UseSourceIpHashKeyNestedImpl<N> extends UseSourceIpHashKeyFluentImpl<ConsistentHashLBFluent.UseSourceIpHashKeyNested<N>> implements ConsistentHashLBFluent.UseSourceIpHashKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UseSourceIpHashKeyBuilder builder;
    
            UseSourceIpHashKeyNestedImpl(UseSourceIpHashKey item){
                    this.builder = new UseSourceIpHashKeyBuilder(this, item);
            }
            UseSourceIpHashKeyNestedImpl(){
                    this.builder = new UseSourceIpHashKeyBuilder(this);
            }
    
    public N and(){
            return (N) ConsistentHashLBFluentImpl.this.withUseSourceIpHashKey(builder.build());
    }
    public N endUseSourceIpHashKey(){
            return and();
    }

}
    public class HttpHeaderNameHashKeyNestedImpl<N> extends HttpHeaderNameHashKeyFluentImpl<ConsistentHashLBFluent.HttpHeaderNameHashKeyNested<N>> implements ConsistentHashLBFluent.HttpHeaderNameHashKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HttpHeaderNameHashKeyBuilder builder;
    
            HttpHeaderNameHashKeyNestedImpl(HttpHeaderNameHashKey item){
                    this.builder = new HttpHeaderNameHashKeyBuilder(this, item);
            }
            HttpHeaderNameHashKeyNestedImpl(){
                    this.builder = new HttpHeaderNameHashKeyBuilder(this);
            }
    
    public N and(){
            return (N) ConsistentHashLBFluentImpl.this.withHttpHeaderNameHashKey(builder.build());
    }
    public N endHttpHeaderNameHashKey(){
            return and();
    }

}


}
