package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CorsPolicyBuilder extends CorsPolicyFluentImpl<CorsPolicyBuilder> implements VisitableBuilder<CorsPolicy,CorsPolicyBuilder>{

    CorsPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public CorsPolicyBuilder(){
            this(true);
    }
    public CorsPolicyBuilder(Boolean validationEnabled){
            this(new CorsPolicy(), validationEnabled);
    }
    public CorsPolicyBuilder(CorsPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public CorsPolicyBuilder(CorsPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CorsPolicy(), validationEnabled);
    }
    public CorsPolicyBuilder(CorsPolicyFluent<?> fluent,CorsPolicy instance){
            this(fluent, instance, true);
    }
    public CorsPolicyBuilder(CorsPolicyFluent<?> fluent,CorsPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowCredentials(instance.getAllowCredentials()); 
            fluent.withAllowHeaders(instance.getAllowHeaders()); 
            fluent.withAllowMethods(instance.getAllowMethods()); 
            fluent.withAllowOrigin(instance.getAllowOrigin()); 
            fluent.withExposeHeaders(instance.getExposeHeaders()); 
            fluent.withMaxAge(instance.getMaxAge()); 
            this.validationEnabled = validationEnabled; 
    }
    public CorsPolicyBuilder(CorsPolicy instance){
            this(instance,true);
    }
    public CorsPolicyBuilder(CorsPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowCredentials(instance.getAllowCredentials()); 
            this.withAllowHeaders(instance.getAllowHeaders()); 
            this.withAllowMethods(instance.getAllowMethods()); 
            this.withAllowOrigin(instance.getAllowOrigin()); 
            this.withExposeHeaders(instance.getExposeHeaders()); 
            this.withMaxAge(instance.getMaxAge()); 
            this.validationEnabled = validationEnabled; 
    }

    public CorsPolicy build(){
            CorsPolicy buildable = new CorsPolicy(fluent.getAllowCredentials(),fluent.getAllowHeaders(),fluent.getAllowMethods(),fluent.getAllowOrigin(),fluent.getExposeHeaders(),fluent.getMaxAge());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CorsPolicyBuilder that = (CorsPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
