
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "host",
    "port",
    "subset"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Destination implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("host")
    @JsonPropertyDescription("")
    private String host;
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private PortSelector port;
    /**
     * 
     * 
     */
    @JsonProperty("subset")
    @JsonPropertyDescription("")
    private String subset;
    private final static long serialVersionUID = -1010944915627211635L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Destination() {
    }

    /**
     * 
     * @param port
     * @param host
     * @param subset
     */
    public Destination(String host, PortSelector port, String subset) {
        super();
        this.host = host;
        this.port = port;
        this.subset = subset;
    }

    /**
     * 
     * 
     */
    @JsonProperty("host")
    public String getHost() {
        return host;
    }

    /**
     * 
     * 
     */
    @JsonProperty("host")
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public PortSelector getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(PortSelector port) {
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subset")
    public String getSubset() {
        return subset;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subset")
    public void setSubset(String subset) {
        this.subset = subset;
    }

}
