
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "labels",
    "locality",
    "network",
    "ports",
    "weight"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Endpoint implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private java.lang.String address;
    /**
     * 
     * 
     */
    @JsonProperty("labels")
    @JsonPropertyDescription("")
    private Map<String, String> labels;
    /**
     * 
     * 
     */
    @JsonProperty("locality")
    @JsonPropertyDescription("")
    private java.lang.String locality;
    /**
     * 
     * 
     */
    @JsonProperty("network")
    @JsonPropertyDescription("")
    private java.lang.String network;
    /**
     * 
     * 
     */
    @JsonProperty("ports")
    @JsonPropertyDescription("")
    private Map<String, Integer> ports;
    /**
     * 
     * 
     */
    @JsonProperty("weight")
    @JsonPropertyDescription("")
    private java.lang.Integer weight;
    private final static long serialVersionUID = -3020744675724200935L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Endpoint() {
    }

    /**
     * 
     * @param address
     * @param locality
     * @param weight
     * @param ports
     * @param labels
     * @param network
     */
    public Endpoint(java.lang.String address, Map<String, String> labels, java.lang.String locality, java.lang.String network, Map<String, Integer> ports, java.lang.Integer weight) {
        super();
        this.address = address;
        this.labels = labels;
        this.locality = locality;
        this.network = network;
        this.ports = ports;
        this.weight = weight;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(java.lang.String address) {
        this.address = address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labels")
    public Map<String, String> getLabels() {
        return labels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("locality")
    public java.lang.String getLocality() {
        return locality;
    }

    /**
     * 
     * 
     */
    @JsonProperty("locality")
    public void setLocality(java.lang.String locality) {
        this.locality = locality;
    }

    /**
     * 
     * 
     */
    @JsonProperty("network")
    public java.lang.String getNetwork() {
        return network;
    }

    /**
     * 
     * 
     */
    @JsonProperty("network")
    public void setNetwork(java.lang.String network) {
        this.network = network;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public Map<String, Integer> getPorts() {
        return ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ports")
    public void setPorts(Map<String, Integer> ports) {
        this.ports = ports;
    }

    /**
     * 
     * 
     */
    @JsonProperty("weight")
    public java.lang.Integer getWeight() {
        return weight;
    }

    /**
     * 
     * 
     */
    @JsonProperty("weight")
    public void setWeight(java.lang.Integer weight) {
        this.weight = weight;
    }

}
