package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<Endpoint,EndpointBuilder>{

    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder(){
            this(true);
    }
    public EndpointBuilder(Boolean validationEnabled){
            this(new Endpoint(), validationEnabled);
    }
    public EndpointBuilder(EndpointFluent<?> fluent){
            this(fluent, true);
    }
    public EndpointBuilder(EndpointFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Endpoint(), validationEnabled);
    }
    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance){
            this(fluent, instance, true);
    }
    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withLabels(instance.getLabels()); 
            fluent.withLocality(instance.getLocality()); 
            fluent.withNetwork(instance.getNetwork()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }
    public EndpointBuilder(Endpoint instance){
            this(instance,true);
    }
    public EndpointBuilder(Endpoint instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withLabels(instance.getLabels()); 
            this.withLocality(instance.getLocality()); 
            this.withNetwork(instance.getNetwork()); 
            this.withPorts(instance.getPorts()); 
            this.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }

    public Endpoint build(){
            Endpoint buildable = new Endpoint(fluent.getAddress(),fluent.getLabels(),fluent.getLocality(),fluent.getNetwork(),fluent.getPorts(),fluent.getWeight());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EndpointBuilder that = (EndpointBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
