package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EnvoyFilterSpecBuilder extends EnvoyFilterSpecFluentImpl<EnvoyFilterSpecBuilder> implements VisitableBuilder<EnvoyFilterSpec,EnvoyFilterSpecBuilder>{

    EnvoyFilterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public EnvoyFilterSpecBuilder(){
            this(true);
    }
    public EnvoyFilterSpecBuilder(Boolean validationEnabled){
            this(new EnvoyFilterSpec(), validationEnabled);
    }
    public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent){
            this(fluent, true);
    }
    public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EnvoyFilterSpec(), validationEnabled);
    }
    public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent,EnvoyFilterSpec instance){
            this(fluent, instance, true);
    }
    public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent,EnvoyFilterSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFilters(instance.getFilters()); 
            fluent.withWorkloadLabels(instance.getWorkloadLabels()); 
            this.validationEnabled = validationEnabled; 
    }
    public EnvoyFilterSpecBuilder(EnvoyFilterSpec instance){
            this(instance,true);
    }
    public EnvoyFilterSpecBuilder(EnvoyFilterSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFilters(instance.getFilters()); 
            this.withWorkloadLabels(instance.getWorkloadLabels()); 
            this.validationEnabled = validationEnabled; 
    }

    public EnvoyFilterSpec build(){
            EnvoyFilterSpec buildable = new EnvoyFilterSpec(fluent.getFilters(),fluent.getWorkloadLabels());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EnvoyFilterSpecBuilder that = (EnvoyFilterSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
