
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.StringMatch.MatchType;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "exact"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ExactMatchType implements Serializable, MatchType
{

    /**
     * 
     * 
     */
    @JsonProperty("exact")
    @JsonPropertyDescription("")
    private String exact;
    private final static long serialVersionUID = 5803998050236778664L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExactMatchType() {
    }

    /**
     * 
     * @param exact
     */
    public ExactMatchType(String exact) {
        super();
        this.exact = exact;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exact")
    public String getExact() {
        return exact;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exact")
    public void setExact(String exact) {
        this.exact = exact;
    }

}
