
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Struct;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "filterConfig",
    "filterName",
    "filterType",
    "insertPosition",
    "listenerMatch"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Filter implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("filterConfig")
    @JsonPropertyDescription("")
    private Struct filterConfig;
    /**
     * 
     * 
     */
    @JsonProperty("filterName")
    @JsonPropertyDescription("")
    private String filterName;
    @JsonProperty("filterType")
    private FilterType filterType;
    /**
     * 
     * 
     */
    @JsonProperty("insertPosition")
    @JsonPropertyDescription("")
    private InsertPosition insertPosition;
    /**
     * 
     * 
     */
    @JsonProperty("listenerMatch")
    @JsonPropertyDescription("")
    private ListenerMatch listenerMatch;
    private final static long serialVersionUID = 426472074946975362L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Filter() {
    }

    /**
     * 
     * @param listenerMatch
     * @param filterName
     * @param filterType
     * @param insertPosition
     * @param filterConfig
     */
    public Filter(Struct filterConfig, String filterName, FilterType filterType, InsertPosition insertPosition, ListenerMatch listenerMatch) {
        super();
        this.filterConfig = filterConfig;
        this.filterName = filterName;
        this.filterType = filterType;
        this.insertPosition = insertPosition;
        this.listenerMatch = listenerMatch;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filterConfig")
    public Struct getFilterConfig() {
        return filterConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filterConfig")
    public void setFilterConfig(Struct filterConfig) {
        this.filterConfig = filterConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filterName")
    public String getFilterName() {
        return filterName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("filterName")
    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    @JsonProperty("filterType")
    public FilterType getFilterType() {
        return filterType;
    }

    @JsonProperty("filterType")
    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    /**
     * 
     * 
     */
    @JsonProperty("insertPosition")
    public InsertPosition getInsertPosition() {
        return insertPosition;
    }

    /**
     * 
     * 
     */
    @JsonProperty("insertPosition")
    public void setInsertPosition(InsertPosition insertPosition) {
        this.insertPosition = insertPosition;
    }

    /**
     * 
     * 
     */
    @JsonProperty("listenerMatch")
    public ListenerMatch getListenerMatch() {
        return listenerMatch;
    }

    /**
     * 
     * 
     */
    @JsonProperty("listenerMatch")
    public void setListenerMatch(ListenerMatch listenerMatch) {
        this.listenerMatch = listenerMatch;
    }

}
