package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FilterBuilder extends FilterFluentImpl<FilterBuilder> implements VisitableBuilder<Filter,FilterBuilder>{

    FilterFluent<?> fluent;
    Boolean validationEnabled;

    public FilterBuilder(){
            this(true);
    }
    public FilterBuilder(Boolean validationEnabled){
            this(new Filter(), validationEnabled);
    }
    public FilterBuilder(FilterFluent<?> fluent){
            this(fluent, true);
    }
    public FilterBuilder(FilterFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Filter(), validationEnabled);
    }
    public FilterBuilder(FilterFluent<?> fluent,Filter instance){
            this(fluent, instance, true);
    }
    public FilterBuilder(FilterFluent<?> fluent,Filter instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFilterConfig(instance.getFilterConfig()); 
            fluent.withFilterName(instance.getFilterName()); 
            fluent.withFilterType(instance.getFilterType()); 
            fluent.withInsertPosition(instance.getInsertPosition()); 
            fluent.withListenerMatch(instance.getListenerMatch()); 
            this.validationEnabled = validationEnabled; 
    }
    public FilterBuilder(Filter instance){
            this(instance,true);
    }
    public FilterBuilder(Filter instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFilterConfig(instance.getFilterConfig()); 
            this.withFilterName(instance.getFilterName()); 
            this.withFilterType(instance.getFilterType()); 
            this.withInsertPosition(instance.getInsertPosition()); 
            this.withListenerMatch(instance.getListenerMatch()); 
            this.validationEnabled = validationEnabled; 
    }

    public Filter build(){
            Filter buildable = new Filter(fluent.getFilterConfig(),fluent.getFilterName(),fluent.getFilterType(),fluent.getInsertPosition(),fluent.getListenerMatch());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FilterBuilder that = (FilterBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
