package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import me.snowdrop.istio.api.Struct;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import me.snowdrop.istio.api.StructFluentImpl;
import java.lang.StringBuffer;
import me.snowdrop.istio.api.StructBuilder;
import java.lang.Object;

public class FilterFluentImpl<A extends FilterFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FilterFluent<A>{

    private StructBuilder filterConfig;
    private String filterName;
    private FilterType filterType;
    private InsertPositionBuilder insertPosition;
    private ListenerMatchBuilder listenerMatch;

    public FilterFluentImpl(){
    }
    public FilterFluentImpl(Filter instance){
            this.withFilterConfig(instance.getFilterConfig()); 
            this.withFilterName(instance.getFilterName()); 
            this.withFilterType(instance.getFilterType()); 
            this.withInsertPosition(instance.getInsertPosition()); 
            this.withListenerMatch(instance.getListenerMatch()); 
    }

    
/**
 * This method has been deprecated, please use method buildFilterConfig instead.
 * @return The buildable object.
 */
@Deprecated public Struct getFilterConfig(){
            return this.filterConfig!=null?this.filterConfig.build():null;
    }

    public Struct buildFilterConfig(){
            return this.filterConfig!=null?this.filterConfig.build():null;
    }

    public A withFilterConfig(Struct filterConfig){
            _visitables.get("filterConfig").remove(this.filterConfig);
            if (filterConfig!=null){ this.filterConfig= new StructBuilder(filterConfig); _visitables.get("filterConfig").add(this.filterConfig);} return (A) this;
    }

    public Boolean hasFilterConfig(){
            return this.filterConfig != null;
    }

    public FilterFluent.FilterConfigNested<A> withNewFilterConfig(){
            return new FilterConfigNestedImpl();
    }

    public FilterFluent.FilterConfigNested<A> withNewFilterConfigLike(Struct item){
            return new FilterConfigNestedImpl(item);
    }

    public FilterFluent.FilterConfigNested<A> editFilterConfig(){
            return withNewFilterConfigLike(getFilterConfig());
    }

    public FilterFluent.FilterConfigNested<A> editOrNewFilterConfig(){
            return withNewFilterConfigLike(getFilterConfig() != null ? getFilterConfig(): new StructBuilder().build());
    }

    public FilterFluent.FilterConfigNested<A> editOrNewFilterConfigLike(Struct item){
            return withNewFilterConfigLike(getFilterConfig() != null ? getFilterConfig(): item);
    }

    public String getFilterName(){
            return this.filterName;
    }

    public A withFilterName(String filterName){
            this.filterName=filterName; return (A) this;
    }

    public Boolean hasFilterName(){
            return this.filterName != null;
    }

    public A withNewFilterName(String arg1){
            return (A)withFilterName(new String(arg1));
    }

    public A withNewFilterName(StringBuilder arg1){
            return (A)withFilterName(new String(arg1));
    }

    public A withNewFilterName(StringBuffer arg1){
            return (A)withFilterName(new String(arg1));
    }

    public FilterType getFilterType(){
            return this.filterType;
    }

    public A withFilterType(FilterType filterType){
            this.filterType=filterType; return (A) this;
    }

    public Boolean hasFilterType(){
            return this.filterType != null;
    }

    
/**
 * This method has been deprecated, please use method buildInsertPosition instead.
 * @return The buildable object.
 */
@Deprecated public InsertPosition getInsertPosition(){
            return this.insertPosition!=null?this.insertPosition.build():null;
    }

    public InsertPosition buildInsertPosition(){
            return this.insertPosition!=null?this.insertPosition.build():null;
    }

    public A withInsertPosition(InsertPosition insertPosition){
            _visitables.get("insertPosition").remove(this.insertPosition);
            if (insertPosition!=null){ this.insertPosition= new InsertPositionBuilder(insertPosition); _visitables.get("insertPosition").add(this.insertPosition);} return (A) this;
    }

    public Boolean hasInsertPosition(){
            return this.insertPosition != null;
    }

    public FilterFluent.InsertPositionNested<A> withNewInsertPosition(){
            return new InsertPositionNestedImpl();
    }

    public FilterFluent.InsertPositionNested<A> withNewInsertPositionLike(InsertPosition item){
            return new InsertPositionNestedImpl(item);
    }

    public FilterFluent.InsertPositionNested<A> editInsertPosition(){
            return withNewInsertPositionLike(getInsertPosition());
    }

    public FilterFluent.InsertPositionNested<A> editOrNewInsertPosition(){
            return withNewInsertPositionLike(getInsertPosition() != null ? getInsertPosition(): new InsertPositionBuilder().build());
    }

    public FilterFluent.InsertPositionNested<A> editOrNewInsertPositionLike(InsertPosition item){
            return withNewInsertPositionLike(getInsertPosition() != null ? getInsertPosition(): item);
    }

    
/**
 * This method has been deprecated, please use method buildListenerMatch instead.
 * @return The buildable object.
 */
@Deprecated public ListenerMatch getListenerMatch(){
            return this.listenerMatch!=null?this.listenerMatch.build():null;
    }

    public ListenerMatch buildListenerMatch(){
            return this.listenerMatch!=null?this.listenerMatch.build():null;
    }

    public A withListenerMatch(ListenerMatch listenerMatch){
            _visitables.get("listenerMatch").remove(this.listenerMatch);
            if (listenerMatch!=null){ this.listenerMatch= new ListenerMatchBuilder(listenerMatch); _visitables.get("listenerMatch").add(this.listenerMatch);} return (A) this;
    }

    public Boolean hasListenerMatch(){
            return this.listenerMatch != null;
    }

    public FilterFluent.ListenerMatchNested<A> withNewListenerMatch(){
            return new ListenerMatchNestedImpl();
    }

    public FilterFluent.ListenerMatchNested<A> withNewListenerMatchLike(ListenerMatch item){
            return new ListenerMatchNestedImpl(item);
    }

    public FilterFluent.ListenerMatchNested<A> editListenerMatch(){
            return withNewListenerMatchLike(getListenerMatch());
    }

    public FilterFluent.ListenerMatchNested<A> editOrNewListenerMatch(){
            return withNewListenerMatchLike(getListenerMatch() != null ? getListenerMatch(): new ListenerMatchBuilder().build());
    }

    public FilterFluent.ListenerMatchNested<A> editOrNewListenerMatchLike(ListenerMatch item){
            return withNewListenerMatchLike(getListenerMatch() != null ? getListenerMatch(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            FilterFluentImpl that = (FilterFluentImpl) o;
            if (filterConfig != null ? !filterConfig.equals(that.filterConfig) :that.filterConfig != null) return false;
            if (filterName != null ? !filterName.equals(that.filterName) :that.filterName != null) return false;
            if (filterType != null ? !filterType.equals(that.filterType) :that.filterType != null) return false;
            if (insertPosition != null ? !insertPosition.equals(that.insertPosition) :that.insertPosition != null) return false;
            if (listenerMatch != null ? !listenerMatch.equals(that.listenerMatch) :that.listenerMatch != null) return false;
            return true;
    }


    public class FilterConfigNestedImpl<N> extends StructFluentImpl<FilterFluent.FilterConfigNested<N>> implements FilterFluent.FilterConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StructBuilder builder;
    
            FilterConfigNestedImpl(Struct item){
                    this.builder = new StructBuilder(this, item);
            }
            FilterConfigNestedImpl(){
                    this.builder = new StructBuilder(this);
            }
    
    public N and(){
            return (N) FilterFluentImpl.this.withFilterConfig(builder.build());
    }
    public N endFilterConfig(){
            return and();
    }

}
    public class InsertPositionNestedImpl<N> extends InsertPositionFluentImpl<FilterFluent.InsertPositionNested<N>> implements FilterFluent.InsertPositionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InsertPositionBuilder builder;
    
            InsertPositionNestedImpl(InsertPosition item){
                    this.builder = new InsertPositionBuilder(this, item);
            }
            InsertPositionNestedImpl(){
                    this.builder = new InsertPositionBuilder(this);
            }
    
    public N and(){
            return (N) FilterFluentImpl.this.withInsertPosition(builder.build());
    }
    public N endInsertPosition(){
            return and();
    }

}
    public class ListenerMatchNestedImpl<N> extends ListenerMatchFluentImpl<FilterFluent.ListenerMatchNested<N>> implements FilterFluent.ListenerMatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ListenerMatchBuilder builder;
    
            ListenerMatchNestedImpl(ListenerMatch item){
                    this.builder = new ListenerMatchBuilder(this, item);
            }
            ListenerMatchNestedImpl(){
                    this.builder = new ListenerMatchBuilder(this);
            }
    
    public N and(){
            return (N) FilterFluentImpl.this.withListenerMatch(builder.build());
    }
    public N endListenerMatch(){
            return and();
    }

}


}
