
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "selector",
    "servers"
})
@IstioKind(name = "Gateway", plural = "gateways")
@IstioApiVersion("networking.istio.io/v1alpha3")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class GatewaySpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("selector")
    @JsonPropertyDescription("")
    private Map<String, String> selector;
    /**
     * 
     * 
     */
    @JsonProperty("servers")
    @JsonPropertyDescription("")
    private List<Server> servers = new ArrayList<Server>();
    private final static long serialVersionUID = 6911493872570423714L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GatewaySpec() {
    }

    /**
     * 
     * @param servers
     * @param selector
     */
    public GatewaySpec(Map<String, String> selector, List<Server> servers) {
        super();
        this.selector = selector;
        this.servers = servers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("selector")
    public Map<String, String> getSelector() {
        return selector;
    }

    /**
     * 
     * 
     */
    @JsonProperty("selector")
    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    /**
     * 
     * 
     */
    @JsonProperty("servers")
    public List<Server> getServers() {
        return servers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("servers")
    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

}
