package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface GatewaySpecFluent<A extends GatewaySpecFluent<A>> extends Fluent<A>{


    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public Boolean hasSelector();
    public A addToServers(int index,Server item);
    public A setToServers(int index,Server item);
    public A addToServers(Server... items);
    public A addAllToServers(Collection<Server> items);
    public A removeFromServers(Server... items);
    public A removeAllFromServers(Collection<Server> items);
    public A removeMatchingFromServers(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServers instead.
 * @return The buildable object.
 */
@Deprecated public List<Server> getServers();
    public List<Server> buildServers();
    public Server buildServer(int index);
    public Server buildFirstServer();
    public Server buildLastServer();
    public Server buildMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);
    public Boolean hasMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);
    public A withServers(List<Server> servers);
    public A withServers(Server... servers);
    public Boolean hasServers();
    public GatewaySpecFluent.ServersNested<A> addNewServer();
    public GatewaySpecFluent.ServersNested<A> addNewServerLike(Server item);
    public GatewaySpecFluent.ServersNested<A> setNewServerLike(int index,Server item);
    public GatewaySpecFluent.ServersNested<A> editServer(int index);
    public GatewaySpecFluent.ServersNested<A> editFirstServer();
    public GatewaySpecFluent.ServersNested<A> editLastServer();
    public GatewaySpecFluent.ServersNested<A> editMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);

    public interface ServersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServerFluent<GatewaySpecFluent.ServersNested<N>>{

        
    public N and();    public N endServer();
}


}
