
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "abort",
    "delay"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPFaultInjection implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("abort")
    @JsonPropertyDescription("")
    private Abort abort;
    /**
     * 
     * 
     */
    @JsonProperty("delay")
    @JsonPropertyDescription("")
    private Delay delay;
    private final static long serialVersionUID = 2381339511078677338L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPFaultInjection() {
    }

    /**
     * 
     * @param delay
     * @param abort
     */
    public HTTPFaultInjection(Abort abort, Delay delay) {
        super();
        this.abort = abort;
        this.delay = delay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("abort")
    public Abort getAbort() {
        return abort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("abort")
    public void setAbort(Abort abort) {
        this.abort = abort;
    }

    /**
     * 
     * 
     */
    @JsonProperty("delay")
    public Delay getDelay() {
        return delay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("delay")
    public void setDelay(Delay delay) {
        this.delay = delay;
    }

}
