
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "authority",
    "gateways",
    "headers",
    "method",
    "port",
    "scheme",
    "sourceLabels",
    "uri"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPMatchRequest implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("authority")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch authority;
    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    @JsonPropertyDescription("")
    private List<java.lang.String> gateways = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("headers")
    @JsonPropertyDescription("")
    private Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> headers;
    /**
     * 
     * 
     */
    @JsonProperty("method")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch method;
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Integer port;
    /**
     * 
     * 
     */
    @JsonProperty("scheme")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch scheme;
    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    @JsonPropertyDescription("")
    private Map<String, String> sourceLabels;
    /**
     * 
     * 
     */
    @JsonProperty("uri")
    @JsonPropertyDescription("")
    private me.snowdrop.istio.api.networking.v1alpha3.StringMatch uri;
    private final static long serialVersionUID = 6245616928479199180L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPMatchRequest() {
    }

    /**
     * 
     * @param gateways
     * @param headers
     * @param method
     * @param scheme
     * @param port
     * @param sourceLabels
     * @param authority
     * @param uri
     */
    public HTTPMatchRequest(me.snowdrop.istio.api.networking.v1alpha3.StringMatch authority, List<java.lang.String> gateways, Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> headers, me.snowdrop.istio.api.networking.v1alpha3.StringMatch method, Integer port, me.snowdrop.istio.api.networking.v1alpha3.StringMatch scheme, Map<String, String> sourceLabels, me.snowdrop.istio.api.networking.v1alpha3.StringMatch uri) {
        super();
        this.authority = authority;
        this.gateways = gateways;
        this.headers = headers;
        this.method = method;
        this.port = port;
        this.scheme = scheme;
        this.sourceLabels = sourceLabels;
        this.uri = uri;
    }

    /**
     * 
     * 
     */
    @JsonProperty("authority")
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getAuthority() {
        return authority;
    }

    /**
     * 
     * 
     */
    @JsonProperty("authority")
    public void setAuthority(me.snowdrop.istio.api.networking.v1alpha3.StringMatch authority) {
        this.authority = authority;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public List<java.lang.String> getGateways() {
        return gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public void setGateways(List<java.lang.String> gateways) {
        this.gateways = gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("headers")
    public Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> getHeaders() {
        return headers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("headers")
    public void setHeaders(Map<String, me.snowdrop.istio.api.networking.v1alpha3.StringMatch> headers) {
        this.headers = headers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("method")
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getMethod() {
        return method;
    }

    /**
     * 
     * 
     */
    @JsonProperty("method")
    public void setMethod(me.snowdrop.istio.api.networking.v1alpha3.StringMatch method) {
        this.method = method;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("scheme")
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getScheme() {
        return scheme;
    }

    /**
     * 
     * 
     */
    @JsonProperty("scheme")
    public void setScheme(me.snowdrop.istio.api.networking.v1alpha3.StringMatch scheme) {
        this.scheme = scheme;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    public Map<String, String> getSourceLabels() {
        return sourceLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("uri")
    public me.snowdrop.istio.api.networking.v1alpha3.StringMatch getUri() {
        return uri;
    }

    /**
     * 
     * 
     */
    @JsonProperty("uri")
    public void setUri(me.snowdrop.istio.api.networking.v1alpha3.StringMatch uri) {
        this.uri = uri;
    }

}
