package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPMatchRequestBuilder extends HTTPMatchRequestFluentImpl<HTTPMatchRequestBuilder> implements VisitableBuilder<HTTPMatchRequest,HTTPMatchRequestBuilder>{

    HTTPMatchRequestFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPMatchRequestBuilder(){
            this(true);
    }
    public HTTPMatchRequestBuilder(Boolean validationEnabled){
            this(new HTTPMatchRequest(), validationEnabled);
    }
    public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPMatchRequest(), validationEnabled);
    }
    public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,HTTPMatchRequest instance){
            this(fluent, instance, true);
    }
    public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,HTTPMatchRequest instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthority(instance.getAuthority()); 
            fluent.withGateways(instance.getGateways()); 
            fluent.withHeaders(instance.getHeaders()); 
            fluent.withMethod(instance.getMethod()); 
            fluent.withPort(instance.getPort()); 
            fluent.withScheme(instance.getScheme()); 
            fluent.withSourceLabels(instance.getSourceLabels()); 
            fluent.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPMatchRequestBuilder(HTTPMatchRequest instance){
            this(instance,true);
    }
    public HTTPMatchRequestBuilder(HTTPMatchRequest instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthority(instance.getAuthority()); 
            this.withGateways(instance.getGateways()); 
            this.withHeaders(instance.getHeaders()); 
            this.withMethod(instance.getMethod()); 
            this.withPort(instance.getPort()); 
            this.withScheme(instance.getScheme()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }

    public HTTPMatchRequest build(){
            HTTPMatchRequest buildable = new HTTPMatchRequest(fluent.getAuthority(),fluent.getGateways(),fluent.getHeaders(),fluent.getMethod(),fluent.getPort(),fluent.getScheme(),fluent.getSourceLabels(),fluent.getUri());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPMatchRequestBuilder that = (HTTPMatchRequestBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
