package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPRedirectBuilder extends HTTPRedirectFluentImpl<HTTPRedirectBuilder> implements VisitableBuilder<HTTPRedirect,HTTPRedirectBuilder>{

    HTTPRedirectFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPRedirectBuilder(){
            this(true);
    }
    public HTTPRedirectBuilder(Boolean validationEnabled){
            this(new HTTPRedirect(), validationEnabled);
    }
    public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPRedirect(), validationEnabled);
    }
    public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent,HTTPRedirect instance){
            this(fluent, instance, true);
    }
    public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent,HTTPRedirect instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthority(instance.getAuthority()); 
            fluent.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRedirectBuilder(HTTPRedirect instance){
            this(instance,true);
    }
    public HTTPRedirectBuilder(HTTPRedirect instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthority(instance.getAuthority()); 
            this.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }

    public HTTPRedirect build(){
            HTTPRedirect buildable = new HTTPRedirect(fluent.getAuthority(),fluent.getUri());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPRedirectBuilder that = (HTTPRedirectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
