
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attempts",
    "perTryTimeout",
    "retryOn"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRetry implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("attempts")
    @JsonPropertyDescription("")
    private Integer attempts;
    /**
     * 
     * 
     */
    @JsonProperty("perTryTimeout")
    @JsonPropertyDescription("")
    private Duration perTryTimeout;
    /**
     * 
     * 
     */
    @JsonProperty("retryOn")
    @JsonPropertyDescription("")
    private String retryOn;
    private final static long serialVersionUID = 2010133729027733620L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRetry() {
    }

    /**
     * 
     * @param perTryTimeout
     * @param attempts
     * @param retryOn
     */
    public HTTPRetry(Integer attempts, Duration perTryTimeout, String retryOn) {
        super();
        this.attempts = attempts;
        this.perTryTimeout = perTryTimeout;
        this.retryOn = retryOn;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attempts")
    public Integer getAttempts() {
        return attempts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("attempts")
    public void setAttempts(Integer attempts) {
        this.attempts = attempts;
    }

    /**
     * 
     * 
     */
    @JsonProperty("perTryTimeout")
    public Duration getPerTryTimeout() {
        return perTryTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("perTryTimeout")
    public void setPerTryTimeout(Duration perTryTimeout) {
        this.perTryTimeout = perTryTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("retryOn")
    public String getRetryOn() {
        return retryOn;
    }

    /**
     * 
     * 
     */
    @JsonProperty("retryOn")
    public void setRetryOn(String retryOn) {
        this.retryOn = retryOn;
    }

}
