
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "authority",
    "uri"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRewrite implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("authority")
    @JsonPropertyDescription("")
    private String authority;
    /**
     * 
     * 
     */
    @JsonProperty("uri")
    @JsonPropertyDescription("")
    private String uri;
    private final static long serialVersionUID = 1338565728557150506L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRewrite() {
    }

    /**
     * 
     * @param authority
     * @param uri
     */
    public HTTPRewrite(String authority, String uri) {
        super();
        this.authority = authority;
        this.uri = uri;
    }

    /**
     * 
     * 
     */
    @JsonProperty("authority")
    public String getAuthority() {
        return authority;
    }

    /**
     * 
     * 
     */
    @JsonProperty("authority")
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    /**
     * 
     * 
     */
    @JsonProperty("uri")
    public String getUri() {
        return uri;
    }

    /**
     * 
     * 
     */
    @JsonProperty("uri")
    public void setUri(String uri) {
        this.uri = uri;
    }

}
