
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "appendHeaders",
    "appendRequestHeaders",
    "appendResponseHeaders",
    "corsPolicy",
    "fault",
    "headers",
    "match",
    "mirror",
    "redirect",
    "removeRequestHeaders",
    "removeResponseHeaders",
    "retries",
    "rewrite",
    "route",
    "timeout",
    "websocketUpgrade"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRoute implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("appendHeaders")
    @JsonPropertyDescription("")
    private Map<String, String> appendHeaders;
    /**
     * 
     * 
     */
    @JsonProperty("appendRequestHeaders")
    @JsonPropertyDescription("")
    private Map<String, String> appendRequestHeaders;
    /**
     * 
     * 
     */
    @JsonProperty("appendResponseHeaders")
    @JsonPropertyDescription("")
    private Map<String, String> appendResponseHeaders;
    /**
     * 
     * 
     */
    @JsonProperty("corsPolicy")
    @JsonPropertyDescription("")
    private CorsPolicy corsPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("fault")
    @JsonPropertyDescription("")
    private HTTPFaultInjection fault;
    /**
     * 
     * 
     */
    @JsonProperty("headers")
    @JsonPropertyDescription("")
    private Headers headers;
    /**
     * 
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    private List<HTTPMatchRequest> match = new ArrayList<HTTPMatchRequest>();
    /**
     * 
     * 
     */
    @JsonProperty("mirror")
    @JsonPropertyDescription("")
    private Destination mirror;
    /**
     * 
     * 
     */
    @JsonProperty("redirect")
    @JsonPropertyDescription("")
    private HTTPRedirect redirect;
    /**
     * 
     * 
     */
    @JsonProperty("removeRequestHeaders")
    @JsonPropertyDescription("")
    private List<java.lang.String> removeRequestHeaders = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    @JsonPropertyDescription("")
    private List<java.lang.String> removeResponseHeaders = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("retries")
    @JsonPropertyDescription("")
    private HTTPRetry retries;
    /**
     * 
     * 
     */
    @JsonProperty("rewrite")
    @JsonPropertyDescription("")
    private HTTPRewrite rewrite;
    /**
     * 
     * 
     */
    @JsonProperty("route")
    @JsonPropertyDescription("")
    private List<HTTPRouteDestination> route = new ArrayList<HTTPRouteDestination>();
    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    @JsonPropertyDescription("")
    private Duration timeout;
    /**
     * 
     * 
     */
    @JsonProperty("websocketUpgrade")
    @JsonPropertyDescription("")
    private Boolean websocketUpgrade;
    private final static long serialVersionUID = -8692304657706180621L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRoute() {
    }

    /**
     * 
     * @param redirect
     * @param headers
     * @param mirror
     * @param removeResponseHeaders
     * @param corsPolicy
     * @param match
     * @param fault
     * @param appendHeaders
     * @param rewrite
     * @param timeout
     * @param websocketUpgrade
     * @param retries
     * @param appendRequestHeaders
     * @param route
     * @param appendResponseHeaders
     * @param removeRequestHeaders
     */
    public HTTPRoute(Map<String, String> appendHeaders, Map<String, String> appendRequestHeaders, Map<String, String> appendResponseHeaders, CorsPolicy corsPolicy, HTTPFaultInjection fault, Headers headers, List<HTTPMatchRequest> match, Destination mirror, HTTPRedirect redirect, List<java.lang.String> removeRequestHeaders, List<java.lang.String> removeResponseHeaders, HTTPRetry retries, HTTPRewrite rewrite, List<HTTPRouteDestination> route, Duration timeout, Boolean websocketUpgrade) {
        super();
        this.appendHeaders = appendHeaders;
        this.appendRequestHeaders = appendRequestHeaders;
        this.appendResponseHeaders = appendResponseHeaders;
        this.corsPolicy = corsPolicy;
        this.fault = fault;
        this.headers = headers;
        this.match = match;
        this.mirror = mirror;
        this.redirect = redirect;
        this.removeRequestHeaders = removeRequestHeaders;
        this.removeResponseHeaders = removeResponseHeaders;
        this.retries = retries;
        this.rewrite = rewrite;
        this.route = route;
        this.timeout = timeout;
        this.websocketUpgrade = websocketUpgrade;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendHeaders")
    public Map<String, String> getAppendHeaders() {
        return appendHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendHeaders")
    public void setAppendHeaders(Map<String, String> appendHeaders) {
        this.appendHeaders = appendHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendRequestHeaders")
    public Map<String, String> getAppendRequestHeaders() {
        return appendRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendRequestHeaders")
    public void setAppendRequestHeaders(Map<String, String> appendRequestHeaders) {
        this.appendRequestHeaders = appendRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendResponseHeaders")
    public Map<String, String> getAppendResponseHeaders() {
        return appendResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendResponseHeaders")
    public void setAppendResponseHeaders(Map<String, String> appendResponseHeaders) {
        this.appendResponseHeaders = appendResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("corsPolicy")
    public CorsPolicy getCorsPolicy() {
        return corsPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("corsPolicy")
    public void setCorsPolicy(CorsPolicy corsPolicy) {
        this.corsPolicy = corsPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fault")
    public HTTPFaultInjection getFault() {
        return fault;
    }

    /**
     * 
     * 
     */
    @JsonProperty("fault")
    public void setFault(HTTPFaultInjection fault) {
        this.fault = fault;
    }

    /**
     * 
     * 
     */
    @JsonProperty("headers")
    public Headers getHeaders() {
        return headers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("headers")
    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public List<HTTPMatchRequest> getMatch() {
        return match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public void setMatch(List<HTTPMatchRequest> match) {
        this.match = match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mirror")
    public Destination getMirror() {
        return mirror;
    }

    /**
     * 
     * 
     */
    @JsonProperty("mirror")
    public void setMirror(Destination mirror) {
        this.mirror = mirror;
    }

    /**
     * 
     * 
     */
    @JsonProperty("redirect")
    public HTTPRedirect getRedirect() {
        return redirect;
    }

    /**
     * 
     * 
     */
    @JsonProperty("redirect")
    public void setRedirect(HTTPRedirect redirect) {
        this.redirect = redirect;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeRequestHeaders")
    public List<java.lang.String> getRemoveRequestHeaders() {
        return removeRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeRequestHeaders")
    public void setRemoveRequestHeaders(List<java.lang.String> removeRequestHeaders) {
        this.removeRequestHeaders = removeRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    public List<java.lang.String> getRemoveResponseHeaders() {
        return removeResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    public void setRemoveResponseHeaders(List<java.lang.String> removeResponseHeaders) {
        this.removeResponseHeaders = removeResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("retries")
    public HTTPRetry getRetries() {
        return retries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("retries")
    public void setRetries(HTTPRetry retries) {
        this.retries = retries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewrite")
    public HTTPRewrite getRewrite() {
        return rewrite;
    }

    /**
     * 
     * 
     */
    @JsonProperty("rewrite")
    public void setRewrite(HTTPRewrite rewrite) {
        this.rewrite = rewrite;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public List<HTTPRouteDestination> getRoute() {
        return route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public void setRoute(List<HTTPRouteDestination> route) {
        this.route = route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    public Duration getTimeout() {
        return timeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("timeout")
    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("websocketUpgrade")
    public Boolean getWebsocketUpgrade() {
        return websocketUpgrade;
    }

    /**
     * 
     * 
     */
    @JsonProperty("websocketUpgrade")
    public void setWebsocketUpgrade(Boolean websocketUpgrade) {
        this.websocketUpgrade = websocketUpgrade;
    }

}
