
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "appendRequestHeaders",
    "appendResponseHeaders",
    "destination",
    "headers",
    "removeRequestHeaders",
    "removeResponseHeaders",
    "weight"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPRouteDestination implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("appendRequestHeaders")
    @JsonPropertyDescription("")
    private Map<String, String> appendRequestHeaders;
    /**
     * 
     * 
     */
    @JsonProperty("appendResponseHeaders")
    @JsonPropertyDescription("")
    private Map<String, String> appendResponseHeaders;
    /**
     * 
     * 
     */
    @JsonProperty("destination")
    @JsonPropertyDescription("")
    private Destination destination;
    /**
     * 
     * 
     */
    @JsonProperty("headers")
    @JsonPropertyDescription("")
    private Headers headers;
    /**
     * 
     * 
     */
    @JsonProperty("removeRequestHeaders")
    @JsonPropertyDescription("")
    private List<java.lang.String> removeRequestHeaders = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    @JsonPropertyDescription("")
    private List<java.lang.String> removeResponseHeaders = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("weight")
    @JsonPropertyDescription("")
    private Integer weight;
    private final static long serialVersionUID = 858478076978148096L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPRouteDestination() {
    }

    /**
     * 
     * @param headers
     * @param appendRequestHeaders
     * @param removeResponseHeaders
     * @param appendResponseHeaders
     * @param destination
     * @param weight
     * @param removeRequestHeaders
     */
    public HTTPRouteDestination(Map<String, String> appendRequestHeaders, Map<String, String> appendResponseHeaders, Destination destination, Headers headers, List<java.lang.String> removeRequestHeaders, List<java.lang.String> removeResponseHeaders, Integer weight) {
        super();
        this.appendRequestHeaders = appendRequestHeaders;
        this.appendResponseHeaders = appendResponseHeaders;
        this.destination = destination;
        this.headers = headers;
        this.removeRequestHeaders = removeRequestHeaders;
        this.removeResponseHeaders = removeResponseHeaders;
        this.weight = weight;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendRequestHeaders")
    public Map<String, String> getAppendRequestHeaders() {
        return appendRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendRequestHeaders")
    public void setAppendRequestHeaders(Map<String, String> appendRequestHeaders) {
        this.appendRequestHeaders = appendRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendResponseHeaders")
    public Map<String, String> getAppendResponseHeaders() {
        return appendResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("appendResponseHeaders")
    public void setAppendResponseHeaders(Map<String, String> appendResponseHeaders) {
        this.appendResponseHeaders = appendResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destination")
    public Destination getDestination() {
        return destination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destination")
    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    /**
     * 
     * 
     */
    @JsonProperty("headers")
    public Headers getHeaders() {
        return headers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("headers")
    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeRequestHeaders")
    public List<java.lang.String> getRemoveRequestHeaders() {
        return removeRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeRequestHeaders")
    public void setRemoveRequestHeaders(List<java.lang.String> removeRequestHeaders) {
        this.removeRequestHeaders = removeRequestHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    public List<java.lang.String> getRemoveResponseHeaders() {
        return removeResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("removeResponseHeaders")
    public void setRemoveResponseHeaders(List<java.lang.String> removeResponseHeaders) {
        this.removeResponseHeaders = removeResponseHeaders;
    }

    /**
     * 
     * 
     */
    @JsonProperty("weight")
    public Integer getWeight() {
        return weight;
    }

    /**
     * 
     * 
     */
    @JsonProperty("weight")
    public void setWeight(Integer weight) {
        this.weight = weight;
    }

}
