package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPRouteDestinationBuilder extends HTTPRouteDestinationFluentImpl<HTTPRouteDestinationBuilder> implements VisitableBuilder<HTTPRouteDestination,HTTPRouteDestinationBuilder>{

    HTTPRouteDestinationFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPRouteDestinationBuilder(){
            this(true);
    }
    public HTTPRouteDestinationBuilder(Boolean validationEnabled){
            this(new HTTPRouteDestination(), validationEnabled);
    }
    public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPRouteDestination(), validationEnabled);
    }
    public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent,HTTPRouteDestination instance){
            this(fluent, instance, true);
    }
    public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent,HTTPRouteDestination instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppendRequestHeaders(instance.getAppendRequestHeaders()); 
            fluent.withAppendResponseHeaders(instance.getAppendResponseHeaders()); 
            fluent.withDestination(instance.getDestination()); 
            fluent.withHeaders(instance.getHeaders()); 
            fluent.withRemoveRequestHeaders(instance.getRemoveRequestHeaders()); 
            fluent.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            fluent.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRouteDestinationBuilder(HTTPRouteDestination instance){
            this(instance,true);
    }
    public HTTPRouteDestinationBuilder(HTTPRouteDestination instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppendRequestHeaders(instance.getAppendRequestHeaders()); 
            this.withAppendResponseHeaders(instance.getAppendResponseHeaders()); 
            this.withDestination(instance.getDestination()); 
            this.withHeaders(instance.getHeaders()); 
            this.withRemoveRequestHeaders(instance.getRemoveRequestHeaders()); 
            this.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            this.withWeight(instance.getWeight()); 
            this.validationEnabled = validationEnabled; 
    }

    public HTTPRouteDestination build(){
            HTTPRouteDestination buildable = new HTTPRouteDestination(fluent.getAppendRequestHeaders(),fluent.getAppendResponseHeaders(),fluent.getDestination(),fluent.getHeaders(),fluent.getRemoveRequestHeaders(),fluent.getRemoveResponseHeaders(),fluent.getWeight());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPRouteDestinationBuilder that = (HTTPRouteDestinationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
