package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.util.Map;

public interface HTTPRouteDestinationFluent<A extends HTTPRouteDestinationFluent<A>> extends Fluent<A>{


    public A addToAppendRequestHeaders(String key,String value);
    public A addToAppendRequestHeaders(Map<String,String> map);
    public A removeFromAppendRequestHeaders(String key);
    public A removeFromAppendRequestHeaders(Map<String,String> map);
    public Map<String,String> getAppendRequestHeaders();
    public A withAppendRequestHeaders(Map<String,String> appendRequestHeaders);
    public Boolean hasAppendRequestHeaders();
    public A addToAppendResponseHeaders(String key,String value);
    public A addToAppendResponseHeaders(Map<String,String> map);
    public A removeFromAppendResponseHeaders(String key);
    public A removeFromAppendResponseHeaders(Map<String,String> map);
    public Map<String,String> getAppendResponseHeaders();
    public A withAppendResponseHeaders(Map<String,String> appendResponseHeaders);
    public Boolean hasAppendResponseHeaders();
    
/**
 * This method has been deprecated, please use method buildDestination instead.
 * @return The buildable object.
 */
@Deprecated public Destination getDestination();
    public Destination buildDestination();
    public A withDestination(Destination destination);
    public Boolean hasDestination();
    public HTTPRouteDestinationFluent.DestinationNested<A> withNewDestination();
    public HTTPRouteDestinationFluent.DestinationNested<A> withNewDestinationLike(Destination item);
    public HTTPRouteDestinationFluent.DestinationNested<A> editDestination();
    public HTTPRouteDestinationFluent.DestinationNested<A> editOrNewDestination();
    public HTTPRouteDestinationFluent.DestinationNested<A> editOrNewDestinationLike(Destination item);
    
/**
 * This method has been deprecated, please use method buildHeaders instead.
 * @return The buildable object.
 */
@Deprecated public Headers getHeaders();
    public Headers buildHeaders();
    public A withHeaders(Headers headers);
    public Boolean hasHeaders();
    public HTTPRouteDestinationFluent.HeadersNested<A> withNewHeaders();
    public HTTPRouteDestinationFluent.HeadersNested<A> withNewHeadersLike(Headers item);
    public HTTPRouteDestinationFluent.HeadersNested<A> editHeaders();
    public HTTPRouteDestinationFluent.HeadersNested<A> editOrNewHeaders();
    public HTTPRouteDestinationFluent.HeadersNested<A> editOrNewHeadersLike(Headers item);
    public A addToRemoveRequestHeaders(int index,String item);
    public A setToRemoveRequestHeaders(int index,String item);
    public A addToRemoveRequestHeaders(String... items);
    public A addAllToRemoveRequestHeaders(Collection<String> items);
    public A removeFromRemoveRequestHeaders(String... items);
    public A removeAllFromRemoveRequestHeaders(Collection<String> items);
    public List<String> getRemoveRequestHeaders();
    public String getRemoveRequestHeader(int index);
    public String getFirstRemoveRequestHeader();
    public String getLastRemoveRequestHeader();
    public String getMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRemoveRequestHeaders(List<String> removeRequestHeaders);
    public A withRemoveRequestHeaders(String... removeRequestHeaders);
    public Boolean hasRemoveRequestHeaders();
    public A addNewRemoveRequestHeader(String arg1);
    public A addNewRemoveRequestHeader(StringBuilder arg1);
    public A addNewRemoveRequestHeader(StringBuffer arg1);
    public A addToRemoveResponseHeaders(int index,String item);
    public A setToRemoveResponseHeaders(int index,String item);
    public A addToRemoveResponseHeaders(String... items);
    public A addAllToRemoveResponseHeaders(Collection<String> items);
    public A removeFromRemoveResponseHeaders(String... items);
    public A removeAllFromRemoveResponseHeaders(Collection<String> items);
    public List<String> getRemoveResponseHeaders();
    public String getRemoveResponseHeader(int index);
    public String getFirstRemoveResponseHeader();
    public String getLastRemoveResponseHeader();
    public String getMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRemoveResponseHeaders(List<String> removeResponseHeaders);
    public A withRemoveResponseHeaders(String... removeResponseHeaders);
    public Boolean hasRemoveResponseHeaders();
    public A addNewRemoveResponseHeader(String arg1);
    public A addNewRemoveResponseHeader(StringBuilder arg1);
    public A addNewRemoveResponseHeader(StringBuffer arg1);
    public Integer getWeight();
    public A withWeight(Integer weight);
    public Boolean hasWeight();

    public interface DestinationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DestinationFluent<HTTPRouteDestinationFluent.DestinationNested<N>>{

        
    public N and();    public N endDestination();
}
    public interface HeadersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HeadersFluent<HTTPRouteDestinationFluent.HeadersNested<N>>{

        
    public N and();    public N endHeaders();
}


}
