package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class HTTPRouteDestinationFluentImpl<A extends HTTPRouteDestinationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPRouteDestinationFluent<A>{

    private Map<String,String> appendRequestHeaders;
    private Map<String,String> appendResponseHeaders;
    private DestinationBuilder destination;
    private HeadersBuilder headers;
    private List<String> removeRequestHeaders;
    private List<String> removeResponseHeaders;
    private Integer weight;

    public HTTPRouteDestinationFluentImpl(){
    }
    public HTTPRouteDestinationFluentImpl(HTTPRouteDestination instance){
            this.withAppendRequestHeaders(instance.getAppendRequestHeaders()); 
            this.withAppendResponseHeaders(instance.getAppendResponseHeaders()); 
            this.withDestination(instance.getDestination()); 
            this.withHeaders(instance.getHeaders()); 
            this.withRemoveRequestHeaders(instance.getRemoveRequestHeaders()); 
            this.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            this.withWeight(instance.getWeight()); 
    }

    public A addToAppendRequestHeaders(String key,String value){
            if(this.appendRequestHeaders == null && key != null && value != null) { this.appendRequestHeaders = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.appendRequestHeaders.put(key, value);} return (A)this;
    }

    public A addToAppendRequestHeaders(Map<String,String> map){
            if(this.appendRequestHeaders == null && map != null) { this.appendRequestHeaders = new LinkedHashMap<String,String>(); }
            if(map != null) { this.appendRequestHeaders.putAll(map);} return (A)this;
    }

    public A removeFromAppendRequestHeaders(String key){
            if(this.appendRequestHeaders == null) { return (A) this; }
            if(key != null && this.appendRequestHeaders != null) {this.appendRequestHeaders.remove(key);} return (A)this;
    }

    public A removeFromAppendRequestHeaders(Map<String,String> map){
            if(this.appendRequestHeaders == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.appendRequestHeaders != null){this.appendRequestHeaders.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAppendRequestHeaders(){
            return this.appendRequestHeaders;
    }

    public A withAppendRequestHeaders(Map<String,String> appendRequestHeaders){
            if (appendRequestHeaders == null) { this.appendRequestHeaders =  null;} else {this.appendRequestHeaders = new LinkedHashMap<String,String>(appendRequestHeaders);} return (A) this;
    }

    public Boolean hasAppendRequestHeaders(){
            return this.appendRequestHeaders != null;
    }

    public A addToAppendResponseHeaders(String key,String value){
            if(this.appendResponseHeaders == null && key != null && value != null) { this.appendResponseHeaders = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.appendResponseHeaders.put(key, value);} return (A)this;
    }

    public A addToAppendResponseHeaders(Map<String,String> map){
            if(this.appendResponseHeaders == null && map != null) { this.appendResponseHeaders = new LinkedHashMap<String,String>(); }
            if(map != null) { this.appendResponseHeaders.putAll(map);} return (A)this;
    }

    public A removeFromAppendResponseHeaders(String key){
            if(this.appendResponseHeaders == null) { return (A) this; }
            if(key != null && this.appendResponseHeaders != null) {this.appendResponseHeaders.remove(key);} return (A)this;
    }

    public A removeFromAppendResponseHeaders(Map<String,String> map){
            if(this.appendResponseHeaders == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.appendResponseHeaders != null){this.appendResponseHeaders.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAppendResponseHeaders(){
            return this.appendResponseHeaders;
    }

    public A withAppendResponseHeaders(Map<String,String> appendResponseHeaders){
            if (appendResponseHeaders == null) { this.appendResponseHeaders =  null;} else {this.appendResponseHeaders = new LinkedHashMap<String,String>(appendResponseHeaders);} return (A) this;
    }

    public Boolean hasAppendResponseHeaders(){
            return this.appendResponseHeaders != null;
    }

    
/**
 * This method has been deprecated, please use method buildDestination instead.
 * @return The buildable object.
 */
@Deprecated public Destination getDestination(){
            return this.destination!=null?this.destination.build():null;
    }

    public Destination buildDestination(){
            return this.destination!=null?this.destination.build():null;
    }

    public A withDestination(Destination destination){
            _visitables.get("destination").remove(this.destination);
            if (destination!=null){ this.destination= new DestinationBuilder(destination); _visitables.get("destination").add(this.destination);} return (A) this;
    }

    public Boolean hasDestination(){
            return this.destination != null;
    }

    public HTTPRouteDestinationFluent.DestinationNested<A> withNewDestination(){
            return new DestinationNestedImpl();
    }

    public HTTPRouteDestinationFluent.DestinationNested<A> withNewDestinationLike(Destination item){
            return new DestinationNestedImpl(item);
    }

    public HTTPRouteDestinationFluent.DestinationNested<A> editDestination(){
            return withNewDestinationLike(getDestination());
    }

    public HTTPRouteDestinationFluent.DestinationNested<A> editOrNewDestination(){
            return withNewDestinationLike(getDestination() != null ? getDestination(): new DestinationBuilder().build());
    }

    public HTTPRouteDestinationFluent.DestinationNested<A> editOrNewDestinationLike(Destination item){
            return withNewDestinationLike(getDestination() != null ? getDestination(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHeaders instead.
 * @return The buildable object.
 */
@Deprecated public Headers getHeaders(){
            return this.headers!=null?this.headers.build():null;
    }

    public Headers buildHeaders(){
            return this.headers!=null?this.headers.build():null;
    }

    public A withHeaders(Headers headers){
            _visitables.get("headers").remove(this.headers);
            if (headers!=null){ this.headers= new HeadersBuilder(headers); _visitables.get("headers").add(this.headers);} return (A) this;
    }

    public Boolean hasHeaders(){
            return this.headers != null;
    }

    public HTTPRouteDestinationFluent.HeadersNested<A> withNewHeaders(){
            return new HeadersNestedImpl();
    }

    public HTTPRouteDestinationFluent.HeadersNested<A> withNewHeadersLike(Headers item){
            return new HeadersNestedImpl(item);
    }

    public HTTPRouteDestinationFluent.HeadersNested<A> editHeaders(){
            return withNewHeadersLike(getHeaders());
    }

    public HTTPRouteDestinationFluent.HeadersNested<A> editOrNewHeaders(){
            return withNewHeadersLike(getHeaders() != null ? getHeaders(): new HeadersBuilder().build());
    }

    public HTTPRouteDestinationFluent.HeadersNested<A> editOrNewHeadersLike(Headers item){
            return withNewHeadersLike(getHeaders() != null ? getHeaders(): item);
    }

    public A addToRemoveRequestHeaders(int index,String item){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            this.removeRequestHeaders.add(index, item);
            return (A)this;
    }

    public A setToRemoveRequestHeaders(int index,String item){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            this.removeRequestHeaders.set(index, item); return (A)this;
    }

    public A addToRemoveRequestHeaders(String... items){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeRequestHeaders.add(item);} return (A)this;
    }

    public A addAllToRemoveRequestHeaders(Collection<String> items){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeRequestHeaders.add(item);} return (A)this;
    }

    public A removeFromRemoveRequestHeaders(String... items){
            for (String item : items) {if (this.removeRequestHeaders!= null){ this.removeRequestHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromRemoveRequestHeaders(Collection<String> items){
            for (String item : items) {if (this.removeRequestHeaders!= null){ this.removeRequestHeaders.remove(item);}} return (A)this;
    }

    public List<String> getRemoveRequestHeaders(){
            return this.removeRequestHeaders;
    }

    public String getRemoveRequestHeader(int index){
            return this.removeRequestHeaders.get(index);
    }

    public String getFirstRemoveRequestHeader(){
            return this.removeRequestHeaders.get(0);
    }

    public String getLastRemoveRequestHeader(){
            return this.removeRequestHeaders.get(removeRequestHeaders.size() - 1);
    }

    public String getMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeRequestHeaders) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeRequestHeaders) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRemoveRequestHeaders(List<String> removeRequestHeaders){
            if (this.removeRequestHeaders != null) { _visitables.get("removeRequestHeaders").removeAll(this.removeRequestHeaders);}
            if (removeRequestHeaders != null) {this.removeRequestHeaders = new ArrayList<String>(); for (String item : removeRequestHeaders){this.addToRemoveRequestHeaders(item);}} else { this.removeRequestHeaders = null;} return (A) this;
    }

    public A withRemoveRequestHeaders(String... removeRequestHeaders){
            if (this.removeRequestHeaders != null) {this.removeRequestHeaders.clear();}
            if (removeRequestHeaders != null) {for (String item :removeRequestHeaders){ this.addToRemoveRequestHeaders(item);}} return (A) this;
    }

    public Boolean hasRemoveRequestHeaders(){
            return removeRequestHeaders != null && !removeRequestHeaders.isEmpty();
    }

    public A addNewRemoveRequestHeader(String arg1){
            return (A)addToRemoveRequestHeaders(new String(arg1));
    }

    public A addNewRemoveRequestHeader(StringBuilder arg1){
            return (A)addToRemoveRequestHeaders(new String(arg1));
    }

    public A addNewRemoveRequestHeader(StringBuffer arg1){
            return (A)addToRemoveRequestHeaders(new String(arg1));
    }

    public A addToRemoveResponseHeaders(int index,String item){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            this.removeResponseHeaders.add(index, item);
            return (A)this;
    }

    public A setToRemoveResponseHeaders(int index,String item){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            this.removeResponseHeaders.set(index, item); return (A)this;
    }

    public A addToRemoveResponseHeaders(String... items){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeResponseHeaders.add(item);} return (A)this;
    }

    public A addAllToRemoveResponseHeaders(Collection<String> items){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeResponseHeaders.add(item);} return (A)this;
    }

    public A removeFromRemoveResponseHeaders(String... items){
            for (String item : items) {if (this.removeResponseHeaders!= null){ this.removeResponseHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromRemoveResponseHeaders(Collection<String> items){
            for (String item : items) {if (this.removeResponseHeaders!= null){ this.removeResponseHeaders.remove(item);}} return (A)this;
    }

    public List<String> getRemoveResponseHeaders(){
            return this.removeResponseHeaders;
    }

    public String getRemoveResponseHeader(int index){
            return this.removeResponseHeaders.get(index);
    }

    public String getFirstRemoveResponseHeader(){
            return this.removeResponseHeaders.get(0);
    }

    public String getLastRemoveResponseHeader(){
            return this.removeResponseHeaders.get(removeResponseHeaders.size() - 1);
    }

    public String getMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeResponseHeaders) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeResponseHeaders) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRemoveResponseHeaders(List<String> removeResponseHeaders){
            if (this.removeResponseHeaders != null) { _visitables.get("removeResponseHeaders").removeAll(this.removeResponseHeaders);}
            if (removeResponseHeaders != null) {this.removeResponseHeaders = new ArrayList<String>(); for (String item : removeResponseHeaders){this.addToRemoveResponseHeaders(item);}} else { this.removeResponseHeaders = null;} return (A) this;
    }

    public A withRemoveResponseHeaders(String... removeResponseHeaders){
            if (this.removeResponseHeaders != null) {this.removeResponseHeaders.clear();}
            if (removeResponseHeaders != null) {for (String item :removeResponseHeaders){ this.addToRemoveResponseHeaders(item);}} return (A) this;
    }

    public Boolean hasRemoveResponseHeaders(){
            return removeResponseHeaders != null && !removeResponseHeaders.isEmpty();
    }

    public A addNewRemoveResponseHeader(String arg1){
            return (A)addToRemoveResponseHeaders(new String(arg1));
    }

    public A addNewRemoveResponseHeader(StringBuilder arg1){
            return (A)addToRemoveResponseHeaders(new String(arg1));
    }

    public A addNewRemoveResponseHeader(StringBuffer arg1){
            return (A)addToRemoveResponseHeaders(new String(arg1));
    }

    public Integer getWeight(){
            return this.weight;
    }

    public A withWeight(Integer weight){
            this.weight=weight; return (A) this;
    }

    public Boolean hasWeight(){
            return this.weight != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPRouteDestinationFluentImpl that = (HTTPRouteDestinationFluentImpl) o;
            if (appendRequestHeaders != null ? !appendRequestHeaders.equals(that.appendRequestHeaders) :that.appendRequestHeaders != null) return false;
            if (appendResponseHeaders != null ? !appendResponseHeaders.equals(that.appendResponseHeaders) :that.appendResponseHeaders != null) return false;
            if (destination != null ? !destination.equals(that.destination) :that.destination != null) return false;
            if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
            if (removeRequestHeaders != null ? !removeRequestHeaders.equals(that.removeRequestHeaders) :that.removeRequestHeaders != null) return false;
            if (removeResponseHeaders != null ? !removeResponseHeaders.equals(that.removeResponseHeaders) :that.removeResponseHeaders != null) return false;
            if (weight != null ? !weight.equals(that.weight) :that.weight != null) return false;
            return true;
    }


    public class DestinationNestedImpl<N> extends DestinationFluentImpl<HTTPRouteDestinationFluent.DestinationNested<N>> implements HTTPRouteDestinationFluent.DestinationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DestinationBuilder builder;
    
            DestinationNestedImpl(Destination item){
                    this.builder = new DestinationBuilder(this, item);
            }
            DestinationNestedImpl(){
                    this.builder = new DestinationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteDestinationFluentImpl.this.withDestination(builder.build());
    }
    public N endDestination(){
            return and();
    }

}
    public class HeadersNestedImpl<N> extends HeadersFluentImpl<HTTPRouteDestinationFluent.HeadersNested<N>> implements HTTPRouteDestinationFluent.HeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HeadersBuilder builder;
    
            HeadersNestedImpl(Headers item){
                    this.builder = new HeadersBuilder(this, item);
            }
            HeadersNestedImpl(){
                    this.builder = new HeadersBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteDestinationFluentImpl.this.withHeaders(builder.build());
    }
    public N endHeaders(){
            return and();
    }

}


}
