package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.Duration;
import java.lang.Long;
import java.util.Collection;
import java.util.Map;
import me.snowdrop.istio.api.DurationBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationFluent;
import java.lang.Integer;
import java.lang.StringBuffer;

public interface HTTPRouteFluent<A extends HTTPRouteFluent<A>> extends Fluent<A>{


    public A addToAppendHeaders(String key,String value);
    public A addToAppendHeaders(Map<String,String> map);
    public A removeFromAppendHeaders(String key);
    public A removeFromAppendHeaders(Map<String,String> map);
    public Map<String,String> getAppendHeaders();
    public A withAppendHeaders(Map<String,String> appendHeaders);
    public Boolean hasAppendHeaders();
    public A addToAppendRequestHeaders(String key,String value);
    public A addToAppendRequestHeaders(Map<String,String> map);
    public A removeFromAppendRequestHeaders(String key);
    public A removeFromAppendRequestHeaders(Map<String,String> map);
    public Map<String,String> getAppendRequestHeaders();
    public A withAppendRequestHeaders(Map<String,String> appendRequestHeaders);
    public Boolean hasAppendRequestHeaders();
    public A addToAppendResponseHeaders(String key,String value);
    public A addToAppendResponseHeaders(Map<String,String> map);
    public A removeFromAppendResponseHeaders(String key);
    public A removeFromAppendResponseHeaders(Map<String,String> map);
    public Map<String,String> getAppendResponseHeaders();
    public A withAppendResponseHeaders(Map<String,String> appendResponseHeaders);
    public Boolean hasAppendResponseHeaders();
    
/**
 * This method has been deprecated, please use method buildCorsPolicy instead.
 * @return The buildable object.
 */
@Deprecated public CorsPolicy getCorsPolicy();
    public CorsPolicy buildCorsPolicy();
    public A withCorsPolicy(CorsPolicy corsPolicy);
    public Boolean hasCorsPolicy();
    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicy();
    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicyLike(CorsPolicy item);
    public HTTPRouteFluent.CorsPolicyNested<A> editCorsPolicy();
    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicy();
    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicyLike(CorsPolicy item);
    
/**
 * This method has been deprecated, please use method buildFault instead.
 * @return The buildable object.
 */
@Deprecated public HTTPFaultInjection getFault();
    public HTTPFaultInjection buildFault();
    public A withFault(HTTPFaultInjection fault);
    public Boolean hasFault();
    public HTTPRouteFluent.FaultNested<A> withNewFault();
    public HTTPRouteFluent.FaultNested<A> withNewFaultLike(HTTPFaultInjection item);
    public HTTPRouteFluent.FaultNested<A> editFault();
    public HTTPRouteFluent.FaultNested<A> editOrNewFault();
    public HTTPRouteFluent.FaultNested<A> editOrNewFaultLike(HTTPFaultInjection item);
    
/**
 * This method has been deprecated, please use method buildHeaders instead.
 * @return The buildable object.
 */
@Deprecated public Headers getHeaders();
    public Headers buildHeaders();
    public A withHeaders(Headers headers);
    public Boolean hasHeaders();
    public HTTPRouteFluent.HeadersNested<A> withNewHeaders();
    public HTTPRouteFluent.HeadersNested<A> withNewHeadersLike(Headers item);
    public HTTPRouteFluent.HeadersNested<A> editHeaders();
    public HTTPRouteFluent.HeadersNested<A> editOrNewHeaders();
    public HTTPRouteFluent.HeadersNested<A> editOrNewHeadersLike(Headers item);
    public A addToMatch(int index,HTTPMatchRequest item);
    public A setToMatch(int index,HTTPMatchRequest item);
    public A addToMatch(HTTPMatchRequest... items);
    public A addAllToMatch(Collection<HTTPMatchRequest> items);
    public A removeFromMatch(HTTPMatchRequest... items);
    public A removeAllFromMatch(Collection<HTTPMatchRequest> items);
    public A removeMatchingFromMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMatch instead.
 * @return The buildable object.
 */
@Deprecated public List<HTTPMatchRequest> getMatch();
    public List<HTTPMatchRequest> buildMatch();
    public HTTPMatchRequest buildMatch(int index);
    public HTTPMatchRequest buildFirstMatch();
    public HTTPMatchRequest buildLastMatch();
    public HTTPMatchRequest buildMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate);
    public Boolean hasMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate);
    public A withMatch(List<HTTPMatchRequest> match);
    public A withMatch(HTTPMatchRequest... match);
    public Boolean hasMatch();
    public HTTPRouteFluent.MatchNested<A> addNewMatch();
    public HTTPRouteFluent.MatchNested<A> addNewMatchLike(HTTPMatchRequest item);
    public HTTPRouteFluent.MatchNested<A> setNewMatchLike(int index,HTTPMatchRequest item);
    public HTTPRouteFluent.MatchNested<A> editMatch(int index);
    public HTTPRouteFluent.MatchNested<A> editFirstMatch();
    public HTTPRouteFluent.MatchNested<A> editLastMatch();
    public HTTPRouteFluent.MatchNested<A> editMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMirror instead.
 * @return The buildable object.
 */
@Deprecated public Destination getMirror();
    public Destination buildMirror();
    public A withMirror(Destination mirror);
    public Boolean hasMirror();
    public HTTPRouteFluent.MirrorNested<A> withNewMirror();
    public HTTPRouteFluent.MirrorNested<A> withNewMirrorLike(Destination item);
    public HTTPRouteFluent.MirrorNested<A> editMirror();
    public HTTPRouteFluent.MirrorNested<A> editOrNewMirror();
    public HTTPRouteFluent.MirrorNested<A> editOrNewMirrorLike(Destination item);
    
/**
 * This method has been deprecated, please use method buildRedirect instead.
 * @return The buildable object.
 */
@Deprecated public HTTPRedirect getRedirect();
    public HTTPRedirect buildRedirect();
    public A withRedirect(HTTPRedirect redirect);
    public Boolean hasRedirect();
    public A withNewRedirect(String authority,String uri);
    public HTTPRouteFluent.RedirectNested<A> withNewRedirect();
    public HTTPRouteFluent.RedirectNested<A> withNewRedirectLike(HTTPRedirect item);
    public HTTPRouteFluent.RedirectNested<A> editRedirect();
    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirect();
    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirectLike(HTTPRedirect item);
    public A addToRemoveRequestHeaders(int index,String item);
    public A setToRemoveRequestHeaders(int index,String item);
    public A addToRemoveRequestHeaders(String... items);
    public A addAllToRemoveRequestHeaders(Collection<String> items);
    public A removeFromRemoveRequestHeaders(String... items);
    public A removeAllFromRemoveRequestHeaders(Collection<String> items);
    public List<String> getRemoveRequestHeaders();
    public String getRemoveRequestHeader(int index);
    public String getFirstRemoveRequestHeader();
    public String getLastRemoveRequestHeader();
    public String getMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRemoveRequestHeaders(List<String> removeRequestHeaders);
    public A withRemoveRequestHeaders(String... removeRequestHeaders);
    public Boolean hasRemoveRequestHeaders();
    public A addNewRemoveRequestHeader(String arg1);
    public A addNewRemoveRequestHeader(StringBuilder arg1);
    public A addNewRemoveRequestHeader(StringBuffer arg1);
    public A addToRemoveResponseHeaders(int index,String item);
    public A setToRemoveResponseHeaders(int index,String item);
    public A addToRemoveResponseHeaders(String... items);
    public A addAllToRemoveResponseHeaders(Collection<String> items);
    public A removeFromRemoveResponseHeaders(String... items);
    public A removeAllFromRemoveResponseHeaders(Collection<String> items);
    public List<String> getRemoveResponseHeaders();
    public String getRemoveResponseHeader(int index);
    public String getFirstRemoveResponseHeader();
    public String getLastRemoveResponseHeader();
    public String getMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRemoveResponseHeaders(List<String> removeResponseHeaders);
    public A withRemoveResponseHeaders(String... removeResponseHeaders);
    public Boolean hasRemoveResponseHeaders();
    public A addNewRemoveResponseHeader(String arg1);
    public A addNewRemoveResponseHeader(StringBuilder arg1);
    public A addNewRemoveResponseHeader(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildRetries instead.
 * @return The buildable object.
 */
@Deprecated public HTTPRetry getRetries();
    public HTTPRetry buildRetries();
    public A withRetries(HTTPRetry retries);
    public Boolean hasRetries();
    public HTTPRouteFluent.RetriesNested<A> withNewRetries();
    public HTTPRouteFluent.RetriesNested<A> withNewRetriesLike(HTTPRetry item);
    public HTTPRouteFluent.RetriesNested<A> editRetries();
    public HTTPRouteFluent.RetriesNested<A> editOrNewRetries();
    public HTTPRouteFluent.RetriesNested<A> editOrNewRetriesLike(HTTPRetry item);
    
/**
 * This method has been deprecated, please use method buildRewrite instead.
 * @return The buildable object.
 */
@Deprecated public HTTPRewrite getRewrite();
    public HTTPRewrite buildRewrite();
    public A withRewrite(HTTPRewrite rewrite);
    public Boolean hasRewrite();
    public A withNewRewrite(String authority,String uri);
    public HTTPRouteFluent.RewriteNested<A> withNewRewrite();
    public HTTPRouteFluent.RewriteNested<A> withNewRewriteLike(HTTPRewrite item);
    public HTTPRouteFluent.RewriteNested<A> editRewrite();
    public HTTPRouteFluent.RewriteNested<A> editOrNewRewrite();
    public HTTPRouteFluent.RewriteNested<A> editOrNewRewriteLike(HTTPRewrite item);
    public A addToRoute(int index,HTTPRouteDestination item);
    public A setToRoute(int index,HTTPRouteDestination item);
    public A addToRoute(HTTPRouteDestination... items);
    public A addAllToRoute(Collection<HTTPRouteDestination> items);
    public A removeFromRoute(HTTPRouteDestination... items);
    public A removeAllFromRoute(Collection<HTTPRouteDestination> items);
    public A removeMatchingFromRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public List<HTTPRouteDestination> getRoute();
    public List<HTTPRouteDestination> buildRoute();
    public HTTPRouteDestination buildRoute(int index);
    public HTTPRouteDestination buildFirstRoute();
    public HTTPRouteDestination buildLastRoute();
    public HTTPRouteDestination buildMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate);
    public Boolean hasMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate);
    public A withRoute(List<HTTPRouteDestination> route);
    public A withRoute(HTTPRouteDestination... route);
    public Boolean hasRoute();
    public HTTPRouteFluent.RouteNested<A> addNewRoute();
    public HTTPRouteFluent.RouteNested<A> addNewRouteLike(HTTPRouteDestination item);
    public HTTPRouteFluent.RouteNested<A> setNewRouteLike(int index,HTTPRouteDestination item);
    public HTTPRouteFluent.RouteNested<A> editRoute(int index);
    public HTTPRouteFluent.RouteNested<A> editFirstRoute();
    public HTTPRouteFluent.RouteNested<A> editLastRoute();
    public HTTPRouteFluent.RouteNested<A> editMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getTimeout();
    public Duration buildTimeout();
    public A withTimeout(Duration timeout);
    public Boolean hasTimeout();
    public A withNewTimeout(Integer nanos,Long seconds);
    public HTTPRouteFluent.TimeoutNested<A> withNewTimeout();
    public HTTPRouteFluent.TimeoutNested<A> withNewTimeoutLike(Duration item);
    public HTTPRouteFluent.TimeoutNested<A> editTimeout();
    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeout();
    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeoutLike(Duration item);
    public Boolean isWebsocketUpgrade();
    public A withWebsocketUpgrade(Boolean websocketUpgrade);
    public Boolean hasWebsocketUpgrade();
    public A withNewWebsocketUpgrade(String arg1);
    public A withNewWebsocketUpgrade(boolean arg1);

    public interface CorsPolicyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CorsPolicyFluent<HTTPRouteFluent.CorsPolicyNested<N>>{

        
    public N and();    public N endCorsPolicy();
}
    public interface FaultNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPFaultInjectionFluent<HTTPRouteFluent.FaultNested<N>>{

        
    public N and();    public N endFault();
}
    public interface HeadersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HeadersFluent<HTTPRouteFluent.HeadersNested<N>>{

        
    public N and();    public N endHeaders();
}
    public interface MatchNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPMatchRequestFluent<HTTPRouteFluent.MatchNested<N>>{

        
    public N and();    public N endMatch();
}
    public interface MirrorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DestinationFluent<HTTPRouteFluent.MirrorNested<N>>{

        
    public N and();    public N endMirror();
}
    public interface RedirectNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPRedirectFluent<HTTPRouteFluent.RedirectNested<N>>{

        
    public N and();    public N endRedirect();
}
    public interface RetriesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPRetryFluent<HTTPRouteFluent.RetriesNested<N>>{

        
    public N and();    public N endRetries();
}
    public interface RewriteNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPRewriteFluent<HTTPRouteFluent.RewriteNested<N>>{

        
    public N and();    public N endRewrite();
}
    public interface RouteNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HTTPRouteDestinationFluent<HTTPRouteFluent.RouteNested<N>>{

        
    public N and();    public N endRoute();
}
    public interface TimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<HTTPRouteFluent.TimeoutNested<N>>{

        
    public N and();    public N endTimeout();
}


}
