package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import me.snowdrop.istio.api.Duration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import me.snowdrop.istio.api.DurationBuilder;
import me.snowdrop.istio.api.DurationFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;

public class HTTPRouteFluentImpl<A extends HTTPRouteFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPRouteFluent<A>{

    private Map<String,String> appendHeaders;
    private Map<String,String> appendRequestHeaders;
    private Map<String,String> appendResponseHeaders;
    private CorsPolicyBuilder corsPolicy;
    private HTTPFaultInjectionBuilder fault;
    private HeadersBuilder headers;
    private List<HTTPMatchRequestBuilder> match;
    private DestinationBuilder mirror;
    private HTTPRedirectBuilder redirect;
    private List<String> removeRequestHeaders;
    private List<String> removeResponseHeaders;
    private HTTPRetryBuilder retries;
    private HTTPRewriteBuilder rewrite;
    private List<HTTPRouteDestinationBuilder> route;
    private DurationBuilder timeout;
    private Boolean websocketUpgrade;

    public HTTPRouteFluentImpl(){
    }
    public HTTPRouteFluentImpl(HTTPRoute instance){
            this.withAppendHeaders(instance.getAppendHeaders()); 
            this.withAppendRequestHeaders(instance.getAppendRequestHeaders()); 
            this.withAppendResponseHeaders(instance.getAppendResponseHeaders()); 
            this.withCorsPolicy(instance.getCorsPolicy()); 
            this.withFault(instance.getFault()); 
            this.withHeaders(instance.getHeaders()); 
            this.withMatch(instance.getMatch()); 
            this.withMirror(instance.getMirror()); 
            this.withRedirect(instance.getRedirect()); 
            this.withRemoveRequestHeaders(instance.getRemoveRequestHeaders()); 
            this.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            this.withRetries(instance.getRetries()); 
            this.withRewrite(instance.getRewrite()); 
            this.withRoute(instance.getRoute()); 
            this.withTimeout(instance.getTimeout()); 
            this.withWebsocketUpgrade(instance.getWebsocketUpgrade()); 
    }

    public A addToAppendHeaders(String key,String value){
            if(this.appendHeaders == null && key != null && value != null) { this.appendHeaders = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.appendHeaders.put(key, value);} return (A)this;
    }

    public A addToAppendHeaders(Map<String,String> map){
            if(this.appendHeaders == null && map != null) { this.appendHeaders = new LinkedHashMap<String,String>(); }
            if(map != null) { this.appendHeaders.putAll(map);} return (A)this;
    }

    public A removeFromAppendHeaders(String key){
            if(this.appendHeaders == null) { return (A) this; }
            if(key != null && this.appendHeaders != null) {this.appendHeaders.remove(key);} return (A)this;
    }

    public A removeFromAppendHeaders(Map<String,String> map){
            if(this.appendHeaders == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.appendHeaders != null){this.appendHeaders.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAppendHeaders(){
            return this.appendHeaders;
    }

    public A withAppendHeaders(Map<String,String> appendHeaders){
            if (appendHeaders == null) { this.appendHeaders =  null;} else {this.appendHeaders = new LinkedHashMap<String,String>(appendHeaders);} return (A) this;
    }

    public Boolean hasAppendHeaders(){
            return this.appendHeaders != null;
    }

    public A addToAppendRequestHeaders(String key,String value){
            if(this.appendRequestHeaders == null && key != null && value != null) { this.appendRequestHeaders = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.appendRequestHeaders.put(key, value);} return (A)this;
    }

    public A addToAppendRequestHeaders(Map<String,String> map){
            if(this.appendRequestHeaders == null && map != null) { this.appendRequestHeaders = new LinkedHashMap<String,String>(); }
            if(map != null) { this.appendRequestHeaders.putAll(map);} return (A)this;
    }

    public A removeFromAppendRequestHeaders(String key){
            if(this.appendRequestHeaders == null) { return (A) this; }
            if(key != null && this.appendRequestHeaders != null) {this.appendRequestHeaders.remove(key);} return (A)this;
    }

    public A removeFromAppendRequestHeaders(Map<String,String> map){
            if(this.appendRequestHeaders == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.appendRequestHeaders != null){this.appendRequestHeaders.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAppendRequestHeaders(){
            return this.appendRequestHeaders;
    }

    public A withAppendRequestHeaders(Map<String,String> appendRequestHeaders){
            if (appendRequestHeaders == null) { this.appendRequestHeaders =  null;} else {this.appendRequestHeaders = new LinkedHashMap<String,String>(appendRequestHeaders);} return (A) this;
    }

    public Boolean hasAppendRequestHeaders(){
            return this.appendRequestHeaders != null;
    }

    public A addToAppendResponseHeaders(String key,String value){
            if(this.appendResponseHeaders == null && key != null && value != null) { this.appendResponseHeaders = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.appendResponseHeaders.put(key, value);} return (A)this;
    }

    public A addToAppendResponseHeaders(Map<String,String> map){
            if(this.appendResponseHeaders == null && map != null) { this.appendResponseHeaders = new LinkedHashMap<String,String>(); }
            if(map != null) { this.appendResponseHeaders.putAll(map);} return (A)this;
    }

    public A removeFromAppendResponseHeaders(String key){
            if(this.appendResponseHeaders == null) { return (A) this; }
            if(key != null && this.appendResponseHeaders != null) {this.appendResponseHeaders.remove(key);} return (A)this;
    }

    public A removeFromAppendResponseHeaders(Map<String,String> map){
            if(this.appendResponseHeaders == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.appendResponseHeaders != null){this.appendResponseHeaders.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAppendResponseHeaders(){
            return this.appendResponseHeaders;
    }

    public A withAppendResponseHeaders(Map<String,String> appendResponseHeaders){
            if (appendResponseHeaders == null) { this.appendResponseHeaders =  null;} else {this.appendResponseHeaders = new LinkedHashMap<String,String>(appendResponseHeaders);} return (A) this;
    }

    public Boolean hasAppendResponseHeaders(){
            return this.appendResponseHeaders != null;
    }

    
/**
 * This method has been deprecated, please use method buildCorsPolicy instead.
 * @return The buildable object.
 */
@Deprecated public CorsPolicy getCorsPolicy(){
            return this.corsPolicy!=null?this.corsPolicy.build():null;
    }

    public CorsPolicy buildCorsPolicy(){
            return this.corsPolicy!=null?this.corsPolicy.build():null;
    }

    public A withCorsPolicy(CorsPolicy corsPolicy){
            _visitables.get("corsPolicy").remove(this.corsPolicy);
            if (corsPolicy!=null){ this.corsPolicy= new CorsPolicyBuilder(corsPolicy); _visitables.get("corsPolicy").add(this.corsPolicy);} return (A) this;
    }

    public Boolean hasCorsPolicy(){
            return this.corsPolicy != null;
    }

    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicy(){
            return new CorsPolicyNestedImpl();
    }

    public HTTPRouteFluent.CorsPolicyNested<A> withNewCorsPolicyLike(CorsPolicy item){
            return new CorsPolicyNestedImpl(item);
    }

    public HTTPRouteFluent.CorsPolicyNested<A> editCorsPolicy(){
            return withNewCorsPolicyLike(getCorsPolicy());
    }

    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicy(){
            return withNewCorsPolicyLike(getCorsPolicy() != null ? getCorsPolicy(): new CorsPolicyBuilder().build());
    }

    public HTTPRouteFluent.CorsPolicyNested<A> editOrNewCorsPolicyLike(CorsPolicy item){
            return withNewCorsPolicyLike(getCorsPolicy() != null ? getCorsPolicy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildFault instead.
 * @return The buildable object.
 */
@Deprecated public HTTPFaultInjection getFault(){
            return this.fault!=null?this.fault.build():null;
    }

    public HTTPFaultInjection buildFault(){
            return this.fault!=null?this.fault.build():null;
    }

    public A withFault(HTTPFaultInjection fault){
            _visitables.get("fault").remove(this.fault);
            if (fault!=null){ this.fault= new HTTPFaultInjectionBuilder(fault); _visitables.get("fault").add(this.fault);} return (A) this;
    }

    public Boolean hasFault(){
            return this.fault != null;
    }

    public HTTPRouteFluent.FaultNested<A> withNewFault(){
            return new FaultNestedImpl();
    }

    public HTTPRouteFluent.FaultNested<A> withNewFaultLike(HTTPFaultInjection item){
            return new FaultNestedImpl(item);
    }

    public HTTPRouteFluent.FaultNested<A> editFault(){
            return withNewFaultLike(getFault());
    }

    public HTTPRouteFluent.FaultNested<A> editOrNewFault(){
            return withNewFaultLike(getFault() != null ? getFault(): new HTTPFaultInjectionBuilder().build());
    }

    public HTTPRouteFluent.FaultNested<A> editOrNewFaultLike(HTTPFaultInjection item){
            return withNewFaultLike(getFault() != null ? getFault(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHeaders instead.
 * @return The buildable object.
 */
@Deprecated public Headers getHeaders(){
            return this.headers!=null?this.headers.build():null;
    }

    public Headers buildHeaders(){
            return this.headers!=null?this.headers.build():null;
    }

    public A withHeaders(Headers headers){
            _visitables.get("headers").remove(this.headers);
            if (headers!=null){ this.headers= new HeadersBuilder(headers); _visitables.get("headers").add(this.headers);} return (A) this;
    }

    public Boolean hasHeaders(){
            return this.headers != null;
    }

    public HTTPRouteFluent.HeadersNested<A> withNewHeaders(){
            return new HeadersNestedImpl();
    }

    public HTTPRouteFluent.HeadersNested<A> withNewHeadersLike(Headers item){
            return new HeadersNestedImpl(item);
    }

    public HTTPRouteFluent.HeadersNested<A> editHeaders(){
            return withNewHeadersLike(getHeaders());
    }

    public HTTPRouteFluent.HeadersNested<A> editOrNewHeaders(){
            return withNewHeadersLike(getHeaders() != null ? getHeaders(): new HeadersBuilder().build());
    }

    public HTTPRouteFluent.HeadersNested<A> editOrNewHeadersLike(Headers item){
            return withNewHeadersLike(getHeaders() != null ? getHeaders(): item);
    }

    public A addToMatch(int index,HTTPMatchRequest item){
            if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").add(index >= 0 ? index : _visitables.get("match").size(), builder);this.match.add(index >= 0 ? index : match.size(), builder); return (A)this;
    }

    public A setToMatch(int index,HTTPMatchRequest item){
            if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
            HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
            if (index < 0 || index >= _visitables.get("match").size()) { _visitables.get("match").add(builder); } else { _visitables.get("match").set(index, builder);}
            if (index < 0 || index >= match.size()) { match.add(builder); } else { match.set(index, builder);}
             return (A)this;
    }

    public A addToMatch(HTTPMatchRequest... items){
            if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
            for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
    }

    public A addAllToMatch(Collection<HTTPMatchRequest> items){
            if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
            for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
    }

    public A removeFromMatch(HTTPMatchRequest... items){
            for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatch(Collection<HTTPMatchRequest> items){
            for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate){
            if (match == null) return (A) this;
            final Iterator<HTTPMatchRequestBuilder> each = match.iterator();
            final List visitables = _visitables.get("match");
            while (each.hasNext()) {
              HTTPMatchRequestBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatch instead.
 * @return The buildable object.
 */
@Deprecated public List<HTTPMatchRequest> getMatch(){
            return build(match);
    }

    public List<HTTPMatchRequest> buildMatch(){
            return build(match);
    }

    public HTTPMatchRequest buildMatch(int index){
            return this.match.get(index).build();
    }

    public HTTPMatchRequest buildFirstMatch(){
            return this.match.get(0).build();
    }

    public HTTPMatchRequest buildLastMatch(){
            return this.match.get(match.size() - 1).build();
    }

    public HTTPMatchRequest buildMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate){
            for (HTTPMatchRequestBuilder item: match) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate){
            for (HTTPMatchRequestBuilder item: match) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMatch(List<HTTPMatchRequest> match){
            if (this.match != null) { _visitables.get("match").removeAll(this.match);}
            if (match != null) {this.match = new ArrayList<HTTPMatchRequestBuilder>(); for (HTTPMatchRequest item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
    }

    public A withMatch(HTTPMatchRequest... match){
            if (this.match != null) {this.match.clear();}
            if (match != null) {for (HTTPMatchRequest item :match){ this.addToMatch(item);}} return (A) this;
    }

    public Boolean hasMatch(){
            return match != null && !match.isEmpty();
    }

    public HTTPRouteFluent.MatchNested<A> addNewMatch(){
            return new MatchNestedImpl();
    }

    public HTTPRouteFluent.MatchNested<A> addNewMatchLike(HTTPMatchRequest item){
            return new MatchNestedImpl(-1, item);
    }

    public HTTPRouteFluent.MatchNested<A> setNewMatchLike(int index,HTTPMatchRequest item){
            return new MatchNestedImpl(index, item);
    }

    public HTTPRouteFluent.MatchNested<A> editMatch(int index){
            if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public HTTPRouteFluent.MatchNested<A> editFirstMatch(){
            if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
            return setNewMatchLike(0, buildMatch(0));
    }

    public HTTPRouteFluent.MatchNested<A> editLastMatch(){
            int index = match.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public HTTPRouteFluent.MatchNested<A> editMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<HTTPMatchRequestBuilder> predicate){
            int index = -1;
            for (int i=0;i<match.size();i++) { 
            if (predicate.apply(match.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
            return setNewMatchLike(index, buildMatch(index));
    }

    
/**
 * This method has been deprecated, please use method buildMirror instead.
 * @return The buildable object.
 */
@Deprecated public Destination getMirror(){
            return this.mirror!=null?this.mirror.build():null;
    }

    public Destination buildMirror(){
            return this.mirror!=null?this.mirror.build():null;
    }

    public A withMirror(Destination mirror){
            _visitables.get("mirror").remove(this.mirror);
            if (mirror!=null){ this.mirror= new DestinationBuilder(mirror); _visitables.get("mirror").add(this.mirror);} return (A) this;
    }

    public Boolean hasMirror(){
            return this.mirror != null;
    }

    public HTTPRouteFluent.MirrorNested<A> withNewMirror(){
            return new MirrorNestedImpl();
    }

    public HTTPRouteFluent.MirrorNested<A> withNewMirrorLike(Destination item){
            return new MirrorNestedImpl(item);
    }

    public HTTPRouteFluent.MirrorNested<A> editMirror(){
            return withNewMirrorLike(getMirror());
    }

    public HTTPRouteFluent.MirrorNested<A> editOrNewMirror(){
            return withNewMirrorLike(getMirror() != null ? getMirror(): new DestinationBuilder().build());
    }

    public HTTPRouteFluent.MirrorNested<A> editOrNewMirrorLike(Destination item){
            return withNewMirrorLike(getMirror() != null ? getMirror(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRedirect instead.
 * @return The buildable object.
 */
@Deprecated public HTTPRedirect getRedirect(){
            return this.redirect!=null?this.redirect.build():null;
    }

    public HTTPRedirect buildRedirect(){
            return this.redirect!=null?this.redirect.build():null;
    }

    public A withRedirect(HTTPRedirect redirect){
            _visitables.get("redirect").remove(this.redirect);
            if (redirect!=null){ this.redirect= new HTTPRedirectBuilder(redirect); _visitables.get("redirect").add(this.redirect);} return (A) this;
    }

    public Boolean hasRedirect(){
            return this.redirect != null;
    }

    public A withNewRedirect(String authority,String uri){
            return (A)withRedirect(new HTTPRedirect(authority, uri));
    }

    public HTTPRouteFluent.RedirectNested<A> withNewRedirect(){
            return new RedirectNestedImpl();
    }

    public HTTPRouteFluent.RedirectNested<A> withNewRedirectLike(HTTPRedirect item){
            return new RedirectNestedImpl(item);
    }

    public HTTPRouteFluent.RedirectNested<A> editRedirect(){
            return withNewRedirectLike(getRedirect());
    }

    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirect(){
            return withNewRedirectLike(getRedirect() != null ? getRedirect(): new HTTPRedirectBuilder().build());
    }

    public HTTPRouteFluent.RedirectNested<A> editOrNewRedirectLike(HTTPRedirect item){
            return withNewRedirectLike(getRedirect() != null ? getRedirect(): item);
    }

    public A addToRemoveRequestHeaders(int index,String item){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            this.removeRequestHeaders.add(index, item);
            return (A)this;
    }

    public A setToRemoveRequestHeaders(int index,String item){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            this.removeRequestHeaders.set(index, item); return (A)this;
    }

    public A addToRemoveRequestHeaders(String... items){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeRequestHeaders.add(item);} return (A)this;
    }

    public A addAllToRemoveRequestHeaders(Collection<String> items){
            if (this.removeRequestHeaders == null) {this.removeRequestHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeRequestHeaders.add(item);} return (A)this;
    }

    public A removeFromRemoveRequestHeaders(String... items){
            for (String item : items) {if (this.removeRequestHeaders!= null){ this.removeRequestHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromRemoveRequestHeaders(Collection<String> items){
            for (String item : items) {if (this.removeRequestHeaders!= null){ this.removeRequestHeaders.remove(item);}} return (A)this;
    }

    public List<String> getRemoveRequestHeaders(){
            return this.removeRequestHeaders;
    }

    public String getRemoveRequestHeader(int index){
            return this.removeRequestHeaders.get(index);
    }

    public String getFirstRemoveRequestHeader(){
            return this.removeRequestHeaders.get(0);
    }

    public String getLastRemoveRequestHeader(){
            return this.removeRequestHeaders.get(removeRequestHeaders.size() - 1);
    }

    public String getMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeRequestHeaders) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRemoveRequestHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeRequestHeaders) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRemoveRequestHeaders(List<String> removeRequestHeaders){
            if (this.removeRequestHeaders != null) { _visitables.get("removeRequestHeaders").removeAll(this.removeRequestHeaders);}
            if (removeRequestHeaders != null) {this.removeRequestHeaders = new ArrayList<String>(); for (String item : removeRequestHeaders){this.addToRemoveRequestHeaders(item);}} else { this.removeRequestHeaders = null;} return (A) this;
    }

    public A withRemoveRequestHeaders(String... removeRequestHeaders){
            if (this.removeRequestHeaders != null) {this.removeRequestHeaders.clear();}
            if (removeRequestHeaders != null) {for (String item :removeRequestHeaders){ this.addToRemoveRequestHeaders(item);}} return (A) this;
    }

    public Boolean hasRemoveRequestHeaders(){
            return removeRequestHeaders != null && !removeRequestHeaders.isEmpty();
    }

    public A addNewRemoveRequestHeader(String arg1){
            return (A)addToRemoveRequestHeaders(new String(arg1));
    }

    public A addNewRemoveRequestHeader(StringBuilder arg1){
            return (A)addToRemoveRequestHeaders(new String(arg1));
    }

    public A addNewRemoveRequestHeader(StringBuffer arg1){
            return (A)addToRemoveRequestHeaders(new String(arg1));
    }

    public A addToRemoveResponseHeaders(int index,String item){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            this.removeResponseHeaders.add(index, item);
            return (A)this;
    }

    public A setToRemoveResponseHeaders(int index,String item){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            this.removeResponseHeaders.set(index, item); return (A)this;
    }

    public A addToRemoveResponseHeaders(String... items){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeResponseHeaders.add(item);} return (A)this;
    }

    public A addAllToRemoveResponseHeaders(Collection<String> items){
            if (this.removeResponseHeaders == null) {this.removeResponseHeaders = new ArrayList<String>();}
            for (String item : items) {this.removeResponseHeaders.add(item);} return (A)this;
    }

    public A removeFromRemoveResponseHeaders(String... items){
            for (String item : items) {if (this.removeResponseHeaders!= null){ this.removeResponseHeaders.remove(item);}} return (A)this;
    }

    public A removeAllFromRemoveResponseHeaders(Collection<String> items){
            for (String item : items) {if (this.removeResponseHeaders!= null){ this.removeResponseHeaders.remove(item);}} return (A)this;
    }

    public List<String> getRemoveResponseHeaders(){
            return this.removeResponseHeaders;
    }

    public String getRemoveResponseHeader(int index){
            return this.removeResponseHeaders.get(index);
    }

    public String getFirstRemoveResponseHeader(){
            return this.removeResponseHeaders.get(0);
    }

    public String getLastRemoveResponseHeader(){
            return this.removeResponseHeaders.get(removeResponseHeaders.size() - 1);
    }

    public String getMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeResponseHeaders) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRemoveResponseHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: removeResponseHeaders) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRemoveResponseHeaders(List<String> removeResponseHeaders){
            if (this.removeResponseHeaders != null) { _visitables.get("removeResponseHeaders").removeAll(this.removeResponseHeaders);}
            if (removeResponseHeaders != null) {this.removeResponseHeaders = new ArrayList<String>(); for (String item : removeResponseHeaders){this.addToRemoveResponseHeaders(item);}} else { this.removeResponseHeaders = null;} return (A) this;
    }

    public A withRemoveResponseHeaders(String... removeResponseHeaders){
            if (this.removeResponseHeaders != null) {this.removeResponseHeaders.clear();}
            if (removeResponseHeaders != null) {for (String item :removeResponseHeaders){ this.addToRemoveResponseHeaders(item);}} return (A) this;
    }

    public Boolean hasRemoveResponseHeaders(){
            return removeResponseHeaders != null && !removeResponseHeaders.isEmpty();
    }

    public A addNewRemoveResponseHeader(String arg1){
            return (A)addToRemoveResponseHeaders(new String(arg1));
    }

    public A addNewRemoveResponseHeader(StringBuilder arg1){
            return (A)addToRemoveResponseHeaders(new String(arg1));
    }

    public A addNewRemoveResponseHeader(StringBuffer arg1){
            return (A)addToRemoveResponseHeaders(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRetries instead.
 * @return The buildable object.
 */
@Deprecated public HTTPRetry getRetries(){
            return this.retries!=null?this.retries.build():null;
    }

    public HTTPRetry buildRetries(){
            return this.retries!=null?this.retries.build():null;
    }

    public A withRetries(HTTPRetry retries){
            _visitables.get("retries").remove(this.retries);
            if (retries!=null){ this.retries= new HTTPRetryBuilder(retries); _visitables.get("retries").add(this.retries);} return (A) this;
    }

    public Boolean hasRetries(){
            return this.retries != null;
    }

    public HTTPRouteFluent.RetriesNested<A> withNewRetries(){
            return new RetriesNestedImpl();
    }

    public HTTPRouteFluent.RetriesNested<A> withNewRetriesLike(HTTPRetry item){
            return new RetriesNestedImpl(item);
    }

    public HTTPRouteFluent.RetriesNested<A> editRetries(){
            return withNewRetriesLike(getRetries());
    }

    public HTTPRouteFluent.RetriesNested<A> editOrNewRetries(){
            return withNewRetriesLike(getRetries() != null ? getRetries(): new HTTPRetryBuilder().build());
    }

    public HTTPRouteFluent.RetriesNested<A> editOrNewRetriesLike(HTTPRetry item){
            return withNewRetriesLike(getRetries() != null ? getRetries(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRewrite instead.
 * @return The buildable object.
 */
@Deprecated public HTTPRewrite getRewrite(){
            return this.rewrite!=null?this.rewrite.build():null;
    }

    public HTTPRewrite buildRewrite(){
            return this.rewrite!=null?this.rewrite.build():null;
    }

    public A withRewrite(HTTPRewrite rewrite){
            _visitables.get("rewrite").remove(this.rewrite);
            if (rewrite!=null){ this.rewrite= new HTTPRewriteBuilder(rewrite); _visitables.get("rewrite").add(this.rewrite);} return (A) this;
    }

    public Boolean hasRewrite(){
            return this.rewrite != null;
    }

    public A withNewRewrite(String authority,String uri){
            return (A)withRewrite(new HTTPRewrite(authority, uri));
    }

    public HTTPRouteFluent.RewriteNested<A> withNewRewrite(){
            return new RewriteNestedImpl();
    }

    public HTTPRouteFluent.RewriteNested<A> withNewRewriteLike(HTTPRewrite item){
            return new RewriteNestedImpl(item);
    }

    public HTTPRouteFluent.RewriteNested<A> editRewrite(){
            return withNewRewriteLike(getRewrite());
    }

    public HTTPRouteFluent.RewriteNested<A> editOrNewRewrite(){
            return withNewRewriteLike(getRewrite() != null ? getRewrite(): new HTTPRewriteBuilder().build());
    }

    public HTTPRouteFluent.RewriteNested<A> editOrNewRewriteLike(HTTPRewrite item){
            return withNewRewriteLike(getRewrite() != null ? getRewrite(): item);
    }

    public A addToRoute(int index,HTTPRouteDestination item){
            if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
            HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").add(index >= 0 ? index : _visitables.get("route").size(), builder);this.route.add(index >= 0 ? index : route.size(), builder); return (A)this;
    }

    public A setToRoute(int index,HTTPRouteDestination item){
            if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
            HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
            if (index < 0 || index >= _visitables.get("route").size()) { _visitables.get("route").add(builder); } else { _visitables.get("route").set(index, builder);}
            if (index < 0 || index >= route.size()) { route.add(builder); } else { route.set(index, builder);}
             return (A)this;
    }

    public A addToRoute(HTTPRouteDestination... items){
            if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
            for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
    }

    public A addAllToRoute(Collection<HTTPRouteDestination> items){
            if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
            for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
    }

    public A removeFromRoute(HTTPRouteDestination... items){
            for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoute(Collection<HTTPRouteDestination> items){
            for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate){
            if (route == null) return (A) this;
            final Iterator<HTTPRouteDestinationBuilder> each = route.iterator();
            final List visitables = _visitables.get("route");
            while (each.hasNext()) {
              HTTPRouteDestinationBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public List<HTTPRouteDestination> getRoute(){
            return build(route);
    }

    public List<HTTPRouteDestination> buildRoute(){
            return build(route);
    }

    public HTTPRouteDestination buildRoute(int index){
            return this.route.get(index).build();
    }

    public HTTPRouteDestination buildFirstRoute(){
            return this.route.get(0).build();
    }

    public HTTPRouteDestination buildLastRoute(){
            return this.route.get(route.size() - 1).build();
    }

    public HTTPRouteDestination buildMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate){
            for (HTTPRouteDestinationBuilder item: route) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate){
            for (HTTPRouteDestinationBuilder item: route) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRoute(List<HTTPRouteDestination> route){
            if (this.route != null) { _visitables.get("route").removeAll(this.route);}
            if (route != null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>(); for (HTTPRouteDestination item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
    }

    public A withRoute(HTTPRouteDestination... route){
            if (this.route != null) {this.route.clear();}
            if (route != null) {for (HTTPRouteDestination item :route){ this.addToRoute(item);}} return (A) this;
    }

    public Boolean hasRoute(){
            return route != null && !route.isEmpty();
    }

    public HTTPRouteFluent.RouteNested<A> addNewRoute(){
            return new RouteNestedImpl();
    }

    public HTTPRouteFluent.RouteNested<A> addNewRouteLike(HTTPRouteDestination item){
            return new RouteNestedImpl(-1, item);
    }

    public HTTPRouteFluent.RouteNested<A> setNewRouteLike(int index,HTTPRouteDestination item){
            return new RouteNestedImpl(index, item);
    }

    public HTTPRouteFluent.RouteNested<A> editRoute(int index){
            if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public HTTPRouteFluent.RouteNested<A> editFirstRoute(){
            if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
            return setNewRouteLike(0, buildRoute(0));
    }

    public HTTPRouteFluent.RouteNested<A> editLastRoute(){
            int index = route.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public HTTPRouteFluent.RouteNested<A> editMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<HTTPRouteDestinationBuilder> predicate){
            int index = -1;
            for (int i=0;i<route.size();i++) { 
            if (predicate.apply(route.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
            return setNewRouteLike(index, buildRoute(index));
    }

    
/**
 * This method has been deprecated, please use method buildTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getTimeout(){
            return this.timeout!=null?this.timeout.build():null;
    }

    public Duration buildTimeout(){
            return this.timeout!=null?this.timeout.build():null;
    }

    public A withTimeout(Duration timeout){
            _visitables.get("timeout").remove(this.timeout);
            if (timeout!=null){ this.timeout= new DurationBuilder(timeout); _visitables.get("timeout").add(this.timeout);} return (A) this;
    }

    public Boolean hasTimeout(){
            return this.timeout != null;
    }

    public A withNewTimeout(Integer nanos,Long seconds){
            return (A)withTimeout(new Duration(nanos, seconds));
    }

    public HTTPRouteFluent.TimeoutNested<A> withNewTimeout(){
            return new TimeoutNestedImpl();
    }

    public HTTPRouteFluent.TimeoutNested<A> withNewTimeoutLike(Duration item){
            return new TimeoutNestedImpl(item);
    }

    public HTTPRouteFluent.TimeoutNested<A> editTimeout(){
            return withNewTimeoutLike(getTimeout());
    }

    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeout(){
            return withNewTimeoutLike(getTimeout() != null ? getTimeout(): new DurationBuilder().build());
    }

    public HTTPRouteFluent.TimeoutNested<A> editOrNewTimeoutLike(Duration item){
            return withNewTimeoutLike(getTimeout() != null ? getTimeout(): item);
    }

    public Boolean isWebsocketUpgrade(){
            return this.websocketUpgrade;
    }

    public A withWebsocketUpgrade(Boolean websocketUpgrade){
            this.websocketUpgrade=websocketUpgrade; return (A) this;
    }

    public Boolean hasWebsocketUpgrade(){
            return this.websocketUpgrade != null;
    }

    public A withNewWebsocketUpgrade(String arg1){
            return (A)withWebsocketUpgrade(new Boolean(arg1));
    }

    public A withNewWebsocketUpgrade(boolean arg1){
            return (A)withWebsocketUpgrade(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            HTTPRouteFluentImpl that = (HTTPRouteFluentImpl) o;
            if (appendHeaders != null ? !appendHeaders.equals(that.appendHeaders) :that.appendHeaders != null) return false;
            if (appendRequestHeaders != null ? !appendRequestHeaders.equals(that.appendRequestHeaders) :that.appendRequestHeaders != null) return false;
            if (appendResponseHeaders != null ? !appendResponseHeaders.equals(that.appendResponseHeaders) :that.appendResponseHeaders != null) return false;
            if (corsPolicy != null ? !corsPolicy.equals(that.corsPolicy) :that.corsPolicy != null) return false;
            if (fault != null ? !fault.equals(that.fault) :that.fault != null) return false;
            if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
            if (match != null ? !match.equals(that.match) :that.match != null) return false;
            if (mirror != null ? !mirror.equals(that.mirror) :that.mirror != null) return false;
            if (redirect != null ? !redirect.equals(that.redirect) :that.redirect != null) return false;
            if (removeRequestHeaders != null ? !removeRequestHeaders.equals(that.removeRequestHeaders) :that.removeRequestHeaders != null) return false;
            if (removeResponseHeaders != null ? !removeResponseHeaders.equals(that.removeResponseHeaders) :that.removeResponseHeaders != null) return false;
            if (retries != null ? !retries.equals(that.retries) :that.retries != null) return false;
            if (rewrite != null ? !rewrite.equals(that.rewrite) :that.rewrite != null) return false;
            if (route != null ? !route.equals(that.route) :that.route != null) return false;
            if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
            if (websocketUpgrade != null ? !websocketUpgrade.equals(that.websocketUpgrade) :that.websocketUpgrade != null) return false;
            return true;
    }


    public class CorsPolicyNestedImpl<N> extends CorsPolicyFluentImpl<HTTPRouteFluent.CorsPolicyNested<N>> implements HTTPRouteFluent.CorsPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CorsPolicyBuilder builder;
    
            CorsPolicyNestedImpl(CorsPolicy item){
                    this.builder = new CorsPolicyBuilder(this, item);
            }
            CorsPolicyNestedImpl(){
                    this.builder = new CorsPolicyBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withCorsPolicy(builder.build());
    }
    public N endCorsPolicy(){
            return and();
    }

}
    public class FaultNestedImpl<N> extends HTTPFaultInjectionFluentImpl<HTTPRouteFluent.FaultNested<N>> implements HTTPRouteFluent.FaultNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPFaultInjectionBuilder builder;
    
            FaultNestedImpl(HTTPFaultInjection item){
                    this.builder = new HTTPFaultInjectionBuilder(this, item);
            }
            FaultNestedImpl(){
                    this.builder = new HTTPFaultInjectionBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withFault(builder.build());
    }
    public N endFault(){
            return and();
    }

}
    public class HeadersNestedImpl<N> extends HeadersFluentImpl<HTTPRouteFluent.HeadersNested<N>> implements HTTPRouteFluent.HeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HeadersBuilder builder;
    
            HeadersNestedImpl(Headers item){
                    this.builder = new HeadersBuilder(this, item);
            }
            HeadersNestedImpl(){
                    this.builder = new HeadersBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withHeaders(builder.build());
    }
    public N endHeaders(){
            return and();
    }

}
    public class MatchNestedImpl<N> extends HTTPMatchRequestFluentImpl<HTTPRouteFluent.MatchNested<N>> implements HTTPRouteFluent.MatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPMatchRequestBuilder builder;
        private final int index;
    
            MatchNestedImpl(int index,HTTPMatchRequest item){
                    this.index = index;
                    this.builder = new HTTPMatchRequestBuilder(this, item);
            }
            MatchNestedImpl(){
                    this.index = -1;
                    this.builder = new HTTPMatchRequestBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.setToMatch(index, builder.build());
    }
    public N endMatch(){
            return and();
    }

}
    public class MirrorNestedImpl<N> extends DestinationFluentImpl<HTTPRouteFluent.MirrorNested<N>> implements HTTPRouteFluent.MirrorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DestinationBuilder builder;
    
            MirrorNestedImpl(Destination item){
                    this.builder = new DestinationBuilder(this, item);
            }
            MirrorNestedImpl(){
                    this.builder = new DestinationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withMirror(builder.build());
    }
    public N endMirror(){
            return and();
    }

}
    public class RedirectNestedImpl<N> extends HTTPRedirectFluentImpl<HTTPRouteFluent.RedirectNested<N>> implements HTTPRouteFluent.RedirectNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPRedirectBuilder builder;
    
            RedirectNestedImpl(HTTPRedirect item){
                    this.builder = new HTTPRedirectBuilder(this, item);
            }
            RedirectNestedImpl(){
                    this.builder = new HTTPRedirectBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withRedirect(builder.build());
    }
    public N endRedirect(){
            return and();
    }

}
    public class RetriesNestedImpl<N> extends HTTPRetryFluentImpl<HTTPRouteFluent.RetriesNested<N>> implements HTTPRouteFluent.RetriesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPRetryBuilder builder;
    
            RetriesNestedImpl(HTTPRetry item){
                    this.builder = new HTTPRetryBuilder(this, item);
            }
            RetriesNestedImpl(){
                    this.builder = new HTTPRetryBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withRetries(builder.build());
    }
    public N endRetries(){
            return and();
    }

}
    public class RewriteNestedImpl<N> extends HTTPRewriteFluentImpl<HTTPRouteFluent.RewriteNested<N>> implements HTTPRouteFluent.RewriteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPRewriteBuilder builder;
    
            RewriteNestedImpl(HTTPRewrite item){
                    this.builder = new HTTPRewriteBuilder(this, item);
            }
            RewriteNestedImpl(){
                    this.builder = new HTTPRewriteBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withRewrite(builder.build());
    }
    public N endRewrite(){
            return and();
    }

}
    public class RouteNestedImpl<N> extends HTTPRouteDestinationFluentImpl<HTTPRouteFluent.RouteNested<N>> implements HTTPRouteFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HTTPRouteDestinationBuilder builder;
        private final int index;
    
            RouteNestedImpl(int index,HTTPRouteDestination item){
                    this.index = index;
                    this.builder = new HTTPRouteDestinationBuilder(this, item);
            }
            RouteNestedImpl(){
                    this.index = -1;
                    this.builder = new HTTPRouteDestinationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.setToRoute(index, builder.build());
    }
    public N endRoute(){
            return and();
    }

}
    public class TimeoutNestedImpl<N> extends DurationFluentImpl<HTTPRouteFluent.TimeoutNested<N>> implements HTTPRouteFluent.TimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            TimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            TimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) HTTPRouteFluentImpl.this.withTimeout(builder.build());
    }
    public N endTimeout(){
            return and();
    }

}


}
